// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Make a request to simulate the execution of a Method.
type TestInvokeMethodInput struct {
	_ struct{} `type:"structure"`

	// The simulated request body of an incoming invocation request.
	Body *string `locationName:"body" type:"string"`

	// A ClientCertificate identifier to use in the test invocation. API Gateway
	// will use the certificate when making the HTTPS request to the defined back-end
	// endpoint.
	ClientCertificateId *string `locationName:"clientCertificateId" type:"string"`

	// A key-value map of headers to simulate an incoming invocation request.
	Headers map[string]string `locationName:"headers" type:"map"`

	// [Required] Specifies a test invoke method request's HTTP method.
	//
	// HttpMethod is a required field
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// The headers as a map from string to list of values to simulate an incoming
	// invocation request.
	MultiValueHeaders map[string][]string `locationName:"multiValueHeaders" type:"map"`

	// The URI path, including query string, of the simulated invocation request.
	// Use this to specify path parameters and query string parameters.
	PathWithQueryString *string `locationName:"pathWithQueryString" type:"string"`

	// [Required] Specifies a test invoke method request's resource ID.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// A key-value map of stage variables to simulate an invocation on a deployed
	// Stage.
	StageVariables map[string]string `locationName:"stageVariables" type:"map"`
}

// String returns the string representation
func (s TestInvokeMethodInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestInvokeMethodInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TestInvokeMethodInput"}

	if s.HttpMethod == nil {
		invalidParams.Add(aws.NewErrParamRequired("HttpMethod"))
	}

	if s.ResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceId"))
	}

	if s.RestApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RestApiId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TestInvokeMethodInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ClientCertificateId != nil {
		v := *s.ClientCertificateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientCertificateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Headers != nil {
		v := s.Headers

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "headers", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.MultiValueHeaders != nil {
		v := s.MultiValueHeaders

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "multiValueHeaders", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if s.PathWithQueryString != nil {
		v := *s.PathWithQueryString

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pathWithQueryString", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StageVariables != nil {
		v := s.StageVariables

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "stageVariables", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.HttpMethod != nil {
		v := *s.HttpMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "http_method", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceId != nil {
		v := *s.ResourceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "resource_id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RestApiId != nil {
		v := *s.RestApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "restapi_id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents the response of the test invoke request in the HTTP method.
//
// Test API using the API Gateway console (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-test-method.html#how-to-test-method-console)
type TestInvokeMethodOutput struct {
	_ struct{} `type:"structure"`

	// The body of the HTTP response.
	Body *string `locationName:"body" type:"string"`

	// The headers of the HTTP response.
	Headers map[string]string `locationName:"headers" type:"map"`

	// The execution latency of the test invoke request.
	Latency *int64 `locationName:"latency" type:"long"`

	// The API Gateway execution log for the test invoke request.
	Log *string `locationName:"log" type:"string"`

	// The headers of the HTTP response as a map from string to list of values.
	MultiValueHeaders map[string][]string `locationName:"multiValueHeaders" type:"map"`

	// The HTTP status code.
	Status *int64 `locationName:"status" type:"integer"`
}

// String returns the string representation
func (s TestInvokeMethodOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TestInvokeMethodOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Headers != nil {
		v := s.Headers

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "headers", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Latency != nil {
		v := *s.Latency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "latency", protocol.Int64Value(v), metadata)
	}
	if s.Log != nil {
		v := *s.Log

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "log", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MultiValueHeaders != nil {
		v := s.MultiValueHeaders

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "multiValueHeaders", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if s.Status != nil {
		v := *s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.Int64Value(v), metadata)
	}
	return nil
}

const opTestInvokeMethod = "TestInvokeMethod"

// TestInvokeMethodRequest returns a request value for making API operation for
// Amazon API Gateway.
//
// Simulate the execution of a Method in your RestApi with headers, parameters,
// and an incoming request body.
//
//    // Example sending a request using TestInvokeMethodRequest.
//    req := client.TestInvokeMethodRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) TestInvokeMethodRequest(input *TestInvokeMethodInput) TestInvokeMethodRequest {
	op := &aws.Operation{
		Name:       opTestInvokeMethod,
		HTTPMethod: "POST",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}",
	}

	if input == nil {
		input = &TestInvokeMethodInput{}
	}

	req := c.newRequest(op, input, &TestInvokeMethodOutput{})
	return TestInvokeMethodRequest{Request: req, Input: input, Copy: c.TestInvokeMethodRequest}
}

// TestInvokeMethodRequest is the request type for the
// TestInvokeMethod API operation.
type TestInvokeMethodRequest struct {
	*aws.Request
	Input *TestInvokeMethodInput
	Copy  func(*TestInvokeMethodInput) TestInvokeMethodRequest
}

// Send marshals and sends the TestInvokeMethod API request.
func (r TestInvokeMethodRequest) Send(ctx context.Context) (*TestInvokeMethodResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &TestInvokeMethodResponse{
		TestInvokeMethodOutput: r.Request.Data.(*TestInvokeMethodOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// TestInvokeMethodResponse is the response type for the
// TestInvokeMethod API operation.
type TestInvokeMethodResponse struct {
	*TestInvokeMethodOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// TestInvokeMethod request.
func (r *TestInvokeMethodResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
