// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appstream

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateImagePermissionsInput struct {
	_ struct{} `type:"structure"`

	// The permissions for the image.
	//
	// ImagePermissions is a required field
	ImagePermissions *ImagePermissions `type:"structure" required:"true"`

	// The name of the private image.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The 12-digit identifier of the AWS account for which you want add or update
	// image permissions.
	//
	// SharedAccountId is a required field
	SharedAccountId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateImagePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateImagePermissionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateImagePermissionsInput"}

	if s.ImagePermissions == nil {
		invalidParams.Add(aws.NewErrParamRequired("ImagePermissions"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.SharedAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SharedAccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateImagePermissionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateImagePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateImagePermissions = "UpdateImagePermissions"

// UpdateImagePermissionsRequest returns a request value for making API operation for
// Amazon AppStream.
//
// Adds or updates permissions for the specified private image.
//
//    // Example sending a request using UpdateImagePermissionsRequest.
//    req := client.UpdateImagePermissionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateImagePermissions
func (c *Client) UpdateImagePermissionsRequest(input *UpdateImagePermissionsInput) UpdateImagePermissionsRequest {
	op := &aws.Operation{
		Name:       opUpdateImagePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateImagePermissionsInput{}
	}

	req := c.newRequest(op, input, &UpdateImagePermissionsOutput{})
	return UpdateImagePermissionsRequest{Request: req, Input: input, Copy: c.UpdateImagePermissionsRequest}
}

// UpdateImagePermissionsRequest is the request type for the
// UpdateImagePermissions API operation.
type UpdateImagePermissionsRequest struct {
	*aws.Request
	Input *UpdateImagePermissionsInput
	Copy  func(*UpdateImagePermissionsInput) UpdateImagePermissionsRequest
}

// Send marshals and sends the UpdateImagePermissions API request.
func (r UpdateImagePermissionsRequest) Send(ctx context.Context) (*UpdateImagePermissionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateImagePermissionsResponse{
		UpdateImagePermissionsOutput: r.Request.Data.(*UpdateImagePermissionsOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateImagePermissionsResponse is the response type for the
// UpdateImagePermissions API operation.
type UpdateImagePermissionsResponse struct {
	*UpdateImagePermissionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateImagePermissions request.
func (r *UpdateImagePermissionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
