// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appsync

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Describes an additional authentication provider.
type AdditionalAuthenticationProvider struct {
	_ struct{} `type:"structure"`

	// The authentication type: API key, AWS IAM, OIDC, or Amazon Cognito user pools.
	AuthenticationType AuthenticationType `locationName:"authenticationType" type:"string" enum:"true"`

	// The OpenID Connect configuration.
	OpenIDConnectConfig *OpenIDConnectConfig `locationName:"openIDConnectConfig" type:"structure"`

	// The Amazon Cognito user pool configuration.
	UserPoolConfig *CognitoUserPoolConfig `locationName:"userPoolConfig" type:"structure"`
}

// String returns the string representation
func (s AdditionalAuthenticationProvider) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdditionalAuthenticationProvider) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AdditionalAuthenticationProvider"}
	if s.OpenIDConnectConfig != nil {
		if err := s.OpenIDConnectConfig.Validate(); err != nil {
			invalidParams.AddNested("OpenIDConnectConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.UserPoolConfig != nil {
		if err := s.UserPoolConfig.Validate(); err != nil {
			invalidParams.AddNested("UserPoolConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AdditionalAuthenticationProvider) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AuthenticationType) > 0 {
		v := s.AuthenticationType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authenticationType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.OpenIDConnectConfig != nil {
		v := s.OpenIDConnectConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "openIDConnectConfig", v, metadata)
	}
	if s.UserPoolConfig != nil {
		v := s.UserPoolConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "userPoolConfig", v, metadata)
	}
	return nil
}

type ApiCache struct {
	_ struct{} `type:"structure"`

	// Caching behavior.
	//
	//    * FULL_REQUEST_CACHING: All requests are fully cached.
	//
	//    * PER_RESOLVER_CACHING: Individual resovlers that you specify are cached.
	ApiCachingBehavior ApiCachingBehavior `locationName:"apiCachingBehavior" type:"string" enum:"true"`

	// At rest encryption flag for cache. This setting cannot be updated after creation.
	AtRestEncryptionEnabled *bool `locationName:"atRestEncryptionEnabled" type:"boolean"`

	// The cache instance status.
	//
	//    * AVAILABLE: The instance is available for use.
	//
	//    * CREATING: The instance is currently creating.
	//
	//    * DELETING: The instance is currently deleting.
	//
	//    * MODIFYING: The instance is currently modifying.
	//
	//    * FAILED: The instance has failed creation.
	Status ApiCacheStatus `locationName:"status" type:"string" enum:"true"`

	// Transit encryption flag when connecting to cache. This setting cannot be
	// updated after creation.
	TransitEncryptionEnabled *bool `locationName:"transitEncryptionEnabled" type:"boolean"`

	// TTL in seconds for cache entries.
	//
	// Valid values are between 1 and 3600 seconds.
	Ttl *int64 `locationName:"ttl" type:"long"`

	// The cache instance type.
	//
	//    * T2_SMALL: A t2.small instance type.
	//
	//    * T2_MEDIUM: A t2.medium instance type.
	//
	//    * R4_LARGE: A r4.large instance type.
	//
	//    * R4_XLARGE: A r4.xlarge instance type.
	//
	//    * R4_2XLARGE: A r4.2xlarge instance type.
	//
	//    * R4_4XLARGE: A r4.4xlarge instance type.
	//
	//    * R4_8XLARGE: A r4.8xlarge instance type.
	Type ApiCacheType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s ApiCache) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ApiCache) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ApiCachingBehavior) > 0 {
		v := s.ApiCachingBehavior

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiCachingBehavior", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.AtRestEncryptionEnabled != nil {
		v := *s.AtRestEncryptionEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "atRestEncryptionEnabled", protocol.BoolValue(v), metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.TransitEncryptionEnabled != nil {
		v := *s.TransitEncryptionEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "transitEncryptionEnabled", protocol.BoolValue(v), metadata)
	}
	if s.Ttl != nil {
		v := *s.Ttl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ttl", protocol.Int64Value(v), metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Describes an API key.
//
// Customers invoke AWS AppSync GraphQL API operations with API keys as an identity
// mechanism. There are two key versions:
//
// da1: This version was introduced at launch in November 2017. These keys always
// expire after 7 days. Key expiration is managed by Amazon DynamoDB TTL. The
// keys ceased to be valid after February 21, 2018 and should not be used after
// that date.
//
//    * ListApiKeys returns the expiration time in milliseconds.
//
//    * CreateApiKey returns the expiration time in milliseconds.
//
//    * UpdateApiKey is not available for this key version.
//
//    * DeleteApiKey deletes the item from the table.
//
//    * Expiration is stored in Amazon DynamoDB as milliseconds. This results
//    in a bug where keys are not automatically deleted because DynamoDB expects
//    the TTL to be stored in seconds. As a one-time action, we will delete
//    these keys from the table after February 21, 2018.
//
// da2: This version was introduced in February 2018 when AppSync added support
// to extend key expiration.
//
//    * ListApiKeys returns the expiration time in seconds.
//
//    * CreateApiKey returns the expiration time in seconds and accepts a user-provided
//    expiration time in seconds.
//
//    * UpdateApiKey returns the expiration time in seconds and accepts a user-provided
//    expiration time in seconds. Key expiration can only be updated while the
//    key has not expired.
//
//    * DeleteApiKey deletes the item from the table.
//
//    * Expiration is stored in Amazon DynamoDB as seconds.
type ApiKey struct {
	_ struct{} `type:"structure"`

	// A description of the purpose of the API key.
	Description *string `locationName:"description" type:"string"`

	// The time after which the API key expires. The date is represented as seconds
	// since the epoch, rounded down to the nearest hour.
	Expires *int64 `locationName:"expires" type:"long"`

	// The API key ID.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s ApiKey) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ApiKey) MarshalFields(e protocol.FieldEncoder) error {
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Expires != nil {
		v := *s.Expires

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "expires", protocol.Int64Value(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The authorization config in case the HTTP endpoint requires authorization.
type AuthorizationConfig struct {
	_ struct{} `type:"structure"`

	// The authorization type required by the HTTP endpoint.
	//
	//    * AWS_IAM: The authorization type is Sigv4.
	//
	// AuthorizationType is a required field
	AuthorizationType AuthorizationType `locationName:"authorizationType" type:"string" required:"true" enum:"true"`

	// The AWS IAM settings.
	AwsIamConfig *AwsIamConfig `locationName:"awsIamConfig" type:"structure"`
}

// String returns the string representation
func (s AuthorizationConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthorizationConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AuthorizationConfig"}
	if len(s.AuthorizationType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("AuthorizationType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AuthorizationConfig) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AuthorizationType) > 0 {
		v := s.AuthorizationType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizationType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.AwsIamConfig != nil {
		v := s.AwsIamConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "awsIamConfig", v, metadata)
	}
	return nil
}

// The AWS IAM configuration.
type AwsIamConfig struct {
	_ struct{} `type:"structure"`

	// The signing region for AWS IAM authorization.
	SigningRegion *string `locationName:"signingRegion" type:"string"`

	// The signing service name for AWS IAM authorization.
	SigningServiceName *string `locationName:"signingServiceName" type:"string"`
}

// String returns the string representation
func (s AwsIamConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsIamConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.SigningRegion != nil {
		v := *s.SigningRegion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "signingRegion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SigningServiceName != nil {
		v := *s.SigningServiceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "signingServiceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The caching configuration for a resolver that has caching enabled.
type CachingConfig struct {
	_ struct{} `type:"structure"`

	// The caching keys for a resolver that has caching enabled.
	//
	// Valid values are entries from the $context.identity and $context.arguments
	// maps.
	CachingKeys []string `locationName:"cachingKeys" type:"list"`

	// The TTL in seconds for a resolver that has caching enabled.
	//
	// Valid values are between 1 and 3600 seconds.
	Ttl *int64 `locationName:"ttl" type:"long"`
}

// String returns the string representation
func (s CachingConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CachingConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.CachingKeys != nil {
		v := s.CachingKeys

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "cachingKeys", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Ttl != nil {
		v := *s.Ttl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ttl", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Describes an Amazon Cognito user pool configuration.
type CognitoUserPoolConfig struct {
	_ struct{} `type:"structure"`

	// A regular expression for validating the incoming Amazon Cognito user pool
	// app client ID.
	AppIdClientRegex *string `locationName:"appIdClientRegex" type:"string"`

	// The AWS Region in which the user pool was created.
	//
	// AwsRegion is a required field
	AwsRegion *string `locationName:"awsRegion" type:"string" required:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `locationName:"userPoolId" type:"string" required:"true"`
}

// String returns the string representation
func (s CognitoUserPoolConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CognitoUserPoolConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CognitoUserPoolConfig"}

	if s.AwsRegion == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsRegion"))
	}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CognitoUserPoolConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.AppIdClientRegex != nil {
		v := *s.AppIdClientRegex

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "appIdClientRegex", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AwsRegion != nil {
		v := *s.AwsRegion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "awsRegion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserPoolId != nil {
		v := *s.UserPoolId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "userPoolId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes a data source.
type DataSource struct {
	_ struct{} `type:"structure"`

	// The data source ARN.
	DataSourceArn *string `locationName:"dataSourceArn" type:"string"`

	// The description of the data source.
	Description *string `locationName:"description" type:"string"`

	// Amazon DynamoDB settings.
	DynamodbConfig *DynamodbDataSourceConfig `locationName:"dynamodbConfig" type:"structure"`

	// Amazon Elasticsearch Service settings.
	ElasticsearchConfig *ElasticsearchDataSourceConfig `locationName:"elasticsearchConfig" type:"structure"`

	// HTTP endpoint settings.
	HttpConfig *HttpDataSourceConfig `locationName:"httpConfig" type:"structure"`

	// AWS Lambda settings.
	LambdaConfig *LambdaDataSourceConfig `locationName:"lambdaConfig" type:"structure"`

	// The name of the data source.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Relational database settings.
	RelationalDatabaseConfig *RelationalDatabaseDataSourceConfig `locationName:"relationalDatabaseConfig" type:"structure"`

	// The AWS IAM service role ARN for the data source. The system assumes this
	// role when accessing the data source.
	ServiceRoleArn *string `locationName:"serviceRoleArn" type:"string"`

	// The type of the data source.
	//
	//    * AMAZON_DYNAMODB: The data source is an Amazon DynamoDB table.
	//
	//    * AMAZON_ELASTICSEARCH: The data source is an Amazon Elasticsearch Service
	//    domain.
	//
	//    * AWS_LAMBDA: The data source is an AWS Lambda function.
	//
	//    * NONE: There is no data source. This type is used when you wish to invoke
	//    a GraphQL operation without connecting to a data source, such as performing
	//    data transformation with resolvers or triggering a subscription to be
	//    invoked from a mutation.
	//
	//    * HTTP: The data source is an HTTP endpoint.
	//
	//    * RELATIONAL_DATABASE: The data source is a relational database.
	Type DataSourceType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DataSource) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataSourceArn != nil {
		v := *s.DataSourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataSourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DynamodbConfig != nil {
		v := s.DynamodbConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "dynamodbConfig", v, metadata)
	}
	if s.ElasticsearchConfig != nil {
		v := s.ElasticsearchConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "elasticsearchConfig", v, metadata)
	}
	if s.HttpConfig != nil {
		v := s.HttpConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "httpConfig", v, metadata)
	}
	if s.LambdaConfig != nil {
		v := s.LambdaConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "lambdaConfig", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RelationalDatabaseConfig != nil {
		v := s.RelationalDatabaseConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "relationalDatabaseConfig", v, metadata)
	}
	if s.ServiceRoleArn != nil {
		v := *s.ServiceRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "serviceRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Describes a Delta Sync configuration.
type DeltaSyncConfig struct {
	_ struct{} `type:"structure"`

	// The number of minutes an Item is stored in the datasource.
	BaseTableTTL *int64 `locationName:"baseTableTTL" type:"long"`

	// The Delta Sync table name.
	DeltaSyncTableName *string `locationName:"deltaSyncTableName" type:"string"`

	// The number of minutes a Delta Sync log entry is stored in the Delta Sync
	// table.
	DeltaSyncTableTTL *int64 `locationName:"deltaSyncTableTTL" type:"long"`
}

// String returns the string representation
func (s DeltaSyncConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeltaSyncConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.BaseTableTTL != nil {
		v := *s.BaseTableTTL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "baseTableTTL", protocol.Int64Value(v), metadata)
	}
	if s.DeltaSyncTableName != nil {
		v := *s.DeltaSyncTableName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deltaSyncTableName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeltaSyncTableTTL != nil {
		v := *s.DeltaSyncTableTTL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deltaSyncTableTTL", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Describes an Amazon DynamoDB data source configuration.
type DynamodbDataSourceConfig struct {
	_ struct{} `type:"structure"`

	// The AWS Region.
	//
	// AwsRegion is a required field
	AwsRegion *string `locationName:"awsRegion" type:"string" required:"true"`

	// The DeltaSyncConfig for a versioned datasource.
	DeltaSyncConfig *DeltaSyncConfig `locationName:"deltaSyncConfig" type:"structure"`

	// The table name.
	//
	// TableName is a required field
	TableName *string `locationName:"tableName" type:"string" required:"true"`

	// Set to TRUE to use Amazon Cognito credentials with this data source.
	UseCallerCredentials *bool `locationName:"useCallerCredentials" type:"boolean"`

	// Set to TRUE to use Conflict Detection and Resolution with this data source.
	Versioned *bool `locationName:"versioned" type:"boolean"`
}

// String returns the string representation
func (s DynamodbDataSourceConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DynamodbDataSourceConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DynamodbDataSourceConfig"}

	if s.AwsRegion == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsRegion"))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DynamodbDataSourceConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.AwsRegion != nil {
		v := *s.AwsRegion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "awsRegion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeltaSyncConfig != nil {
		v := s.DeltaSyncConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "deltaSyncConfig", v, metadata)
	}
	if s.TableName != nil {
		v := *s.TableName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "tableName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UseCallerCredentials != nil {
		v := *s.UseCallerCredentials

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "useCallerCredentials", protocol.BoolValue(v), metadata)
	}
	if s.Versioned != nil {
		v := *s.Versioned

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "versioned", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Describes an Elasticsearch data source configuration.
type ElasticsearchDataSourceConfig struct {
	_ struct{} `type:"structure"`

	// The AWS Region.
	//
	// AwsRegion is a required field
	AwsRegion *string `locationName:"awsRegion" type:"string" required:"true"`

	// The endpoint.
	//
	// Endpoint is a required field
	Endpoint *string `locationName:"endpoint" type:"string" required:"true"`
}

// String returns the string representation
func (s ElasticsearchDataSourceConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ElasticsearchDataSourceConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ElasticsearchDataSourceConfig"}

	if s.AwsRegion == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsRegion"))
	}

	if s.Endpoint == nil {
		invalidParams.Add(aws.NewErrParamRequired("Endpoint"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ElasticsearchDataSourceConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.AwsRegion != nil {
		v := *s.AwsRegion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "awsRegion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Endpoint != nil {
		v := *s.Endpoint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "endpoint", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A function is a reusable entity. Multiple functions can be used to compose
// the resolver logic.
type FunctionConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the DataSource.
	DataSourceName *string `locationName:"dataSourceName" min:"1" type:"string"`

	// The Function description.
	Description *string `locationName:"description" type:"string"`

	// The ARN of the Function object.
	FunctionArn *string `locationName:"functionArn" type:"string"`

	// A unique ID representing the Function object.
	FunctionId *string `locationName:"functionId" type:"string"`

	// The version of the request mapping template. Currently only the 2018-05-29
	// version of the template is supported.
	FunctionVersion *string `locationName:"functionVersion" type:"string"`

	// The name of the Function object.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Function request mapping template. Functions support only the 2018-05-29
	// version of the request mapping template.
	RequestMappingTemplate *string `locationName:"requestMappingTemplate" min:"1" type:"string"`

	// The Function response mapping template.
	ResponseMappingTemplate *string `locationName:"responseMappingTemplate" min:"1" type:"string"`
}

// String returns the string representation
func (s FunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FunctionConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataSourceName != nil {
		v := *s.DataSourceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataSourceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionArn != nil {
		v := *s.FunctionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "functionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionId != nil {
		v := *s.FunctionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "functionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionVersion != nil {
		v := *s.FunctionVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "functionVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestMappingTemplate != nil {
		v := *s.RequestMappingTemplate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "requestMappingTemplate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResponseMappingTemplate != nil {
		v := *s.ResponseMappingTemplate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "responseMappingTemplate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes a GraphQL API.
type GraphqlApi struct {
	_ struct{} `type:"structure"`

	// A list of additional authentication providers for the GraphqlApi API.
	AdditionalAuthenticationProviders []AdditionalAuthenticationProvider `locationName:"additionalAuthenticationProviders" type:"list"`

	// The API ID.
	ApiId *string `locationName:"apiId" type:"string"`

	// The ARN.
	Arn *string `locationName:"arn" type:"string"`

	// The authentication type.
	AuthenticationType AuthenticationType `locationName:"authenticationType" type:"string" enum:"true"`

	// The Amazon CloudWatch Logs configuration.
	LogConfig *LogConfig `locationName:"logConfig" type:"structure"`

	// The API name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The OpenID Connect configuration.
	OpenIDConnectConfig *OpenIDConnectConfig `locationName:"openIDConnectConfig" type:"structure"`

	// The tags.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`

	// The URIs.
	Uris map[string]string `locationName:"uris" type:"map"`

	// The Amazon Cognito user pool configuration.
	UserPoolConfig *UserPoolConfig `locationName:"userPoolConfig" type:"structure"`
}

// String returns the string representation
func (s GraphqlApi) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GraphqlApi) MarshalFields(e protocol.FieldEncoder) error {
	if s.AdditionalAuthenticationProviders != nil {
		v := s.AdditionalAuthenticationProviders

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "additionalAuthenticationProviders", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.AuthenticationType) > 0 {
		v := s.AuthenticationType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authenticationType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.LogConfig != nil {
		v := s.LogConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "logConfig", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OpenIDConnectConfig != nil {
		v := s.OpenIDConnectConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "openIDConnectConfig", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Uris != nil {
		v := s.Uris

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "uris", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.UserPoolConfig != nil {
		v := s.UserPoolConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "userPoolConfig", v, metadata)
	}
	return nil
}

// Describes an HTTP data source configuration.
type HttpDataSourceConfig struct {
	_ struct{} `type:"structure"`

	// The authorization config in case the HTTP endpoint requires authorization.
	AuthorizationConfig *AuthorizationConfig `locationName:"authorizationConfig" type:"structure"`

	// The HTTP URL endpoint. You can either specify the domain name or IP, and
	// port combination, and the URL scheme must be HTTP or HTTPS. If the port is
	// not specified, AWS AppSync uses the default port 80 for the HTTP endpoint
	// and port 443 for HTTPS endpoints.
	Endpoint *string `locationName:"endpoint" type:"string"`
}

// String returns the string representation
func (s HttpDataSourceConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpDataSourceConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HttpDataSourceConfig"}
	if s.AuthorizationConfig != nil {
		if err := s.AuthorizationConfig.Validate(); err != nil {
			invalidParams.AddNested("AuthorizationConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HttpDataSourceConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.AuthorizationConfig != nil {
		v := s.AuthorizationConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "authorizationConfig", v, metadata)
	}
	if s.Endpoint != nil {
		v := *s.Endpoint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "endpoint", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type LambdaConflictHandlerConfig struct {
	_ struct{} `type:"structure"`

	// The Arn for the Lambda function to use as the Conflict Handler.
	LambdaConflictHandlerArn *string `locationName:"lambdaConflictHandlerArn" type:"string"`
}

// String returns the string representation
func (s LambdaConflictHandlerConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LambdaConflictHandlerConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.LambdaConflictHandlerArn != nil {
		v := *s.LambdaConflictHandlerArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lambdaConflictHandlerArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes an AWS Lambda data source configuration.
type LambdaDataSourceConfig struct {
	_ struct{} `type:"structure"`

	// The ARN for the Lambda function.
	//
	// LambdaFunctionArn is a required field
	LambdaFunctionArn *string `locationName:"lambdaFunctionArn" type:"string" required:"true"`
}

// String returns the string representation
func (s LambdaDataSourceConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaDataSourceConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LambdaDataSourceConfig"}

	if s.LambdaFunctionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("LambdaFunctionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LambdaDataSourceConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.LambdaFunctionArn != nil {
		v := *s.LambdaFunctionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lambdaFunctionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The CloudWatch Logs configuration.
type LogConfig struct {
	_ struct{} `type:"structure"`

	// The service role that AWS AppSync will assume to publish to Amazon CloudWatch
	// logs in your account.
	//
	// CloudWatchLogsRoleArn is a required field
	CloudWatchLogsRoleArn *string `locationName:"cloudWatchLogsRoleArn" type:"string" required:"true"`

	// Set to TRUE to exclude sections that contain information such as headers,
	// context, and evaluated mapping templates, regardless of logging level.
	ExcludeVerboseContent *bool `locationName:"excludeVerboseContent" type:"boolean"`

	// The field logging level. Values can be NONE, ERROR, or ALL.
	//
	//    * NONE: No field-level logs are captured.
	//
	//    * ERROR: Logs the following information only for the fields that are in
	//    error: The error section in the server response. Field-level errors. The
	//    generated request/response functions that got resolved for error fields.
	//
	//    * ALL: The following information is logged for all fields in the query:
	//    Field-level tracing information. The generated request/response functions
	//    that got resolved for each field.
	//
	// FieldLogLevel is a required field
	FieldLogLevel FieldLogLevel `locationName:"fieldLogLevel" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s LogConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LogConfig"}

	if s.CloudWatchLogsRoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("CloudWatchLogsRoleArn"))
	}
	if len(s.FieldLogLevel) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("FieldLogLevel"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LogConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.CloudWatchLogsRoleArn != nil {
		v := *s.CloudWatchLogsRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "cloudWatchLogsRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ExcludeVerboseContent != nil {
		v := *s.ExcludeVerboseContent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "excludeVerboseContent", protocol.BoolValue(v), metadata)
	}
	if len(s.FieldLogLevel) > 0 {
		v := s.FieldLogLevel

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fieldLogLevel", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Describes an OpenID Connect configuration.
type OpenIDConnectConfig struct {
	_ struct{} `type:"structure"`

	// The number of milliseconds a token is valid after being authenticated.
	AuthTTL *int64 `locationName:"authTTL" type:"long"`

	// The client identifier of the Relying party at the OpenID identity provider.
	// This identifier is typically obtained when the Relying party is registered
	// with the OpenID identity provider. You can specify a regular expression so
	// the AWS AppSync can validate against multiple client identifiers at a time.
	ClientId *string `locationName:"clientId" type:"string"`

	// The number of milliseconds a token is valid after being issued to a user.
	IatTTL *int64 `locationName:"iatTTL" type:"long"`

	// The issuer for the OpenID Connect configuration. The issuer returned by discovery
	// must exactly match the value of iss in the ID token.
	//
	// Issuer is a required field
	Issuer *string `locationName:"issuer" type:"string" required:"true"`
}

// String returns the string representation
func (s OpenIDConnectConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OpenIDConnectConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OpenIDConnectConfig"}

	if s.Issuer == nil {
		invalidParams.Add(aws.NewErrParamRequired("Issuer"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OpenIDConnectConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.AuthTTL != nil {
		v := *s.AuthTTL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authTTL", protocol.Int64Value(v), metadata)
	}
	if s.ClientId != nil {
		v := *s.ClientId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IatTTL != nil {
		v := *s.IatTTL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "iatTTL", protocol.Int64Value(v), metadata)
	}
	if s.Issuer != nil {
		v := *s.Issuer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "issuer", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The pipeline configuration for a resolver of kind PIPELINE.
type PipelineConfig struct {
	_ struct{} `type:"structure"`

	// A list of Function objects.
	Functions []string `locationName:"functions" type:"list"`
}

// String returns the string representation
func (s PipelineConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PipelineConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.Functions != nil {
		v := s.Functions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "functions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// The Amazon RDS HTTP endpoint configuration.
type RdsHttpEndpointConfig struct {
	_ struct{} `type:"structure"`

	// AWS Region for RDS HTTP endpoint.
	AwsRegion *string `locationName:"awsRegion" type:"string"`

	// AWS secret store ARN for database credentials.
	AwsSecretStoreArn *string `locationName:"awsSecretStoreArn" type:"string"`

	// Logical database name.
	DatabaseName *string `locationName:"databaseName" type:"string"`

	// Amazon RDS cluster identifier.
	DbClusterIdentifier *string `locationName:"dbClusterIdentifier" type:"string"`

	// Logical schema name.
	Schema *string `locationName:"schema" type:"string"`
}

// String returns the string representation
func (s RdsHttpEndpointConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RdsHttpEndpointConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.AwsRegion != nil {
		v := *s.AwsRegion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "awsRegion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AwsSecretStoreArn != nil {
		v := *s.AwsSecretStoreArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "awsSecretStoreArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DatabaseName != nil {
		v := *s.DatabaseName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "databaseName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DbClusterIdentifier != nil {
		v := *s.DbClusterIdentifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dbClusterIdentifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Schema != nil {
		v := *s.Schema

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "schema", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes a relational database data source configuration.
type RelationalDatabaseDataSourceConfig struct {
	_ struct{} `type:"structure"`

	// Amazon RDS HTTP endpoint settings.
	RdsHttpEndpointConfig *RdsHttpEndpointConfig `locationName:"rdsHttpEndpointConfig" type:"structure"`

	// Source type for the relational database.
	//
	//    * RDS_HTTP_ENDPOINT: The relational database source type is an Amazon
	//    RDS HTTP endpoint.
	RelationalDatabaseSourceType RelationalDatabaseSourceType `locationName:"relationalDatabaseSourceType" type:"string" enum:"true"`
}

// String returns the string representation
func (s RelationalDatabaseDataSourceConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RelationalDatabaseDataSourceConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.RdsHttpEndpointConfig != nil {
		v := s.RdsHttpEndpointConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "rdsHttpEndpointConfig", v, metadata)
	}
	if len(s.RelationalDatabaseSourceType) > 0 {
		v := s.RelationalDatabaseSourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "relationalDatabaseSourceType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Describes a resolver.
type Resolver struct {
	_ struct{} `type:"structure"`

	// The caching configuration for the resolver.
	CachingConfig *CachingConfig `locationName:"cachingConfig" type:"structure"`

	// The resolver data source name.
	DataSourceName *string `locationName:"dataSourceName" min:"1" type:"string"`

	// The resolver field name.
	FieldName *string `locationName:"fieldName" min:"1" type:"string"`

	// The resolver type.
	//
	//    * UNIT: A UNIT resolver type. A UNIT resolver is the default resolver
	//    type. A UNIT resolver enables you to execute a GraphQL query against a
	//    single data source.
	//
	//    * PIPELINE: A PIPELINE resolver type. A PIPELINE resolver enables you
	//    to execute a series of Function in a serial manner. You can use a pipeline
	//    resolver to execute a GraphQL query against multiple data sources.
	Kind ResolverKind `locationName:"kind" type:"string" enum:"true"`

	// The PipelineConfig.
	PipelineConfig *PipelineConfig `locationName:"pipelineConfig" type:"structure"`

	// The request mapping template.
	RequestMappingTemplate *string `locationName:"requestMappingTemplate" min:"1" type:"string"`

	// The resolver ARN.
	ResolverArn *string `locationName:"resolverArn" type:"string"`

	// The response mapping template.
	ResponseMappingTemplate *string `locationName:"responseMappingTemplate" min:"1" type:"string"`

	// The SyncConfig for a resolver attached to a versioned datasource.
	SyncConfig *SyncConfig `locationName:"syncConfig" type:"structure"`

	// The resolver type name.
	TypeName *string `locationName:"typeName" min:"1" type:"string"`
}

// String returns the string representation
func (s Resolver) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Resolver) MarshalFields(e protocol.FieldEncoder) error {
	if s.CachingConfig != nil {
		v := s.CachingConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "cachingConfig", v, metadata)
	}
	if s.DataSourceName != nil {
		v := *s.DataSourceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataSourceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FieldName != nil {
		v := *s.FieldName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fieldName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Kind) > 0 {
		v := s.Kind

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "kind", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.PipelineConfig != nil {
		v := s.PipelineConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "pipelineConfig", v, metadata)
	}
	if s.RequestMappingTemplate != nil {
		v := *s.RequestMappingTemplate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "requestMappingTemplate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResolverArn != nil {
		v := *s.ResolverArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resolverArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResponseMappingTemplate != nil {
		v := *s.ResponseMappingTemplate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "responseMappingTemplate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SyncConfig != nil {
		v := s.SyncConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "syncConfig", v, metadata)
	}
	if s.TypeName != nil {
		v := *s.TypeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "typeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes a Sync configuration for a resolver.
//
// Contains information on which Conflict Detection as well as Resolution strategy
// should be performed when the resolver is invoked.
type SyncConfig struct {
	_ struct{} `type:"structure"`

	// The Conflict Detection strategy to use.
	//
	//    * VERSION: Detect conflicts based on object versions for this resolver.
	//
	//    * NONE: Do not detect conflicts when executing this resolver.
	ConflictDetection ConflictDetectionType `locationName:"conflictDetection" type:"string" enum:"true"`

	// The Conflict Resolution strategy to perform in the event of a conflict.
	//
	//    * OPTIMISTIC_CONCURRENCY: Resolve conflicts by rejecting mutations when
	//    versions do not match the latest version at the server.
	//
	//    * AUTOMERGE: Resolve conflicts with the Automerge conflict resolution
	//    strategy.
	//
	//    * LAMBDA: Resolve conflicts with a Lambda function supplied in the LambdaConflictHandlerConfig.
	ConflictHandler ConflictHandlerType `locationName:"conflictHandler" type:"string" enum:"true"`

	// The LambdaConflictHandlerConfig when configuring LAMBDA as the Conflict Handler.
	LambdaConflictHandlerConfig *LambdaConflictHandlerConfig `locationName:"lambdaConflictHandlerConfig" type:"structure"`
}

// String returns the string representation
func (s SyncConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SyncConfig) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ConflictDetection) > 0 {
		v := s.ConflictDetection

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "conflictDetection", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.ConflictHandler) > 0 {
		v := s.ConflictHandler

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "conflictHandler", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.LambdaConflictHandlerConfig != nil {
		v := s.LambdaConflictHandlerConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "lambdaConflictHandlerConfig", v, metadata)
	}
	return nil
}

// Describes a type.
type Type struct {
	_ struct{} `type:"structure"`

	// The type ARN.
	Arn *string `locationName:"arn" type:"string"`

	// The type definition.
	Definition *string `locationName:"definition" type:"string"`

	// The type description.
	Description *string `locationName:"description" type:"string"`

	// The type format: SDL or JSON.
	Format TypeDefinitionFormat `locationName:"format" type:"string" enum:"true"`

	// The type name.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s Type) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Type) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Definition != nil {
		v := *s.Definition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "definition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes an Amazon Cognito user pool configuration.
type UserPoolConfig struct {
	_ struct{} `type:"structure"`

	// A regular expression for validating the incoming Amazon Cognito user pool
	// app client ID.
	AppIdClientRegex *string `locationName:"appIdClientRegex" type:"string"`

	// The AWS Region in which the user pool was created.
	//
	// AwsRegion is a required field
	AwsRegion *string `locationName:"awsRegion" type:"string" required:"true"`

	// The action that you want your GraphQL API to take when a request that uses
	// Amazon Cognito user pool authentication doesn't match the Amazon Cognito
	// user pool configuration.
	//
	// DefaultAction is a required field
	DefaultAction DefaultAction `locationName:"defaultAction" type:"string" required:"true" enum:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `locationName:"userPoolId" type:"string" required:"true"`
}

// String returns the string representation
func (s UserPoolConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserPoolConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UserPoolConfig"}

	if s.AwsRegion == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsRegion"))
	}
	if len(s.DefaultAction) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("DefaultAction"))
	}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UserPoolConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.AppIdClientRegex != nil {
		v := *s.AppIdClientRegex

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "appIdClientRegex", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AwsRegion != nil {
		v := *s.AwsRegion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "awsRegion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.DefaultAction) > 0 {
		v := s.DefaultAction

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "defaultAction", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.UserPoolId != nil {
		v := *s.UserPoolId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "userPoolId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
