// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DisassociatePhoneNumbersFromVoiceConnectorGroupInput struct {
	_ struct{} `type:"structure"`

	// List of phone numbers, in E.164 format.
	E164PhoneNumbers []string `type:"list"`

	// The Amazon Chime Voice Connector group ID.
	//
	// VoiceConnectorGroupId is a required field
	VoiceConnectorGroupId *string `location:"uri" locationName:"voiceConnectorGroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociatePhoneNumbersFromVoiceConnectorGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociatePhoneNumbersFromVoiceConnectorGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociatePhoneNumbersFromVoiceConnectorGroupInput"}

	if s.VoiceConnectorGroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VoiceConnectorGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisassociatePhoneNumbersFromVoiceConnectorGroupInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.E164PhoneNumbers != nil {
		v := s.E164PhoneNumbers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "E164PhoneNumbers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.VoiceConnectorGroupId != nil {
		v := *s.VoiceConnectorGroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "voiceConnectorGroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DisassociatePhoneNumbersFromVoiceConnectorGroupOutput struct {
	_ struct{} `type:"structure"`

	// If the action fails for one or more of the phone numbers in the request,
	// a list of the phone numbers is returned, along with error codes and error
	// messages.
	PhoneNumberErrors []PhoneNumberError `type:"list"`
}

// String returns the string representation
func (s DisassociatePhoneNumbersFromVoiceConnectorGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisassociatePhoneNumbersFromVoiceConnectorGroupOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.PhoneNumberErrors != nil {
		v := s.PhoneNumberErrors

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "PhoneNumberErrors", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opDisassociatePhoneNumbersFromVoiceConnectorGroup = "DisassociatePhoneNumbersFromVoiceConnectorGroup"

// DisassociatePhoneNumbersFromVoiceConnectorGroupRequest returns a request value for making API operation for
// Amazon Chime.
//
// Disassociates the specified phone numbers from the specified Amazon Chime
// Voice Connector group.
//
//    // Example sending a request using DisassociatePhoneNumbersFromVoiceConnectorGroupRequest.
//    req := client.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociatePhoneNumbersFromVoiceConnectorGroup
func (c *Client) DisassociatePhoneNumbersFromVoiceConnectorGroupRequest(input *DisassociatePhoneNumbersFromVoiceConnectorGroupInput) DisassociatePhoneNumbersFromVoiceConnectorGroupRequest {
	op := &aws.Operation{
		Name:       opDisassociatePhoneNumbersFromVoiceConnectorGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connector-groups/{voiceConnectorGroupId}?operation=disassociate-phone-numbers",
	}

	if input == nil {
		input = &DisassociatePhoneNumbersFromVoiceConnectorGroupInput{}
	}

	req := c.newRequest(op, input, &DisassociatePhoneNumbersFromVoiceConnectorGroupOutput{})
	return DisassociatePhoneNumbersFromVoiceConnectorGroupRequest{Request: req, Input: input, Copy: c.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest}
}

// DisassociatePhoneNumbersFromVoiceConnectorGroupRequest is the request type for the
// DisassociatePhoneNumbersFromVoiceConnectorGroup API operation.
type DisassociatePhoneNumbersFromVoiceConnectorGroupRequest struct {
	*aws.Request
	Input *DisassociatePhoneNumbersFromVoiceConnectorGroupInput
	Copy  func(*DisassociatePhoneNumbersFromVoiceConnectorGroupInput) DisassociatePhoneNumbersFromVoiceConnectorGroupRequest
}

// Send marshals and sends the DisassociatePhoneNumbersFromVoiceConnectorGroup API request.
func (r DisassociatePhoneNumbersFromVoiceConnectorGroupRequest) Send(ctx context.Context) (*DisassociatePhoneNumbersFromVoiceConnectorGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociatePhoneNumbersFromVoiceConnectorGroupResponse{
		DisassociatePhoneNumbersFromVoiceConnectorGroupOutput: r.Request.Data.(*DisassociatePhoneNumbersFromVoiceConnectorGroupOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociatePhoneNumbersFromVoiceConnectorGroupResponse is the response type for the
// DisassociatePhoneNumbersFromVoiceConnectorGroup API operation.
type DisassociatePhoneNumbersFromVoiceConnectorGroupResponse struct {
	*DisassociatePhoneNumbersFromVoiceConnectorGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociatePhoneNumbersFromVoiceConnectorGroup request.
func (r *DisassociatePhoneNumbersFromVoiceConnectorGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
