// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetPhoneNumberSettingsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetPhoneNumberSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetPhoneNumberSettingsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	return nil
}

type GetPhoneNumberSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The default outbound calling name for the account.
	CallingName *string `type:"string" sensitive:"true"`

	// The updated outbound calling name timestamp, in ISO 8601 format.
	CallingNameUpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s GetPhoneNumberSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetPhoneNumberSettingsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CallingName != nil {
		v := *s.CallingName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CallingName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CallingNameUpdatedTimestamp != nil {
		v := *s.CallingNameUpdatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CallingNameUpdatedTimestamp",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

const opGetPhoneNumberSettings = "GetPhoneNumberSettings"

// GetPhoneNumberSettingsRequest returns a request value for making API operation for
// Amazon Chime.
//
// Retrieves the phone number settings for the administrator's AWS account,
// such as the default outbound calling name.
//
//    // Example sending a request using GetPhoneNumberSettingsRequest.
//    req := client.GetPhoneNumberSettingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetPhoneNumberSettings
func (c *Client) GetPhoneNumberSettingsRequest(input *GetPhoneNumberSettingsInput) GetPhoneNumberSettingsRequest {
	op := &aws.Operation{
		Name:       opGetPhoneNumberSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/settings/phone-number",
	}

	if input == nil {
		input = &GetPhoneNumberSettingsInput{}
	}

	req := c.newRequest(op, input, &GetPhoneNumberSettingsOutput{})
	return GetPhoneNumberSettingsRequest{Request: req, Input: input, Copy: c.GetPhoneNumberSettingsRequest}
}

// GetPhoneNumberSettingsRequest is the request type for the
// GetPhoneNumberSettings API operation.
type GetPhoneNumberSettingsRequest struct {
	*aws.Request
	Input *GetPhoneNumberSettingsInput
	Copy  func(*GetPhoneNumberSettingsInput) GetPhoneNumberSettingsRequest
}

// Send marshals and sends the GetPhoneNumberSettings API request.
func (r GetPhoneNumberSettingsRequest) Send(ctx context.Context) (*GetPhoneNumberSettingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetPhoneNumberSettingsResponse{
		GetPhoneNumberSettingsOutput: r.Request.Data.(*GetPhoneNumberSettingsOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetPhoneNumberSettingsResponse is the response type for the
// GetPhoneNumberSettings API operation.
type GetPhoneNumberSettingsResponse struct {
	*GetPhoneNumberSettingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetPhoneNumberSettings request.
func (r *GetPhoneNumberSettingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
