// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudtrail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetInsightSelectorsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the trail or trail ARN. If you specify a trail name,
	// the string must meet the following requirements:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
	//    (_), or dashes (-)
	//
	//    * Start with a letter or number, and end with a letter or number
	//
	//    * Be between 3 and 128 characters
	//
	//    * Have no adjacent periods, underscores or dashes. Names like my-_namespace
	//    and my--namespace are not valid.
	//
	//    * Not be in IP address format (for example, 192.168.5.4)
	//
	// If you specify a trail ARN, it must be in the format:
	//
	// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	//
	// TrailName is a required field
	TrailName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetInsightSelectorsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInsightSelectorsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetInsightSelectorsInput"}

	if s.TrailName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrailName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetInsightSelectorsOutput struct {
	_ struct{} `type:"structure"`

	// A JSON string that contains the insight types you want to log on a trail.
	// In this release, only ApiCallRateInsight is supported as an insight type.
	InsightSelectors []InsightSelector `type:"list"`

	// The Amazon Resource Name (ARN) of a trail for which you want to get Insights
	// selectors.
	TrailARN *string `type:"string"`
}

// String returns the string representation
func (s GetInsightSelectorsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetInsightSelectors = "GetInsightSelectors"

// GetInsightSelectorsRequest returns a request value for making API operation for
// AWS CloudTrail.
//
// Describes the settings for the Insights event selectors that you configured
// for your trail. GetInsightSelectors shows if CloudTrail Insights event logging
// is enabled on the trail, and if it is, which insight types are enabled. If
// you run GetInsightSelectors on a trail that does not have Insights events
// enabled, the operation throws the exception InsightNotEnabledException
//
// For more information, see Logging CloudTrail Insights Events for Trails (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html)
// in the AWS CloudTrail User Guide.
//
//    // Example sending a request using GetInsightSelectorsRequest.
//    req := client.GetInsightSelectorsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetInsightSelectors
func (c *Client) GetInsightSelectorsRequest(input *GetInsightSelectorsInput) GetInsightSelectorsRequest {
	op := &aws.Operation{
		Name:       opGetInsightSelectors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInsightSelectorsInput{}
	}

	req := c.newRequest(op, input, &GetInsightSelectorsOutput{})
	return GetInsightSelectorsRequest{Request: req, Input: input, Copy: c.GetInsightSelectorsRequest}
}

// GetInsightSelectorsRequest is the request type for the
// GetInsightSelectors API operation.
type GetInsightSelectorsRequest struct {
	*aws.Request
	Input *GetInsightSelectorsInput
	Copy  func(*GetInsightSelectorsInput) GetInsightSelectorsRequest
}

// Send marshals and sends the GetInsightSelectors API request.
func (r GetInsightSelectorsRequest) Send(ctx context.Context) (*GetInsightSelectorsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetInsightSelectorsResponse{
		GetInsightSelectorsOutput: r.Request.Data.(*GetInsightSelectorsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetInsightSelectorsResponse is the response type for the
// GetInsightSelectors API operation.
type GetInsightSelectorsResponse struct {
	*GetInsightSelectorsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetInsightSelectors request.
func (r *GetInsightSelectorsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
