// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatchevents

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type ActivateEventSourceInput struct {
	_ struct{} `type:"structure"`

	// The name of the partner event source to activate.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ActivateEventSourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActivateEventSourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ActivateEventSourceInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ActivateEventSourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ActivateEventSourceOutput) String() string {
	return awsutil.Prettify(s)
}

const opActivateEventSource = "ActivateEventSource"

// ActivateEventSourceRequest returns a request value for making API operation for
// Amazon CloudWatch Events.
//
// Activates a partner event source that has been deactivated. Once activated,
// your matching event bus will start receiving events from the event source.
//
// This operation is performed by AWS customers, not by SaaS partners.
//
//    // Example sending a request using ActivateEventSourceRequest.
//    req := client.ActivateEventSourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ActivateEventSource
func (c *Client) ActivateEventSourceRequest(input *ActivateEventSourceInput) ActivateEventSourceRequest {
	op := &aws.Operation{
		Name:       opActivateEventSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ActivateEventSourceInput{}
	}

	req := c.newRequest(op, input, &ActivateEventSourceOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return ActivateEventSourceRequest{Request: req, Input: input, Copy: c.ActivateEventSourceRequest}
}

// ActivateEventSourceRequest is the request type for the
// ActivateEventSource API operation.
type ActivateEventSourceRequest struct {
	*aws.Request
	Input *ActivateEventSourceInput
	Copy  func(*ActivateEventSourceInput) ActivateEventSourceRequest
}

// Send marshals and sends the ActivateEventSource API request.
func (r ActivateEventSourceRequest) Send(ctx context.Context) (*ActivateEventSourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ActivateEventSourceResponse{
		ActivateEventSourceOutput: r.Request.Data.(*ActivateEventSourceOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ActivateEventSourceResponse is the response type for the
// ActivateEventSource API operation.
type ActivateEventSourceResponse struct {
	*ActivateEventSourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ActivateEventSource request.
func (r *ActivateEventSourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
