// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codebuild

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListReportGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of paginated report groups returned per response. Use
	// nextToken to iterate pages in the list of returned ReportGroup objects. The
	// default value is 100.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// During a previous call, the maximum number of items that can be returned
	// is the value specified in maxResults. If there more items in the list, then
	// a unique string called a nextToken is returned. To get the next batch of
	// items in the list, call this operation again, adding the next token to the
	// call. To get all of the items in the list, keep calling this operation with
	// each subsequent next token that is returned, until no more next tokens are
	// returned.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The criterion to be used to list build report groups. Valid values include:
	//
	//    * CREATED_TIME: List based on when each report group was created.
	//
	//    * LAST_MODIFIED_TIME: List based on when each report group was last changed.
	//
	//    * NAME: List based on each report group's name.
	SortBy ReportGroupSortByType `locationName:"sortBy" type:"string" enum:"true"`

	// Used to specify the order to sort the list of returned report groups. Valid
	// values are ASCENDING and DESCENDING.
	SortOrder SortOrderType `locationName:"sortOrder" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListReportGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListReportGroupsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListReportGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListReportGroupsOutput struct {
	_ struct{} `type:"structure"`

	// During a previous call, the maximum number of items that can be returned
	// is the value specified in maxResults. If there more items in the list, then
	// a unique string called a nextToken is returned. To get the next batch of
	// items in the list, call this operation again, adding the next token to the
	// call. To get all of the items in the list, keep calling this operation with
	// each subsequent next token that is returned, until no more next tokens are
	// returned.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of ARNs for the report groups in the current AWS account.
	ReportGroups []string `locationName:"reportGroups" min:"1" type:"list"`
}

// String returns the string representation
func (s ListReportGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListReportGroups = "ListReportGroups"

// ListReportGroupsRequest returns a request value for making API operation for
// AWS CodeBuild.
//
// Gets a list ARNs for the report groups in the current AWS account.
//
//    // Example sending a request using ListReportGroupsRequest.
//    req := client.ListReportGroupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListReportGroups
func (c *Client) ListReportGroupsRequest(input *ListReportGroupsInput) ListReportGroupsRequest {
	op := &aws.Operation{
		Name:       opListReportGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListReportGroupsInput{}
	}

	req := c.newRequest(op, input, &ListReportGroupsOutput{})
	return ListReportGroupsRequest{Request: req, Input: input, Copy: c.ListReportGroupsRequest}
}

// ListReportGroupsRequest is the request type for the
// ListReportGroups API operation.
type ListReportGroupsRequest struct {
	*aws.Request
	Input *ListReportGroupsInput
	Copy  func(*ListReportGroupsInput) ListReportGroupsRequest
}

// Send marshals and sends the ListReportGroups API request.
func (r ListReportGroupsRequest) Send(ctx context.Context) (*ListReportGroupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListReportGroupsResponse{
		ListReportGroupsOutput: r.Request.Data.(*ListReportGroupsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListReportGroupsResponse is the response type for the
// ListReportGroups API operation.
type ListReportGroupsResponse struct {
	*ListReportGroupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListReportGroups request.
func (r *ListReportGroupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
