// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type UpdatePullRequestApprovalStateInput struct {
	_ struct{} `type:"structure"`

	// The approval state to associate with the user on the pull request.
	//
	// ApprovalState is a required field
	ApprovalState ApprovalState `locationName:"approvalState" type:"string" required:"true" enum:"true"`

	// The system-generated ID of the pull request.
	//
	// PullRequestId is a required field
	PullRequestId *string `locationName:"pullRequestId" type:"string" required:"true"`

	// The system-generated ID of the revision.
	//
	// RevisionId is a required field
	RevisionId *string `locationName:"revisionId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdatePullRequestApprovalStateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePullRequestApprovalStateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdatePullRequestApprovalStateInput"}
	if len(s.ApprovalState) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ApprovalState"))
	}

	if s.PullRequestId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PullRequestId"))
	}

	if s.RevisionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RevisionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdatePullRequestApprovalStateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdatePullRequestApprovalStateOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdatePullRequestApprovalState = "UpdatePullRequestApprovalState"

// UpdatePullRequestApprovalStateRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Updates the state of a user's approval on a pull request. The user is derived
// from the signed-in account when the request is made.
//
//    // Example sending a request using UpdatePullRequestApprovalStateRequest.
//    req := client.UpdatePullRequestApprovalStateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestApprovalState
func (c *Client) UpdatePullRequestApprovalStateRequest(input *UpdatePullRequestApprovalStateInput) UpdatePullRequestApprovalStateRequest {
	op := &aws.Operation{
		Name:       opUpdatePullRequestApprovalState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePullRequestApprovalStateInput{}
	}

	req := c.newRequest(op, input, &UpdatePullRequestApprovalStateOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return UpdatePullRequestApprovalStateRequest{Request: req, Input: input, Copy: c.UpdatePullRequestApprovalStateRequest}
}

// UpdatePullRequestApprovalStateRequest is the request type for the
// UpdatePullRequestApprovalState API operation.
type UpdatePullRequestApprovalStateRequest struct {
	*aws.Request
	Input *UpdatePullRequestApprovalStateInput
	Copy  func(*UpdatePullRequestApprovalStateInput) UpdatePullRequestApprovalStateRequest
}

// Send marshals and sends the UpdatePullRequestApprovalState API request.
func (r UpdatePullRequestApprovalStateRequest) Send(ctx context.Context) (*UpdatePullRequestApprovalStateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdatePullRequestApprovalStateResponse{
		UpdatePullRequestApprovalStateOutput: r.Request.Data.(*UpdatePullRequestApprovalStateOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdatePullRequestApprovalStateResponse is the response type for the
// UpdatePullRequestApprovalState API operation.
type UpdatePullRequestApprovalStateResponse struct {
	*UpdatePullRequestApprovalStateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdatePullRequestApprovalState request.
func (r *UpdatePullRequestApprovalStateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
