// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codedeploy

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Represents the input of, and adds tags to, an on-premises instance operation.
type AddTagsToOnPremisesInstancesInput struct {
	_ struct{} `type:"structure"`

	// The names of the on-premises instances to which to add tags.
	//
	// InstanceNames is a required field
	InstanceNames []string `locationName:"instanceNames" type:"list" required:"true"`

	// The tag key-value pairs to add to the on-premises instances.
	//
	// Keys and values are both required. Keys cannot be null or empty strings.
	// Value-only tags are not allowed.
	//
	// Tags is a required field
	Tags []Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsToOnPremisesInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToOnPremisesInstancesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AddTagsToOnPremisesInstancesInput"}

	if s.InstanceNames == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceNames"))
	}

	if s.Tags == nil {
		invalidParams.Add(aws.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AddTagsToOnPremisesInstancesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsToOnPremisesInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

const opAddTagsToOnPremisesInstances = "AddTagsToOnPremisesInstances"

// AddTagsToOnPremisesInstancesRequest returns a request value for making API operation for
// AWS CodeDeploy.
//
// Adds tags to on-premises instances.
//
//    // Example sending a request using AddTagsToOnPremisesInstancesRequest.
//    req := client.AddTagsToOnPremisesInstancesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/AddTagsToOnPremisesInstances
func (c *Client) AddTagsToOnPremisesInstancesRequest(input *AddTagsToOnPremisesInstancesInput) AddTagsToOnPremisesInstancesRequest {
	op := &aws.Operation{
		Name:       opAddTagsToOnPremisesInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToOnPremisesInstancesInput{}
	}

	req := c.newRequest(op, input, &AddTagsToOnPremisesInstancesOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return AddTagsToOnPremisesInstancesRequest{Request: req, Input: input, Copy: c.AddTagsToOnPremisesInstancesRequest}
}

// AddTagsToOnPremisesInstancesRequest is the request type for the
// AddTagsToOnPremisesInstances API operation.
type AddTagsToOnPremisesInstancesRequest struct {
	*aws.Request
	Input *AddTagsToOnPremisesInstancesInput
	Copy  func(*AddTagsToOnPremisesInstancesInput) AddTagsToOnPremisesInstancesRequest
}

// Send marshals and sends the AddTagsToOnPremisesInstances API request.
func (r AddTagsToOnPremisesInstancesRequest) Send(ctx context.Context) (*AddTagsToOnPremisesInstancesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AddTagsToOnPremisesInstancesResponse{
		AddTagsToOnPremisesInstancesOutput: r.Request.Data.(*AddTagsToOnPremisesInstancesOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AddTagsToOnPremisesInstancesResponse is the response type for the
// AddTagsToOnPremisesInstances API operation.
type AddTagsToOnPremisesInstancesResponse struct {
	*AddTagsToOnPremisesInstancesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AddTagsToOnPremisesInstances request.
func (r *AddTagsToOnPremisesInstancesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
