// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codepipeline

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input of a StartPipelineExecution action.
type StartPipelineExecutionInput struct {
	_ struct{} `type:"structure"`

	// The system-generated unique ID used to identify a unique execution request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// The name of the pipeline to start.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartPipelineExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartPipelineExecutionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartPipelineExecutionInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a StartPipelineExecution action.
type StartPipelineExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The unique system-generated ID of the pipeline execution that was started.
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string"`
}

// String returns the string representation
func (s StartPipelineExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartPipelineExecution = "StartPipelineExecution"

// StartPipelineExecutionRequest returns a request value for making API operation for
// AWS CodePipeline.
//
// Starts the specified pipeline. Specifically, it begins processing the latest
// commit to the source location specified as part of the pipeline.
//
//    // Example sending a request using StartPipelineExecutionRequest.
//    req := client.StartPipelineExecutionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/StartPipelineExecution
func (c *Client) StartPipelineExecutionRequest(input *StartPipelineExecutionInput) StartPipelineExecutionRequest {
	op := &aws.Operation{
		Name:       opStartPipelineExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartPipelineExecutionInput{}
	}

	req := c.newRequest(op, input, &StartPipelineExecutionOutput{})
	return StartPipelineExecutionRequest{Request: req, Input: input, Copy: c.StartPipelineExecutionRequest}
}

// StartPipelineExecutionRequest is the request type for the
// StartPipelineExecution API operation.
type StartPipelineExecutionRequest struct {
	*aws.Request
	Input *StartPipelineExecutionInput
	Copy  func(*StartPipelineExecutionInput) StartPipelineExecutionRequest
}

// Send marshals and sends the StartPipelineExecution API request.
func (r StartPipelineExecutionRequest) Send(ctx context.Context) (*StartPipelineExecutionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartPipelineExecutionResponse{
		StartPipelineExecutionOutput: r.Request.Data.(*StartPipelineExecutionOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartPipelineExecutionResponse is the response type for the
// StartPipelineExecution API operation.
type StartPipelineExecutionResponse struct {
	*StartPipelineExecutionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartPipelineExecution request.
func (r *StartPipelineExecutionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
