// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codestarnotifications

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteNotificationRuleInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the notification rule you want to delete.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteNotificationRuleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNotificationRuleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteNotificationRuleInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteNotificationRuleInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteNotificationRuleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deleted notification rule.
	Arn *string `type:"string"`
}

// String returns the string representation
func (s DeleteNotificationRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteNotificationRuleOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDeleteNotificationRule = "DeleteNotificationRule"

// DeleteNotificationRuleRequest returns a request value for making API operation for
// AWS CodeStar Notifications.
//
// Deletes a notification rule for a resource.
//
//    // Example sending a request using DeleteNotificationRuleRequest.
//    req := client.DeleteNotificationRuleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/DeleteNotificationRule
func (c *Client) DeleteNotificationRuleRequest(input *DeleteNotificationRuleInput) DeleteNotificationRuleRequest {
	op := &aws.Operation{
		Name:       opDeleteNotificationRule,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteNotificationRule",
	}

	if input == nil {
		input = &DeleteNotificationRuleInput{}
	}

	req := c.newRequest(op, input, &DeleteNotificationRuleOutput{})
	return DeleteNotificationRuleRequest{Request: req, Input: input, Copy: c.DeleteNotificationRuleRequest}
}

// DeleteNotificationRuleRequest is the request type for the
// DeleteNotificationRule API operation.
type DeleteNotificationRuleRequest struct {
	*aws.Request
	Input *DeleteNotificationRuleInput
	Copy  func(*DeleteNotificationRuleInput) DeleteNotificationRuleRequest
}

// Send marshals and sends the DeleteNotificationRule API request.
func (r DeleteNotificationRuleRequest) Send(ctx context.Context) (*DeleteNotificationRuleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteNotificationRuleResponse{
		DeleteNotificationRuleOutput: r.Request.Data.(*DeleteNotificationRuleOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteNotificationRuleResponse is the response type for the
// DeleteNotificationRule API operation.
type DeleteNotificationRuleResponse struct {
	*DeleteNotificationRuleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteNotificationRule request.
func (r *DeleteNotificationRuleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
