// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The UpdateUserPoolDomain request input.
type UpdateUserPoolDomainInput struct {
	_ struct{} `type:"structure"`

	// The configuration for a custom domain that hosts the sign-up and sign-in
	// pages for your application. Use this object to specify an SSL certificate
	// that is managed by ACM.
	//
	// CustomDomainConfig is a required field
	CustomDomainConfig *CustomDomainConfigType `type:"structure" required:"true"`

	// The domain name for the custom domain that hosts the sign-up and sign-in
	// pages for your application. For example: auth.example.com.
	//
	// This string can include only lowercase letters, numbers, and hyphens. Do
	// not use a hyphen for the first or last character. Use periods to separate
	// subdomain names.
	//
	// Domain is a required field
	Domain *string `min:"1" type:"string" required:"true"`

	// The ID of the user pool that is associated with the custom domain that you
	// are updating the certificate for.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserPoolDomainInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserPoolDomainInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateUserPoolDomainInput"}

	if s.CustomDomainConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("CustomDomainConfig"))
	}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 1))
	}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.CustomDomainConfig != nil {
		if err := s.CustomDomainConfig.Validate(); err != nil {
			invalidParams.AddNested("CustomDomainConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The UpdateUserPoolDomain response output.
type UpdateUserPoolDomainOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon CloudFront endpoint that Amazon Cognito set up when you added
	// the custom domain to your user pool.
	CloudFrontDomain *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateUserPoolDomainOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateUserPoolDomain = "UpdateUserPoolDomain"

// UpdateUserPoolDomainRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Updates the Secure Sockets Layer (SSL) certificate for the custom domain
// for your user pool.
//
// You can use this operation to provide the Amazon Resource Name (ARN) of a
// new certificate to Amazon Cognito. You cannot use it to change the domain
// for a user pool.
//
// A custom domain is used to host the Amazon Cognito hosted UI, which provides
// sign-up and sign-in pages for your application. When you set up a custom
// domain, you provide a certificate that you manage with AWS Certificate Manager
// (ACM). When necessary, you can use this operation to change the certificate
// that you applied to your custom domain.
//
// Usually, this is unnecessary following routine certificate renewal with ACM.
// When you renew your existing certificate in ACM, the ARN for your certificate
// remains the same, and your custom domain uses the new certificate automatically.
//
// However, if you replace your existing certificate with a new one, ACM gives
// the new certificate a new ARN. To apply the new certificate to your custom
// domain, you must provide this ARN to Amazon Cognito.
//
// When you add your new certificate in ACM, you must choose US East (N. Virginia)
// as the AWS Region.
//
// After you submit your request, Amazon Cognito requires up to 1 hour to distribute
// your new certificate to your custom domain.
//
// For more information about adding a custom domain to your user pool, see
// Using Your Own Domain for the Hosted UI (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html).
//
//    // Example sending a request using UpdateUserPoolDomainRequest.
//    req := client.UpdateUserPoolDomainRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPoolDomain
func (c *Client) UpdateUserPoolDomainRequest(input *UpdateUserPoolDomainInput) UpdateUserPoolDomainRequest {
	op := &aws.Operation{
		Name:       opUpdateUserPoolDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserPoolDomainInput{}
	}

	req := c.newRequest(op, input, &UpdateUserPoolDomainOutput{})
	return UpdateUserPoolDomainRequest{Request: req, Input: input, Copy: c.UpdateUserPoolDomainRequest}
}

// UpdateUserPoolDomainRequest is the request type for the
// UpdateUserPoolDomain API operation.
type UpdateUserPoolDomainRequest struct {
	*aws.Request
	Input *UpdateUserPoolDomainInput
	Copy  func(*UpdateUserPoolDomainInput) UpdateUserPoolDomainRequest
}

// Send marshals and sends the UpdateUserPoolDomain API request.
func (r UpdateUserPoolDomainRequest) Send(ctx context.Context) (*UpdateUserPoolDomainResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateUserPoolDomainResponse{
		UpdateUserPoolDomainOutput: r.Request.Data.(*UpdateUserPoolDomainOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateUserPoolDomainResponse is the response type for the
// UpdateUserPoolDomain API operation.
type UpdateUserPoolDomainResponse struct {
	*UpdateUserPoolDomainOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateUserPoolDomain request.
func (r *UpdateUserPoolDomainResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
