// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitosync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// A request to configure Cognito Events"
// "
type SetCognitoEventsInput struct {
	_ struct{} `type:"structure"`

	// The events to configure
	//
	// Events is a required field
	Events map[string]string `type:"map" required:"true"`

	// The Cognito Identity Pool to use when configuring Cognito Events
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SetCognitoEventsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetCognitoEventsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetCognitoEventsInput"}

	if s.Events == nil {
		invalidParams.Add(aws.NewErrParamRequired("Events"))
	}

	if s.IdentityPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SetCognitoEventsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Events != nil {
		v := s.Events

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Events", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.IdentityPoolId != nil {
		v := *s.IdentityPoolId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "IdentityPoolId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type SetCognitoEventsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetCognitoEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SetCognitoEventsOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opSetCognitoEvents = "SetCognitoEvents"

// SetCognitoEventsRequest returns a request value for making API operation for
// Amazon Cognito Sync.
//
// Sets the AWS Lambda function for a given event type for an identity pool.
// This request only updates the key/value pair specified. Other key/values
// pairs are not updated. To remove a key value pair, pass a empty value for
// the particular key.
//
// This API can only be called with developer credentials. You cannot call this
// API with the temporary user credentials provided by Cognito Identity.
//
//    // Example sending a request using SetCognitoEventsRequest.
//    req := client.SetCognitoEventsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/SetCognitoEvents
func (c *Client) SetCognitoEventsRequest(input *SetCognitoEventsInput) SetCognitoEventsRequest {
	op := &aws.Operation{
		Name:       opSetCognitoEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/identitypools/{IdentityPoolId}/events",
	}

	if input == nil {
		input = &SetCognitoEventsInput{}
	}

	req := c.newRequest(op, input, &SetCognitoEventsOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return SetCognitoEventsRequest{Request: req, Input: input, Copy: c.SetCognitoEventsRequest}
}

// SetCognitoEventsRequest is the request type for the
// SetCognitoEvents API operation.
type SetCognitoEventsRequest struct {
	*aws.Request
	Input *SetCognitoEventsInput
	Copy  func(*SetCognitoEventsInput) SetCognitoEventsRequest
}

// Send marshals and sends the SetCognitoEvents API request.
func (r SetCognitoEventsRequest) Send(ctx context.Context) (*SetCognitoEventsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SetCognitoEventsResponse{
		SetCognitoEventsOutput: r.Request.Data.(*SetCognitoEventsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SetCognitoEventsResponse is the response type for the
// SetCognitoEvents API operation.
type SetCognitoEventsResponse struct {
	*SetCognitoEventsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SetCognitoEvents request.
func (r *SetCognitoEventsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
