// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehendmedical

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeEntitiesDetectionV2JobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend Medical generated for the job. The
	// StartEntitiesDetectionV2Job operation returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeEntitiesDetectionV2JobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEntitiesDetectionV2JobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeEntitiesDetectionV2JobInput"}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeEntitiesDetectionV2JobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a detection job.
	ComprehendMedicalAsyncJobProperties *ComprehendMedicalAsyncJobProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeEntitiesDetectionV2JobOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeEntitiesDetectionV2Job = "DescribeEntitiesDetectionV2Job"

// DescribeEntitiesDetectionV2JobRequest returns a request value for making API operation for
// AWS Comprehend Medical.
//
// Gets the properties associated with a medical entities detection job. Use
// this operation to get the status of a detection job.
//
//    // Example sending a request using DescribeEntitiesDetectionV2JobRequest.
//    req := client.DescribeEntitiesDetectionV2JobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeEntitiesDetectionV2Job
func (c *Client) DescribeEntitiesDetectionV2JobRequest(input *DescribeEntitiesDetectionV2JobInput) DescribeEntitiesDetectionV2JobRequest {
	op := &aws.Operation{
		Name:       opDescribeEntitiesDetectionV2Job,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEntitiesDetectionV2JobInput{}
	}

	req := c.newRequest(op, input, &DescribeEntitiesDetectionV2JobOutput{})
	return DescribeEntitiesDetectionV2JobRequest{Request: req, Input: input, Copy: c.DescribeEntitiesDetectionV2JobRequest}
}

// DescribeEntitiesDetectionV2JobRequest is the request type for the
// DescribeEntitiesDetectionV2Job API operation.
type DescribeEntitiesDetectionV2JobRequest struct {
	*aws.Request
	Input *DescribeEntitiesDetectionV2JobInput
	Copy  func(*DescribeEntitiesDetectionV2JobInput) DescribeEntitiesDetectionV2JobRequest
}

// Send marshals and sends the DescribeEntitiesDetectionV2Job API request.
func (r DescribeEntitiesDetectionV2JobRequest) Send(ctx context.Context) (*DescribeEntitiesDetectionV2JobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeEntitiesDetectionV2JobResponse{
		DescribeEntitiesDetectionV2JobOutput: r.Request.Data.(*DescribeEntitiesDetectionV2JobOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeEntitiesDetectionV2JobResponse is the response type for the
// DescribeEntitiesDetectionV2Job API operation.
type DescribeEntitiesDetectionV2JobResponse struct {
	*DescribeEntitiesDetectionV2JobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeEntitiesDetectionV2Job request.
func (r *DescribeEntitiesDetectionV2JobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
