// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeleteAggregationAuthorizationInput struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the account authorized to aggregate data.
	//
	// AuthorizedAccountId is a required field
	AuthorizedAccountId *string `type:"string" required:"true"`

	// The region authorized to collect aggregated data.
	//
	// AuthorizedAwsRegion is a required field
	AuthorizedAwsRegion *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAggregationAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAggregationAuthorizationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteAggregationAuthorizationInput"}

	if s.AuthorizedAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AuthorizedAccountId"))
	}

	if s.AuthorizedAwsRegion == nil {
		invalidParams.Add(aws.NewErrParamRequired("AuthorizedAwsRegion"))
	}
	if s.AuthorizedAwsRegion != nil && len(*s.AuthorizedAwsRegion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AuthorizedAwsRegion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteAggregationAuthorizationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAggregationAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteAggregationAuthorization = "DeleteAggregationAuthorization"

// DeleteAggregationAuthorizationRequest returns a request value for making API operation for
// AWS Config.
//
// Deletes the authorization granted to the specified configuration aggregator
// account in a specified region.
//
//    // Example sending a request using DeleteAggregationAuthorizationRequest.
//    req := client.DeleteAggregationAuthorizationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteAggregationAuthorization
func (c *Client) DeleteAggregationAuthorizationRequest(input *DeleteAggregationAuthorizationInput) DeleteAggregationAuthorizationRequest {
	op := &aws.Operation{
		Name:       opDeleteAggregationAuthorization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAggregationAuthorizationInput{}
	}

	req := c.newRequest(op, input, &DeleteAggregationAuthorizationOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteAggregationAuthorizationRequest{Request: req, Input: input, Copy: c.DeleteAggregationAuthorizationRequest}
}

// DeleteAggregationAuthorizationRequest is the request type for the
// DeleteAggregationAuthorization API operation.
type DeleteAggregationAuthorizationRequest struct {
	*aws.Request
	Input *DeleteAggregationAuthorizationInput
	Copy  func(*DeleteAggregationAuthorizationInput) DeleteAggregationAuthorizationRequest
}

// Send marshals and sends the DeleteAggregationAuthorization API request.
func (r DeleteAggregationAuthorizationRequest) Send(ctx context.Context) (*DeleteAggregationAuthorizationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteAggregationAuthorizationResponse{
		DeleteAggregationAuthorizationOutput: r.Request.Data.(*DeleteAggregationAuthorizationOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteAggregationAuthorizationResponse is the response type for the
// DeleteAggregationAuthorization API operation.
type DeleteAggregationAuthorizationResponse struct {
	*DeleteAggregationAuthorizationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteAggregationAuthorization request.
func (r *DeleteAggregationAuthorizationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
