// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteRemediationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the AWS Config rule for which you want to delete remediation
	// configuration.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`

	// The type of a resource.
	ResourceType *string `type:"string"`
}

// String returns the string representation
func (s DeleteRemediationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRemediationConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteRemediationConfigurationInput"}

	if s.ConfigRuleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConfigRuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteRemediationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRemediationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteRemediationConfiguration = "DeleteRemediationConfiguration"

// DeleteRemediationConfigurationRequest returns a request value for making API operation for
// AWS Config.
//
// Deletes the remediation configuration.
//
//    // Example sending a request using DeleteRemediationConfigurationRequest.
//    req := client.DeleteRemediationConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationConfiguration
func (c *Client) DeleteRemediationConfigurationRequest(input *DeleteRemediationConfigurationInput) DeleteRemediationConfigurationRequest {
	op := &aws.Operation{
		Name:       opDeleteRemediationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRemediationConfigurationInput{}
	}

	req := c.newRequest(op, input, &DeleteRemediationConfigurationOutput{})
	return DeleteRemediationConfigurationRequest{Request: req, Input: input, Copy: c.DeleteRemediationConfigurationRequest}
}

// DeleteRemediationConfigurationRequest is the request type for the
// DeleteRemediationConfiguration API operation.
type DeleteRemediationConfigurationRequest struct {
	*aws.Request
	Input *DeleteRemediationConfigurationInput
	Copy  func(*DeleteRemediationConfigurationInput) DeleteRemediationConfigurationRequest
}

// Send marshals and sends the DeleteRemediationConfiguration API request.
func (r DeleteRemediationConfigurationRequest) Send(ctx context.Context) (*DeleteRemediationConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteRemediationConfigurationResponse{
		DeleteRemediationConfigurationOutput: r.Request.Data.(*DeleteRemediationConfigurationOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteRemediationConfigurationResponse is the response type for the
// DeleteRemediationConfiguration API operation.
type DeleteRemediationConfigurationResponse struct {
	*DeleteRemediationConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteRemediationConfiguration request.
func (r *DeleteRemediationConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
