// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type StartChatContactInput struct {
	_ struct{} `type:"structure"`

	// A custom key-value pair using an attribute map. The attributes are standard
	// Amazon Connect attributes, and can be accessed in contact flows just like
	// any other contact attributes.
	//
	// There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact.
	// Attribute keys can include only alphanumeric, dash, and underscore characters.
	Attributes map[string]string `type:"map"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// The identifier of the contact flow for the chat.
	//
	// ContactFlowId is a required field
	ContactFlowId *string `type:"string" required:"true"`

	// The initial message to be sent to the newly created chat.
	InitialMessage *ChatMessage `type:"structure"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`

	// Information identifying the participant.
	//
	// ParticipantDetails is a required field
	ParticipantDetails *ParticipantDetails `type:"structure" required:"true"`
}

// String returns the string representation
func (s StartChatContactInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartChatContactInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartChatContactInput"}

	if s.ContactFlowId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContactFlowId"))
	}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceId", 1))
	}

	if s.ParticipantDetails == nil {
		invalidParams.Add(aws.NewErrParamRequired("ParticipantDetails"))
	}
	if s.InitialMessage != nil {
		if err := s.InitialMessage.Validate(); err != nil {
			invalidParams.AddNested("InitialMessage", err.(aws.ErrInvalidParams))
		}
	}
	if s.ParticipantDetails != nil {
		if err := s.ParticipantDetails.Validate(); err != nil {
			invalidParams.AddNested("ParticipantDetails", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartChatContactInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Attributes != nil {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ClientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ContactFlowId != nil {
		v := *s.ContactFlowId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContactFlowId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InitialMessage != nil {
		v := s.InitialMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "InitialMessage", v, metadata)
	}
	if s.InstanceId != nil {
		v := *s.InstanceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InstanceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ParticipantDetails != nil {
		v := s.ParticipantDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ParticipantDetails", v, metadata)
	}
	return nil
}

type StartChatContactOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of this contact within the Amazon Connect instance.
	ContactId *string `min:"1" type:"string"`

	// The identifier for a chat participant. The participantId for a chat participant
	// is the same throughout the chat lifecycle.
	ParticipantId *string `min:"1" type:"string"`

	// The token used by the chat participant to call CreateParticipantConnection
	// (https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html).
	// The participant token is valid for the lifetime of a chat participant.
	ParticipantToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartChatContactOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartChatContactOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContactId != nil {
		v := *s.ContactId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContactId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ParticipantId != nil {
		v := *s.ParticipantId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ParticipantId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ParticipantToken != nil {
		v := *s.ParticipantToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ParticipantToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opStartChatContact = "StartChatContact"

// StartChatContactRequest returns a request value for making API operation for
// Amazon Connect Service.
//
// Initiates a contact flow to start a new chat for the customer. Response of
// this API provides a token required to obtain credentials from the CreateParticipantConnection
// (https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html)
// API in the Amazon Connect Participant Service.
//
// When a new chat contact is successfully created, clients need to subscribe
// to the participant’s connection for the created chat within 5 minutes.
// This is achieved by invoking CreateParticipantConnection (https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html)
// with WEBSOCKET and CONNECTION_CREDENTIALS.
//
//    // Example sending a request using StartChatContactRequest.
//    req := client.StartChatContactRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartChatContact
func (c *Client) StartChatContactRequest(input *StartChatContactInput) StartChatContactRequest {
	op := &aws.Operation{
		Name:       opStartChatContact,
		HTTPMethod: "PUT",
		HTTPPath:   "/contact/chat",
	}

	if input == nil {
		input = &StartChatContactInput{}
	}

	req := c.newRequest(op, input, &StartChatContactOutput{})
	return StartChatContactRequest{Request: req, Input: input, Copy: c.StartChatContactRequest}
}

// StartChatContactRequest is the request type for the
// StartChatContact API operation.
type StartChatContactRequest struct {
	*aws.Request
	Input *StartChatContactInput
	Copy  func(*StartChatContactInput) StartChatContactRequest
}

// Send marshals and sends the StartChatContact API request.
func (r StartChatContactRequest) Send(ctx context.Context) (*StartChatContactResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartChatContactResponse{
		StartChatContactOutput: r.Request.Data.(*StartChatContactOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartChatContactResponse is the response type for the
// StartChatContact API operation.
type StartChatContactResponse struct {
	*StartChatContactOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartChatContact request.
func (r *StartChatContactResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
