// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package datapipeline

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for PollForTask.
type PollForTaskInput struct {
	_ struct{} `type:"structure"`

	// The public DNS name of the calling task runner.
	Hostname *string `locationName:"hostname" min:"1" type:"string"`

	// Identity information for the EC2 instance that is hosting the task runner.
	// You can get this value from the instance using http://169.254.169.254/latest/meta-data/instance-id.
	// For more information, see Instance Metadata (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AESDG-chapter-instancedata.html)
	// in the Amazon Elastic Compute Cloud User Guide. Passing in this value proves
	// that your task runner is running on an EC2 instance, and ensures the proper
	// AWS Data Pipeline service charges are applied to your pipeline.
	InstanceIdentity *InstanceIdentity `locationName:"instanceIdentity" type:"structure"`

	// The type of task the task runner is configured to accept and process. The
	// worker group is set as a field on objects in the pipeline when they are created.
	// You can only specify a single value for workerGroup in the call to PollForTask.
	// There are no wildcard values permitted in workerGroup; the string must be
	// an exact, case-sensitive, match.
	//
	// WorkerGroup is a required field
	WorkerGroup *string `locationName:"workerGroup" type:"string" required:"true"`
}

// String returns the string representation
func (s PollForTaskInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PollForTaskInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PollForTaskInput"}
	if s.Hostname != nil && len(*s.Hostname) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Hostname", 1))
	}

	if s.WorkerGroup == nil {
		invalidParams.Add(aws.NewErrParamRequired("WorkerGroup"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of PollForTask.
type PollForTaskOutput struct {
	_ struct{} `type:"structure"`

	// The information needed to complete the task that is being assigned to the
	// task runner. One of the fields returned in this object is taskId, which contains
	// an identifier for the task being assigned. The calling task runner uses taskId
	// in subsequent calls to ReportTaskProgress and SetTaskStatus.
	TaskObject *TaskObject `locationName:"taskObject" type:"structure"`
}

// String returns the string representation
func (s PollForTaskOutput) String() string {
	return awsutil.Prettify(s)
}

const opPollForTask = "PollForTask"

// PollForTaskRequest returns a request value for making API operation for
// AWS Data Pipeline.
//
// Task runners call PollForTask to receive a task to perform from AWS Data
// Pipeline. The task runner specifies which tasks it can perform by setting
// a value for the workerGroup parameter. The task returned can come from any
// of the pipelines that match the workerGroup value passed in by the task runner
// and that was launched using the IAM user credentials specified by the task
// runner.
//
// If tasks are ready in the work queue, PollForTask returns a response immediately.
// If no tasks are available in the queue, PollForTask uses long-polling and
// holds on to a poll connection for up to a 90 seconds, during which time the
// first newly scheduled task is handed to the task runner. To accomodate this,
// set the socket timeout in your task runner to 90 seconds. The task runner
// should not call PollForTask again on the same workerGroup until it receives
// a response, and this can take up to 90 seconds.
//
//    // Example sending a request using PollForTaskRequest.
//    req := client.PollForTaskRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/PollForTask
func (c *Client) PollForTaskRequest(input *PollForTaskInput) PollForTaskRequest {
	op := &aws.Operation{
		Name:       opPollForTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PollForTaskInput{}
	}

	req := c.newRequest(op, input, &PollForTaskOutput{})
	return PollForTaskRequest{Request: req, Input: input, Copy: c.PollForTaskRequest}
}

// PollForTaskRequest is the request type for the
// PollForTask API operation.
type PollForTaskRequest struct {
	*aws.Request
	Input *PollForTaskInput
	Copy  func(*PollForTaskInput) PollForTaskRequest
}

// Send marshals and sends the PollForTask API request.
func (r PollForTaskRequest) Send(ctx context.Context) (*PollForTaskResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PollForTaskResponse{
		PollForTaskOutput: r.Request.Data.(*PollForTaskOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PollForTaskResponse is the response type for the
// PollForTask API operation.
type PollForTaskResponse struct {
	*PollForTaskOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PollForTask request.
func (r *PollForTaskResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
