// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directoryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the inputs for the EnableRadius operation.
type EnableRadiusInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory for which to enable MFA.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// A RadiusSettings object that contains information about the RADIUS server.
	//
	// RadiusSettings is a required field
	RadiusSettings *RadiusSettings `type:"structure" required:"true"`
}

// String returns the string representation
func (s EnableRadiusInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableRadiusInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EnableRadiusInput"}

	if s.DirectoryId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryId"))
	}

	if s.RadiusSettings == nil {
		invalidParams.Add(aws.NewErrParamRequired("RadiusSettings"))
	}
	if s.RadiusSettings != nil {
		if err := s.RadiusSettings.Validate(); err != nil {
			invalidParams.AddNested("RadiusSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the results of the EnableRadius operation.
type EnableRadiusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableRadiusOutput) String() string {
	return awsutil.Prettify(s)
}

const opEnableRadius = "EnableRadius"

// EnableRadiusRequest returns a request value for making API operation for
// AWS Directory Service.
//
// Enables multi-factor authentication (MFA) with the Remote Authentication
// Dial In User Service (RADIUS) server for an AD Connector or Microsoft AD
// directory.
//
//    // Example sending a request using EnableRadiusRequest.
//    req := client.EnableRadiusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableRadius
func (c *Client) EnableRadiusRequest(input *EnableRadiusInput) EnableRadiusRequest {
	op := &aws.Operation{
		Name:       opEnableRadius,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableRadiusInput{}
	}

	req := c.newRequest(op, input, &EnableRadiusOutput{})
	return EnableRadiusRequest{Request: req, Input: input, Copy: c.EnableRadiusRequest}
}

// EnableRadiusRequest is the request type for the
// EnableRadius API operation.
type EnableRadiusRequest struct {
	*aws.Request
	Input *EnableRadiusInput
	Copy  func(*EnableRadiusInput) EnableRadiusRequest
}

// Send marshals and sends the EnableRadius API request.
func (r EnableRadiusRequest) Send(ctx context.Context) (*EnableRadiusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &EnableRadiusResponse{
		EnableRadiusOutput: r.Request.Data.(*EnableRadiusOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// EnableRadiusResponse is the response type for the
// EnableRadius API operation.
type EnableRadiusResponse struct {
	*EnableRadiusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// EnableRadius request.
func (r *EnableRadiusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
