// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dynamodb

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeGlobalTableInput struct {
	_ struct{} `type:"structure"`

	// The name of the global table.
	//
	// GlobalTableName is a required field
	GlobalTableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeGlobalTableInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGlobalTableInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeGlobalTableInput"}

	if s.GlobalTableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GlobalTableName"))
	}
	if s.GlobalTableName != nil && len(*s.GlobalTableName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("GlobalTableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeGlobalTableOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of the global table.
	GlobalTableDescription *GlobalTableDescription `type:"structure"`
}

// String returns the string representation
func (s DescribeGlobalTableOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeGlobalTable = "DescribeGlobalTable"

// DescribeGlobalTableRequest returns a request value for making API operation for
// Amazon DynamoDB.
//
// Returns information about the specified global table.
//
// This method only applies to Version 2017.11.29 (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html)
// of global tables.
//
//    // Example sending a request using DescribeGlobalTableRequest.
//    req := client.DescribeGlobalTableRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeGlobalTable
func (c *Client) DescribeGlobalTableRequest(input *DescribeGlobalTableInput) DescribeGlobalTableRequest {
	op := &aws.Operation{
		Name:       opDescribeGlobalTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGlobalTableInput{}
	}

	req := c.newRequest(op, input, &DescribeGlobalTableOutput{})
	return DescribeGlobalTableRequest{Request: req, Input: input, Copy: c.DescribeGlobalTableRequest}
}

// DescribeGlobalTableRequest is the request type for the
// DescribeGlobalTable API operation.
type DescribeGlobalTableRequest struct {
	*aws.Request
	Input *DescribeGlobalTableInput
	Copy  func(*DescribeGlobalTableInput) DescribeGlobalTableRequest
}

// Send marshals and sends the DescribeGlobalTable API request.
func (r DescribeGlobalTableRequest) Send(ctx context.Context) (*DescribeGlobalTableResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeGlobalTableResponse{
		DescribeGlobalTableOutput: r.Request.Data.(*DescribeGlobalTableOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeGlobalTableResponse is the response type for the
// DescribeGlobalTable API operation.
type DescribeGlobalTableResponse struct {
	*DescribeGlobalTableOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeGlobalTable request.
func (r *DescribeGlobalTableResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
