// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dynamodbstreams

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/service/dynamodb"
)

var _ aws.Config
var _ = awsutil.Prettify

// Represents the data for an attribute. You can set one, and only one, of the
// elements.
//
// Each attribute in an item is a name-value pair. An attribute can be single-valued
// or multi-valued set. For example, a book item can have title and authors
// attributes. Each book has one title but can have many authors. The multi-valued
// attribute is a set; duplicate values are not allowed.
type AttributeValue struct {
	_ struct{} `type:"structure"`

	// A Binary data type.
	//
	// B is automatically base64 encoded/decoded by the SDK.
	B []byte `type:"blob"`

	// A Boolean data type.
	BOOL *bool `type:"boolean"`

	// A Binary Set data type.
	BS [][]byte `type:"list"`

	// A List data type.
	L []dynamodb.AttributeValue `type:"list"`

	// A Map data type.
	M map[string]dynamodb.AttributeValue `type:"map"`

	// A Number data type.
	N *string `type:"string"`

	// A Number Set data type.
	NS []string `type:"list"`

	// A Null data type.
	NULL *bool `type:"boolean"`

	// A String data type.
	S *string `type:"string"`

	// A String Set data type.
	SS []string `type:"list"`
}

// String returns the string representation
func (s AttributeValue) String() string {
	return awsutil.Prettify(s)
}

// Contains details about the type of identity that made the request.
type Identity struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the entity that made the call. For Time To Live,
	// the principalId is "dynamodb.amazonaws.com".
	PrincipalId *string `type:"string"`

	// The type of the identity. For Time To Live, the type is "Service".
	Type *string `type:"string"`
}

// String returns the string representation
func (s Identity) String() string {
	return awsutil.Prettify(s)
}

// Represents a single element of a key schema. A key schema specifies the attributes
// that make up the primary key of a table, or the key attributes of an index.
//
// A KeySchemaElement represents exactly one attribute of the primary key. For
// example, a simple primary key (partition key) would be represented by one
// KeySchemaElement. A composite primary key (partition key and sort key) would
// require one KeySchemaElement for the partition key, and another KeySchemaElement
// for the sort key.
//
// The partition key of an item is also known as its hash attribute. The term
// "hash attribute" derives from DynamoDB's usage of an internal hash function
// to evenly distribute data items across partitions, based on their partition
// key values.
//
// The sort key of an item is also known as its range attribute. The term "range
// attribute" derives from the way DynamoDB stores items with the same partition
// key physically close together, in sorted order by the sort key value.
type KeySchemaElement struct {
	_ struct{} `type:"structure"`

	// The name of a key attribute.
	//
	// AttributeName is a required field
	AttributeName *string `min:"1" type:"string" required:"true"`

	// The attribute data, consisting of the data type and the attribute value itself.
	//
	// KeyType is a required field
	KeyType KeyType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s KeySchemaElement) String() string {
	return awsutil.Prettify(s)
}

// A description of a unique event within a stream.
type Record struct {
	_ struct{} `type:"structure"`

	// The region in which the GetRecords request was received.
	AwsRegion *string `locationName:"awsRegion" type:"string"`

	// The main body of the stream record, containing all of the DynamoDB-specific
	// fields.
	Dynamodb *StreamRecord `locationName:"dynamodb" type:"structure"`

	// A globally unique identifier for the event that was recorded in this stream
	// record.
	EventID *string `locationName:"eventID" type:"string"`

	// The type of data modification that was performed on the DynamoDB table:
	//
	//    * INSERT - a new item was added to the table.
	//
	//    * MODIFY - one or more of an existing item's attributes were modified.
	//
	//    * REMOVE - the item was deleted from the table
	EventName OperationType `locationName:"eventName" type:"string" enum:"true"`

	// The AWS service from which the stream record originated. For DynamoDB Streams,
	// this is aws:dynamodb.
	EventSource *string `locationName:"eventSource" type:"string"`

	// The version number of the stream record format. This number is updated whenever
	// the structure of Record is modified.
	//
	// Client applications must not assume that eventVersion will remain at a particular
	// value, as this number is subject to change at any time. In general, eventVersion
	// will only increase as the low-level DynamoDB Streams API evolves.
	EventVersion *string `locationName:"eventVersion" type:"string"`

	// Items that are deleted by the Time to Live process after expiration have
	// the following fields:
	//
	//    * Records[].userIdentity.type "Service"
	//
	//    * Records[].userIdentity.principalId "dynamodb.amazonaws.com"
	UserIdentity *Identity `locationName:"userIdentity" type:"structure"`
}

// String returns the string representation
func (s Record) String() string {
	return awsutil.Prettify(s)
}

// The beginning and ending sequence numbers for the stream records contained
// within a shard.
type SequenceNumberRange struct {
	_ struct{} `type:"structure"`

	// The last sequence number.
	EndingSequenceNumber *string `min:"21" type:"string"`

	// The first sequence number.
	StartingSequenceNumber *string `min:"21" type:"string"`
}

// String returns the string representation
func (s SequenceNumberRange) String() string {
	return awsutil.Prettify(s)
}

// A uniquely identified group of stream records within a stream.
type Shard struct {
	_ struct{} `type:"structure"`

	// The shard ID of the current shard's parent.
	ParentShardId *string `min:"28" type:"string"`

	// The range of possible sequence numbers for the shard.
	SequenceNumberRange *SequenceNumberRange `type:"structure"`

	// The system-generated identifier for this shard.
	ShardId *string `min:"28" type:"string"`
}

// String returns the string representation
func (s Shard) String() string {
	return awsutil.Prettify(s)
}

// Represents all of the data describing a particular stream.
type Stream struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the stream.
	StreamArn *string `min:"37" type:"string"`

	// A timestamp, in ISO 8601 format, for this stream.
	//
	// Note that LatestStreamLabel is not a unique identifier for the stream, because
	// it is possible that a stream from another table might have the same timestamp.
	// However, the combination of the following three elements is guaranteed to
	// be unique:
	//
	//    * the AWS customer ID.
	//
	//    * the table name
	//
	//    * the StreamLabel
	StreamLabel *string `type:"string"`

	// The DynamoDB table with which the stream is associated.
	TableName *string `min:"3" type:"string"`
}

// String returns the string representation
func (s Stream) String() string {
	return awsutil.Prettify(s)
}

// Represents all of the data describing a particular stream.
type StreamDescription struct {
	_ struct{} `type:"structure"`

	// The date and time when the request to create this stream was issued.
	CreationRequestDateTime *time.Time `type:"timestamp"`

	// The key attribute(s) of the stream's DynamoDB table.
	KeySchema []dynamodb.KeySchemaElement `min:"1" type:"list"`

	// The shard ID of the item where the operation stopped, inclusive of the previous
	// result set. Use this value to start a new operation, excluding this value
	// in the new request.
	//
	// If LastEvaluatedShardId is empty, then the "last page" of results has been
	// processed and there is currently no more data to be retrieved.
	//
	// If LastEvaluatedShardId is not empty, it does not necessarily mean that there
	// is more data in the result set. The only way to know when you have reached
	// the end of the result set is when LastEvaluatedShardId is empty.
	LastEvaluatedShardId *string `min:"28" type:"string"`

	// The shards that comprise the stream.
	Shards []Shard `type:"list"`

	// The Amazon Resource Name (ARN) for the stream.
	StreamArn *string `min:"37" type:"string"`

	// A timestamp, in ISO 8601 format, for this stream.
	//
	// Note that LatestStreamLabel is not a unique identifier for the stream, because
	// it is possible that a stream from another table might have the same timestamp.
	// However, the combination of the following three elements is guaranteed to
	// be unique:
	//
	//    * the AWS customer ID.
	//
	//    * the table name
	//
	//    * the StreamLabel
	StreamLabel *string `type:"string"`

	// Indicates the current status of the stream:
	//
	//    * ENABLING - Streams is currently being enabled on the DynamoDB table.
	//
	//    * ENABLED - the stream is enabled.
	//
	//    * DISABLING - Streams is currently being disabled on the DynamoDB table.
	//
	//    * DISABLED - the stream is disabled.
	StreamStatus StreamStatus `type:"string" enum:"true"`

	// Indicates the format of the records within this stream:
	//
	//    * KEYS_ONLY - only the key attributes of items that were modified in the
	//    DynamoDB table.
	//
	//    * NEW_IMAGE - entire items from the table, as they appeared after they
	//    were modified.
	//
	//    * OLD_IMAGE - entire items from the table, as they appeared before they
	//    were modified.
	//
	//    * NEW_AND_OLD_IMAGES - both the new and the old images of the items from
	//    the table.
	StreamViewType StreamViewType `type:"string" enum:"true"`

	// The DynamoDB table with which the stream is associated.
	TableName *string `min:"3" type:"string"`
}

// String returns the string representation
func (s StreamDescription) String() string {
	return awsutil.Prettify(s)
}

// A description of a single data modification that was performed on an item
// in a DynamoDB table.
type StreamRecord struct {
	_ struct{} `type:"structure"`

	// The approximate date and time when the stream record was created, in UNIX
	// epoch time (http://www.epochconverter.com/) format.
	ApproximateCreationDateTime *time.Time `type:"timestamp"`

	// The primary key attribute(s) for the DynamoDB item that was modified.
	Keys map[string]dynamodb.AttributeValue `type:"map"`

	// The item in the DynamoDB table as it appeared after it was modified.
	NewImage map[string]dynamodb.AttributeValue `type:"map"`

	// The item in the DynamoDB table as it appeared before it was modified.
	OldImage map[string]dynamodb.AttributeValue `type:"map"`

	// The sequence number of the stream record.
	SequenceNumber *string `min:"21" type:"string"`

	// The size of the stream record, in bytes.
	SizeBytes *int64 `min:"1" type:"long"`

	// The type of data from the modified DynamoDB item that was captured in this
	// stream record:
	//
	//    * KEYS_ONLY - only the key attributes of the modified item.
	//
	//    * NEW_IMAGE - the entire item, as it appeared after it was modified.
	//
	//    * OLD_IMAGE - the entire item, as it appeared before it was modified.
	//
	//    * NEW_AND_OLD_IMAGES - both the new and the old item images of the item.
	StreamViewType StreamViewType `type:"string" enum:"true"`
}

// String returns the string representation
func (s StreamRecord) String() string {
	return awsutil.Prettify(s)
}
