// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more filters.
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The IDs of the associations.
	LocalGatewayRouteTableVirtualInterfaceGroupAssociationIds []string `locationName:"LocalGatewayRouteTableVirtualInterfaceGroupAssociationId" locationNameList:"item" type:"list"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"5" type:"integer"`

	// The token for the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the associations.
	LocalGatewayRouteTableVirtualInterfaceGroupAssociations []LocalGatewayRouteTableVirtualInterfaceGroupAssociation `locationName:"localGatewayRouteTableVirtualInterfaceGroupAssociationSet" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations = "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations"

// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes the associations between virtual interface groups and local gateway
// route tables.
//
//    // Example sending a request using DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest.
//    req := client.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations
func (c *Client) DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest(input *DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput) DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest {
	op := &aws.Operation{
		Name:       opDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput{}
	}

	req := c.newRequest(op, input, &DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput{})
	return DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest{Request: req, Input: input, Copy: c.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest}
}

// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest is the request type for the
// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations API operation.
type DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest struct {
	*aws.Request
	Input *DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput
	Copy  func(*DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput) DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest
}

// Send marshals and sends the DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations API request.
func (r DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest) Send(ctx context.Context) (*DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse{
		DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput: r.Request.Data.(*DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse is the response type for the
// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations API operation.
type DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse struct {
	*DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations request.
func (r *DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
