// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecr

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListImagesInput struct {
	_ struct{} `type:"structure"`

	// The filter key and value with which to filter your ListImages results.
	Filter *ListImagesFilter `locationName:"filter" type:"structure"`

	// The maximum number of image results returned by ListImages in paginated output.
	// When this parameter is used, ListImages only returns maxResults results in
	// a single page along with a nextToken response element. The remaining results
	// of the initial request can be seen by sending another ListImages request
	// with the returned nextToken value. This value can be between 1 and 1000.
	// If this parameter is not used, then ListImages returns up to 100 results
	// and a nextToken value, if applicable.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated ListImages request
	// where maxResults was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value. This value is null when there are no more results to return.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The AWS account ID associated with the registry that contains the repository
	// in which to list images. If you do not specify a registry, the default registry
	// is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository with image IDs to be listed.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s ListImagesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListImagesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListImagesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.RepositoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListImagesOutput struct {
	_ struct{} `type:"structure"`

	// The list of image IDs for the requested repository.
	ImageIds []ImageIdentifier `locationName:"imageIds" min:"1" type:"list"`

	// The nextToken value to include in a future ListImages request. When the results
	// of a ListImages request exceed maxResults, this value can be used to retrieve
	// the next page of results. This value is null when there are no more results
	// to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListImagesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListImages = "ListImages"

// ListImagesRequest returns a request value for making API operation for
// Amazon EC2 Container Registry.
//
// Lists all the image IDs for a given repository.
//
// You can filter images based on whether or not they are tagged by setting
// the tagStatus parameter to TAGGED or UNTAGGED. For example, you can filter
// your results to return only UNTAGGED images and then pipe that result to
// a BatchDeleteImage operation to delete them. Or, you can filter your results
// to return only TAGGED images to list all of the tags in your repository.
//
//    // Example sending a request using ListImagesRequest.
//    req := client.ListImagesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ListImages
func (c *Client) ListImagesRequest(input *ListImagesInput) ListImagesRequest {
	op := &aws.Operation{
		Name:       opListImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListImagesInput{}
	}

	req := c.newRequest(op, input, &ListImagesOutput{})
	return ListImagesRequest{Request: req, Input: input, Copy: c.ListImagesRequest}
}

// ListImagesRequest is the request type for the
// ListImages API operation.
type ListImagesRequest struct {
	*aws.Request
	Input *ListImagesInput
	Copy  func(*ListImagesInput) ListImagesRequest
}

// Send marshals and sends the ListImages API request.
func (r ListImagesRequest) Send(ctx context.Context) (*ListImagesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListImagesResponse{
		ListImagesOutput: r.Request.Data.(*ListImagesOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListImagesRequestPaginator returns a paginator for ListImages.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListImagesRequest(input)
//   p := ecr.NewListImagesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListImagesPaginator(req ListImagesRequest) ListImagesPaginator {
	return ListImagesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListImagesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListImagesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListImagesPaginator struct {
	aws.Pager
}

func (p *ListImagesPaginator) CurrentPage() *ListImagesOutput {
	return p.Pager.CurrentPage().(*ListImagesOutput)
}

// ListImagesResponse is the response type for the
// ListImages API operation.
type ListImagesResponse struct {
	*ListImagesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListImages request.
func (r *ListImagesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
