// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package efs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DeleteMountTargetInput struct {
	_ struct{} `type:"structure"`

	// The ID of the mount target to delete (String).
	//
	// MountTargetId is a required field
	MountTargetId *string `location:"uri" locationName:"MountTargetId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMountTargetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMountTargetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteMountTargetInput"}

	if s.MountTargetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MountTargetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteMountTargetInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MountTargetId != nil {
		v := *s.MountTargetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "MountTargetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteMountTargetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteMountTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteMountTargetOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteMountTarget = "DeleteMountTarget"

// DeleteMountTargetRequest returns a request value for making API operation for
// Amazon Elastic File System.
//
// Deletes the specified mount target.
//
// This operation forcibly breaks any mounts of the file system by using the
// mount target that is being deleted, which might disrupt instances or applications
// using those mounts. To avoid applications getting cut off abruptly, you might
// consider unmounting any mounts of the mount target, if feasible. The operation
// also deletes the associated network interface. Uncommitted writes might be
// lost, but breaking a mount target using this operation does not corrupt the
// file system itself. The file system you created remains. You can mount an
// EC2 instance in your VPC by using another mount target.
//
// This operation requires permissions for the following action on the file
// system:
//
//    * elasticfilesystem:DeleteMountTarget
//
// The DeleteMountTarget call returns while the mount target state is still
// deleting. You can check the mount target deletion by calling the DescribeMountTargets
// operation, which returns a list of mount target descriptions for the given
// file system.
//
// The operation also requires permissions for the following Amazon EC2 action
// on the mount target's network interface:
//
//    * ec2:DeleteNetworkInterface
//
//    // Example sending a request using DeleteMountTargetRequest.
//    req := client.DeleteMountTargetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteMountTarget
func (c *Client) DeleteMountTargetRequest(input *DeleteMountTargetInput) DeleteMountTargetRequest {
	op := &aws.Operation{
		Name:       opDeleteMountTarget,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-02-01/mount-targets/{MountTargetId}",
	}

	if input == nil {
		input = &DeleteMountTargetInput{}
	}

	req := c.newRequest(op, input, &DeleteMountTargetOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteMountTargetRequest{Request: req, Input: input, Copy: c.DeleteMountTargetRequest}
}

// DeleteMountTargetRequest is the request type for the
// DeleteMountTarget API operation.
type DeleteMountTargetRequest struct {
	*aws.Request
	Input *DeleteMountTargetInput
	Copy  func(*DeleteMountTargetInput) DeleteMountTargetRequest
}

// Send marshals and sends the DeleteMountTarget API request.
func (r DeleteMountTargetRequest) Send(ctx context.Context) (*DeleteMountTargetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteMountTargetResponse{
		DeleteMountTargetOutput: r.Request.Data.(*DeleteMountTargetOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteMountTargetResponse is the response type for the
// DeleteMountTarget API operation.
type DeleteMountTargetResponse struct {
	*DeleteMountTargetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteMountTarget request.
func (r *DeleteMountTargetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
