// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package elasticinferenceiface provides an interface to enable mocking the Amazon Elastic  Inference service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package elasticinferenceiface

import (
	"github.com/aws/aws-sdk-go-v2/service/elasticinference"
)

// ClientAPI provides an interface to enable mocking the
// elasticinference.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Elastic Inference.
//    func myFunc(svc elasticinferenceiface.ClientAPI) bool {
//        // Make svc.ListTagsForResource request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := elasticinference.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        elasticinferenceiface.ClientPI
//    }
//    func (m *mockClientClient) ListTagsForResource(input *elasticinference.ListTagsForResourceInput) (*elasticinference.ListTagsForResourceOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	ListTagsForResourceRequest(*elasticinference.ListTagsForResourceInput) elasticinference.ListTagsForResourceRequest

	TagResourceRequest(*elasticinference.TagResourceInput) elasticinference.TagResourceRequest

	UntagResourceRequest(*elasticinference.UntagResourceInput) elasticinference.UntagResourceRequest
}

var _ ClientAPI = (*elasticinference.Client)(nil)
