// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancing

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for SetLoadBalancerPoliciesForBackendServer.
type SetLoadBalancerPoliciesForBackendServerInput struct {
	_ struct{} `type:"structure"`

	// The port number associated with the EC2 instance.
	//
	// InstancePort is a required field
	InstancePort *int64 `type:"integer" required:"true"`

	// The name of the load balancer.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `type:"string" required:"true"`

	// The names of the policies. If the list is empty, then all current polices
	// are removed from the EC2 instance.
	//
	// PolicyNames is a required field
	PolicyNames []string `type:"list" required:"true"`
}

// String returns the string representation
func (s SetLoadBalancerPoliciesForBackendServerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetLoadBalancerPoliciesForBackendServerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetLoadBalancerPoliciesForBackendServerInput"}

	if s.InstancePort == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstancePort"))
	}

	if s.LoadBalancerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LoadBalancerName"))
	}

	if s.PolicyNames == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of SetLoadBalancerPoliciesForBackendServer.
type SetLoadBalancerPoliciesForBackendServerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetLoadBalancerPoliciesForBackendServerOutput) String() string {
	return awsutil.Prettify(s)
}

const opSetLoadBalancerPoliciesForBackendServer = "SetLoadBalancerPoliciesForBackendServer"

// SetLoadBalancerPoliciesForBackendServerRequest returns a request value for making API operation for
// Elastic Load Balancing.
//
// Replaces the set of policies associated with the specified port on which
// the EC2 instance is listening with a new set of policies. At this time, only
// the back-end server authentication policy type can be applied to the instance
// ports; this policy type is composed of multiple public key policies.
//
// Each time you use SetLoadBalancerPoliciesForBackendServer to enable the policies,
// use the PolicyNames parameter to list the policies that you want to enable.
//
// You can use DescribeLoadBalancers or DescribeLoadBalancerPolicies to verify
// that the policy is associated with the EC2 instance.
//
// For more information about enabling back-end instance authentication, see
// Configure Back-end Instance Authentication (http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-create-https-ssl-load-balancer.html#configure_backendauth_clt)
// in the Classic Load Balancers Guide. For more information about Proxy Protocol,
// see Configure Proxy Protocol Support (http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-proxy-protocol.html)
// in the Classic Load Balancers Guide.
//
//    // Example sending a request using SetLoadBalancerPoliciesForBackendServerRequest.
//    req := client.SetLoadBalancerPoliciesForBackendServerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/SetLoadBalancerPoliciesForBackendServer
func (c *Client) SetLoadBalancerPoliciesForBackendServerRequest(input *SetLoadBalancerPoliciesForBackendServerInput) SetLoadBalancerPoliciesForBackendServerRequest {
	op := &aws.Operation{
		Name:       opSetLoadBalancerPoliciesForBackendServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetLoadBalancerPoliciesForBackendServerInput{}
	}

	req := c.newRequest(op, input, &SetLoadBalancerPoliciesForBackendServerOutput{})
	return SetLoadBalancerPoliciesForBackendServerRequest{Request: req, Input: input, Copy: c.SetLoadBalancerPoliciesForBackendServerRequest}
}

// SetLoadBalancerPoliciesForBackendServerRequest is the request type for the
// SetLoadBalancerPoliciesForBackendServer API operation.
type SetLoadBalancerPoliciesForBackendServerRequest struct {
	*aws.Request
	Input *SetLoadBalancerPoliciesForBackendServerInput
	Copy  func(*SetLoadBalancerPoliciesForBackendServerInput) SetLoadBalancerPoliciesForBackendServerRequest
}

// Send marshals and sends the SetLoadBalancerPoliciesForBackendServer API request.
func (r SetLoadBalancerPoliciesForBackendServerRequest) Send(ctx context.Context) (*SetLoadBalancerPoliciesForBackendServerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SetLoadBalancerPoliciesForBackendServerResponse{
		SetLoadBalancerPoliciesForBackendServerOutput: r.Request.Data.(*SetLoadBalancerPoliciesForBackendServerOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SetLoadBalancerPoliciesForBackendServerResponse is the response type for the
// SetLoadBalancerPoliciesForBackendServer API operation.
type SetLoadBalancerPoliciesForBackendServerResponse struct {
	*SetLoadBalancerPoliciesForBackendServerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SetLoadBalancerPoliciesForBackendServer request.
func (r *SetLoadBalancerPoliciesForBackendServerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
