// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input for a request action.
type DescribeFleetAttributesInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet(s) to retrieve attributes for. To request attributes
	// for all fleets, leave this parameter empty.
	FleetIds []string `min:"1" type:"list"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages. This parameter is ignored when
	// the request specifies one or a list of fleet IDs.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To start
	// at the beginning of the result set, do not specify a value. This parameter
	// is ignored when the request specifies one or a list of fleet IDs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetAttributesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeFleetAttributesInput"}
	if s.FleetIds != nil && len(s.FleetIds) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FleetIds", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the returned data in response to a request action.
type DescribeFleetAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing attribute metadata for each requested fleet
	// ID.
	FleetAttributes []FleetAttributes `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeFleetAttributes = "DescribeFleetAttributes"

// DescribeFleetAttributesRequest returns a request value for making API operation for
// Amazon GameLift.
//
// Retrieves fleet properties, including metadata, status, and configuration,
// for one or more fleets. You can request attributes for all fleets, or specify
// a list of one or more fleet IDs. When requesting multiple fleets, use the
// pagination parameters to retrieve results as a set of sequential pages. If
// successful, a FleetAttributes object is returned for each requested fleet
// ID. When specifying a list of fleet IDs, attribute objects are returned only
// for fleets that currently exist.
//
// Some API actions may limit the number of fleet IDs allowed in one request.
// If a request exceeds this limit, the request fails and the error message
// includes the maximum allowed.
//
// Learn more
//
//  Working with Fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html).
//
// Related operations
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets: DescribeFleetAttributes DescribeFleetCapacity DescribeFleetPortSettings
//    DescribeFleetUtilization DescribeRuntimeConfiguration DescribeEC2InstanceLimits
//    DescribeFleetEvents
//
//    * Update fleets: UpdateFleetAttributes UpdateFleetCapacity UpdateFleetPortSettings
//    UpdateRuntimeConfiguration
//
//    * Manage fleet actions: StartFleetActions StopFleetActions
//
//    // Example sending a request using DescribeFleetAttributesRequest.
//    req := client.DescribeFleetAttributesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetAttributes
func (c *Client) DescribeFleetAttributesRequest(input *DescribeFleetAttributesInput) DescribeFleetAttributesRequest {
	op := &aws.Operation{
		Name:       opDescribeFleetAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetAttributesInput{}
	}

	req := c.newRequest(op, input, &DescribeFleetAttributesOutput{})
	return DescribeFleetAttributesRequest{Request: req, Input: input, Copy: c.DescribeFleetAttributesRequest}
}

// DescribeFleetAttributesRequest is the request type for the
// DescribeFleetAttributes API operation.
type DescribeFleetAttributesRequest struct {
	*aws.Request
	Input *DescribeFleetAttributesInput
	Copy  func(*DescribeFleetAttributesInput) DescribeFleetAttributesRequest
}

// Send marshals and sends the DescribeFleetAttributes API request.
func (r DescribeFleetAttributesRequest) Send(ctx context.Context) (*DescribeFleetAttributesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeFleetAttributesResponse{
		DescribeFleetAttributesOutput: r.Request.Data.(*DescribeFleetAttributesOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeFleetAttributesResponse is the response type for the
// DescribeFleetAttributes API operation.
type DescribeFleetAttributesResponse struct {
	*DescribeFleetAttributesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeFleetAttributes request.
func (r *DescribeFleetAttributesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
