// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package inspector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetExclusionsPreviewInput struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the assessment template for which the exclusions preview
	// was requested.
	//
	// AssessmentTemplateArn is a required field
	AssessmentTemplateArn *string `locationName:"assessmentTemplateArn" min:"1" type:"string" required:"true"`

	// The locale into which you want to translate the exclusion's title, description,
	// and recommendation.
	Locale Locale `locationName:"locale" type:"string" enum:"true"`

	// You can use this parameter to indicate the maximum number of items you want
	// in the response. The default value is 100. The maximum value is 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the GetExclusionsPreviewRequest action.
	// Subsequent calls to the action fill nextToken in the request with the value
	// of nextToken from the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The unique identifier associated of the exclusions preview.
	//
	// PreviewToken is a required field
	PreviewToken *string `locationName:"previewToken" type:"string" required:"true"`
}

// String returns the string representation
func (s GetExclusionsPreviewInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExclusionsPreviewInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetExclusionsPreviewInput"}

	if s.AssessmentTemplateArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssessmentTemplateArn"))
	}
	if s.AssessmentTemplateArn != nil && len(*s.AssessmentTemplateArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AssessmentTemplateArn", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.PreviewToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("PreviewToken"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetExclusionsPreviewOutput struct {
	_ struct{} `type:"structure"`

	// Information about the exclusions included in the preview.
	ExclusionPreviews []ExclusionPreview `locationName:"exclusionPreviews" type:"list"`

	// When a response is generated, if there is more data to be listed, this parameters
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Specifies the status of the request to generate an exclusions preview.
	//
	// PreviewStatus is a required field
	PreviewStatus PreviewStatus `locationName:"previewStatus" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s GetExclusionsPreviewOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetExclusionsPreview = "GetExclusionsPreview"

// GetExclusionsPreviewRequest returns a request value for making API operation for
// Amazon Inspector.
//
// Retrieves the exclusions preview (a list of ExclusionPreview objects) specified
// by the preview token. You can obtain the preview token by running the CreateExclusionsPreview
// API.
//
//    // Example sending a request using GetExclusionsPreviewRequest.
//    req := client.GetExclusionsPreviewRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/GetExclusionsPreview
func (c *Client) GetExclusionsPreviewRequest(input *GetExclusionsPreviewInput) GetExclusionsPreviewRequest {
	op := &aws.Operation{
		Name:       opGetExclusionsPreview,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetExclusionsPreviewInput{}
	}

	req := c.newRequest(op, input, &GetExclusionsPreviewOutput{})
	return GetExclusionsPreviewRequest{Request: req, Input: input, Copy: c.GetExclusionsPreviewRequest}
}

// GetExclusionsPreviewRequest is the request type for the
// GetExclusionsPreview API operation.
type GetExclusionsPreviewRequest struct {
	*aws.Request
	Input *GetExclusionsPreviewInput
	Copy  func(*GetExclusionsPreviewInput) GetExclusionsPreviewRequest
}

// Send marshals and sends the GetExclusionsPreview API request.
func (r GetExclusionsPreviewRequest) Send(ctx context.Context) (*GetExclusionsPreviewResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetExclusionsPreviewResponse{
		GetExclusionsPreviewOutput: r.Request.Data.(*GetExclusionsPreviewOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetExclusionsPreviewRequestPaginator returns a paginator for GetExclusionsPreview.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetExclusionsPreviewRequest(input)
//   p := inspector.NewGetExclusionsPreviewRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetExclusionsPreviewPaginator(req GetExclusionsPreviewRequest) GetExclusionsPreviewPaginator {
	return GetExclusionsPreviewPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetExclusionsPreviewInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetExclusionsPreviewPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetExclusionsPreviewPaginator struct {
	aws.Pager
}

func (p *GetExclusionsPreviewPaginator) CurrentPage() *GetExclusionsPreviewOutput {
	return p.Pager.CurrentPage().(*GetExclusionsPreviewOutput)
}

// GetExclusionsPreviewResponse is the response type for the
// GetExclusionsPreview API operation.
type GetExclusionsPreviewResponse struct {
	*GetExclusionsPreviewOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetExclusionsPreview request.
func (r *GetExclusionsPreviewResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
