// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteDomainConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain configuration to be deleted.
	//
	// DomainConfigurationName is a required field
	DomainConfigurationName *string `location:"uri" locationName:"domainConfigurationName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDomainConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDomainConfigurationInput"}

	if s.DomainConfigurationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainConfigurationName"))
	}
	if s.DomainConfigurationName != nil && len(*s.DomainConfigurationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainConfigurationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDomainConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DomainConfigurationName != nil {
		v := *s.DomainConfigurationName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "domainConfigurationName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteDomainConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDomainConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDomainConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteDomainConfiguration = "DeleteDomainConfiguration"

// DeleteDomainConfigurationRequest returns a request value for making API operation for
// AWS IoT.
//
// Deletes the specified domain configuration.
//
// The domain configuration feature is in public preview and is subject to change.
//
//    // Example sending a request using DeleteDomainConfigurationRequest.
//    req := client.DeleteDomainConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteDomainConfigurationRequest(input *DeleteDomainConfigurationInput) DeleteDomainConfigurationRequest {
	op := &aws.Operation{
		Name:       opDeleteDomainConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/domainConfigurations/{domainConfigurationName}",
	}

	if input == nil {
		input = &DeleteDomainConfigurationInput{}
	}

	req := c.newRequest(op, input, &DeleteDomainConfigurationOutput{})
	return DeleteDomainConfigurationRequest{Request: req, Input: input, Copy: c.DeleteDomainConfigurationRequest}
}

// DeleteDomainConfigurationRequest is the request type for the
// DeleteDomainConfiguration API operation.
type DeleteDomainConfigurationRequest struct {
	*aws.Request
	Input *DeleteDomainConfigurationInput
	Copy  func(*DeleteDomainConfigurationInput) DeleteDomainConfigurationRequest
}

// Send marshals and sends the DeleteDomainConfiguration API request.
func (r DeleteDomainConfigurationRequest) Send(ctx context.Context) (*DeleteDomainConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDomainConfigurationResponse{
		DeleteDomainConfigurationOutput: r.Request.Data.(*DeleteDomainConfigurationOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDomainConfigurationResponse is the response type for the
// DeleteDomainConfiguration API operation.
type DeleteDomainConfigurationResponse struct {
	*DeleteDomainConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDomainConfiguration request.
func (r *DeleteDomainConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
