// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kendra

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListFaqsInput struct {
	_ struct{} `type:"structure"`

	// The index that contains the FAQ lists.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The maximum number of FAQs to return in the response. If there are fewer
	// results in the list, this response contains only the actual results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the previous request to ListFaqs was truncated, include
	// the NextToken to fetch the next set of FAQs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListFaqsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFaqsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListFaqsInput"}

	if s.IndexId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListFaqsOutput struct {
	_ struct{} `type:"structure"`

	// information about the FAQs associated with the specified index.
	FaqSummaryItems []FaqSummary `type:"list"`

	// The ListFaqs operation returns a page of FAQs at a time. The maximum size
	// of the page is set by the MaxResults parameter. If there are more jobs in
	// the list than the page size, Amazon Kendra returns the NextPage token. Include
	// the token in the next request to the ListFaqs operation to return the next
	// page of FAQs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListFaqsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListFaqs = "ListFaqs"

// ListFaqsRequest returns a request value for making API operation for
// AWSKendraFrontendService.
//
// Gets a list of FAQ lists associated with an index.
//
//    // Example sending a request using ListFaqsRequest.
//    req := client.ListFaqsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListFaqs
func (c *Client) ListFaqsRequest(input *ListFaqsInput) ListFaqsRequest {
	op := &aws.Operation{
		Name:       opListFaqs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListFaqsInput{}
	}

	req := c.newRequest(op, input, &ListFaqsOutput{})
	return ListFaqsRequest{Request: req, Input: input, Copy: c.ListFaqsRequest}
}

// ListFaqsRequest is the request type for the
// ListFaqs API operation.
type ListFaqsRequest struct {
	*aws.Request
	Input *ListFaqsInput
	Copy  func(*ListFaqsInput) ListFaqsRequest
}

// Send marshals and sends the ListFaqs API request.
func (r ListFaqsRequest) Send(ctx context.Context) (*ListFaqsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListFaqsResponse{
		ListFaqsOutput: r.Request.Data.(*ListFaqsOutput),
		response:       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListFaqsResponse is the response type for the
// ListFaqs API operation.
type ListFaqsResponse struct {
	*ListFaqsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListFaqs request.
func (r *ListFaqsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
