// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetHostnameSuggestionInput struct {
	_ struct{} `type:"structure"`

	// The layer ID.
	//
	// LayerId is a required field
	LayerId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetHostnameSuggestionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetHostnameSuggestionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetHostnameSuggestionInput"}

	if s.LayerId == nil {
		invalidParams.Add(aws.NewErrParamRequired("LayerId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the response to a GetHostnameSuggestion request.
type GetHostnameSuggestionOutput struct {
	_ struct{} `type:"structure"`

	// The generated host name.
	Hostname *string `type:"string"`

	// The layer ID.
	LayerId *string `type:"string"`
}

// String returns the string representation
func (s GetHostnameSuggestionOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetHostnameSuggestion = "GetHostnameSuggestion"

// GetHostnameSuggestionRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Gets a generated host name for the specified layer, based on the current
// host name theme.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using GetHostnameSuggestionRequest.
//    req := client.GetHostnameSuggestionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/GetHostnameSuggestion
func (c *Client) GetHostnameSuggestionRequest(input *GetHostnameSuggestionInput) GetHostnameSuggestionRequest {
	op := &aws.Operation{
		Name:       opGetHostnameSuggestion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetHostnameSuggestionInput{}
	}

	req := c.newRequest(op, input, &GetHostnameSuggestionOutput{})
	return GetHostnameSuggestionRequest{Request: req, Input: input, Copy: c.GetHostnameSuggestionRequest}
}

// GetHostnameSuggestionRequest is the request type for the
// GetHostnameSuggestion API operation.
type GetHostnameSuggestionRequest struct {
	*aws.Request
	Input *GetHostnameSuggestionInput
	Copy  func(*GetHostnameSuggestionInput) GetHostnameSuggestionRequest
}

// Send marshals and sends the GetHostnameSuggestion API request.
func (r GetHostnameSuggestionRequest) Send(ctx context.Context) (*GetHostnameSuggestionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetHostnameSuggestionResponse{
		GetHostnameSuggestionOutput: r.Request.Data.(*GetHostnameSuggestionOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetHostnameSuggestionResponse is the response type for the
// GetHostnameSuggestion API operation.
type GetHostnameSuggestionResponse struct {
	*GetHostnameSuggestionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetHostnameSuggestion request.
func (r *GetHostnameSuggestionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
