// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package organizations

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListAccountsInput struct {
	_ struct{} `type:"structure"`

	// (Optional) Use this to limit the number of results you want included per
	// page in the response. If you do not include this parameter, it defaults to
	// a value that is specific to the operation. If additional items exist beyond
	// the maximum you specify, the NextToken response element is present and has
	// a value (is not null). Include that value as the NextToken request parameter
	// in the next call to the operation to get the next part of the results. Note
	// that Organizations might return fewer results than the maximum even when
	// there are more results available. You should check NextToken after every
	// operation to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// Use this parameter if you receive a NextToken response in a previous request
	// that indicates that there is more output available. Set it to the value of
	// the previous call's NextToken response to indicate where the output should
	// continue from.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAccountsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccountsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAccountsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListAccountsOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects in the organization.
	Accounts []Account `type:"list"`

	// If present, this value indicates that there is more output available than
	// is included in the current response. Use this value in the NextToken request
	// parameter in a subsequent call to the operation to get the next part of the
	// output. You should repeat this until the NextToken response element comes
	// back as null.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAccountsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListAccounts = "ListAccounts"

// ListAccountsRequest returns a request value for making API operation for
// AWS Organizations.
//
// Lists all the accounts in the organization. To request only the accounts
// in a specified root or organizational unit (OU), use the ListAccountsForParent
// operation instead.
//
// Always check the NextToken response parameter for a null value when calling
// a List* operation. These operations can occasionally return an empty set
// of results even when there are more results available. The NextToken response
// parameter value is null only when there are no more results to display.
//
// This operation can be called only from the organization's master account.
//
//    // Example sending a request using ListAccountsRequest.
//    req := client.ListAccountsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListAccounts
func (c *Client) ListAccountsRequest(input *ListAccountsInput) ListAccountsRequest {
	op := &aws.Operation{
		Name:       opListAccounts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccountsInput{}
	}

	req := c.newRequest(op, input, &ListAccountsOutput{})
	return ListAccountsRequest{Request: req, Input: input, Copy: c.ListAccountsRequest}
}

// ListAccountsRequest is the request type for the
// ListAccounts API operation.
type ListAccountsRequest struct {
	*aws.Request
	Input *ListAccountsInput
	Copy  func(*ListAccountsInput) ListAccountsRequest
}

// Send marshals and sends the ListAccounts API request.
func (r ListAccountsRequest) Send(ctx context.Context) (*ListAccountsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAccountsResponse{
		ListAccountsOutput: r.Request.Data.(*ListAccountsOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListAccountsRequestPaginator returns a paginator for ListAccounts.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListAccountsRequest(input)
//   p := organizations.NewListAccountsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListAccountsPaginator(req ListAccountsRequest) ListAccountsPaginator {
	return ListAccountsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListAccountsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListAccountsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListAccountsPaginator struct {
	aws.Pager
}

func (p *ListAccountsPaginator) CurrentPage() *ListAccountsOutput {
	return p.Pager.CurrentPage().(*ListAccountsOutput)
}

// ListAccountsResponse is the response type for the
// ListAccounts API operation.
type ListAccountsResponse struct {
	*ListAccountsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAccounts request.
func (r *ListAccountsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
