// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetVoiceChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetVoiceChannelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceChannelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetVoiceChannelInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetVoiceChannelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetVoiceChannelOutput struct {
	_ struct{} `type:"structure" payload:"VoiceChannelResponse"`

	// Provides information about the status and settings of the voice channel for
	// an application.
	//
	// VoiceChannelResponse is a required field
	VoiceChannelResponse *VoiceChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetVoiceChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetVoiceChannelOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.VoiceChannelResponse != nil {
		v := s.VoiceChannelResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "VoiceChannelResponse", v, metadata)
	}
	return nil
}

const opGetVoiceChannel = "GetVoiceChannel"

// GetVoiceChannelRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Retrieves information about the status and settings of the voice channel
// for an application.
//
//    // Example sending a request using GetVoiceChannelRequest.
//    req := client.GetVoiceChannelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetVoiceChannel
func (c *Client) GetVoiceChannelRequest(input *GetVoiceChannelInput) GetVoiceChannelRequest {
	op := &aws.Operation{
		Name:       opGetVoiceChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/voice",
	}

	if input == nil {
		input = &GetVoiceChannelInput{}
	}

	req := c.newRequest(op, input, &GetVoiceChannelOutput{})
	return GetVoiceChannelRequest{Request: req, Input: input, Copy: c.GetVoiceChannelRequest}
}

// GetVoiceChannelRequest is the request type for the
// GetVoiceChannel API operation.
type GetVoiceChannelRequest struct {
	*aws.Request
	Input *GetVoiceChannelInput
	Copy  func(*GetVoiceChannelInput) GetVoiceChannelRequest
}

// Send marshals and sends the GetVoiceChannel API request.
func (r GetVoiceChannelRequest) Send(ctx context.Context) (*GetVoiceChannelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetVoiceChannelResponse{
		GetVoiceChannelOutput: r.Request.Data.(*GetVoiceChannelOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetVoiceChannelResponse is the response type for the
// GetVoiceChannel API operation.
type GetVoiceChannelResponse struct {
	*GetVoiceChannelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetVoiceChannel request.
func (r *GetVoiceChannelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
