// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateSegmentInput struct {
	_ struct{} `type:"structure" payload:"WriteSegmentRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`

	// Specifies the configuration, dimension, and other settings for a segment.
	// A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups
	// object, but not both.
	//
	// WriteSegmentRequest is a required field
	WriteSegmentRequest *WriteSegmentRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateSegmentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSegmentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateSegmentInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.SegmentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SegmentId"))
	}

	if s.WriteSegmentRequest == nil {
		invalidParams.Add(aws.NewErrParamRequired("WriteSegmentRequest"))
	}
	if s.WriteSegmentRequest != nil {
		if err := s.WriteSegmentRequest.Validate(); err != nil {
			invalidParams.AddNested("WriteSegmentRequest", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateSegmentInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentId != nil {
		v := *s.SegmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "segment-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.WriteSegmentRequest != nil {
		v := s.WriteSegmentRequest

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "WriteSegmentRequest", v, metadata)
	}
	return nil
}

type UpdateSegmentOutput struct {
	_ struct{} `type:"structure" payload:"SegmentResponse"`

	// Provides information about the configuration, dimension, and other settings
	// for a segment.
	//
	// SegmentResponse is a required field
	SegmentResponse *SegmentResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateSegmentOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateSegmentOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.SegmentResponse != nil {
		v := s.SegmentResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "SegmentResponse", v, metadata)
	}
	return nil
}

const opUpdateSegment = "UpdateSegment"

// UpdateSegmentRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Creates a new segment for an application or updates the configuration, dimension,
// and other settings for an existing segment that's associated with an application.
//
//    // Example sending a request using UpdateSegmentRequest.
//    req := client.UpdateSegmentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSegment
func (c *Client) UpdateSegmentRequest(input *UpdateSegmentInput) UpdateSegmentRequest {
	op := &aws.Operation{
		Name:       opUpdateSegment,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}",
	}

	if input == nil {
		input = &UpdateSegmentInput{}
	}

	req := c.newRequest(op, input, &UpdateSegmentOutput{})
	return UpdateSegmentRequest{Request: req, Input: input, Copy: c.UpdateSegmentRequest}
}

// UpdateSegmentRequest is the request type for the
// UpdateSegment API operation.
type UpdateSegmentRequest struct {
	*aws.Request
	Input *UpdateSegmentInput
	Copy  func(*UpdateSegmentInput) UpdateSegmentRequest
}

// Send marshals and sends the UpdateSegment API request.
func (r UpdateSegmentRequest) Send(ctx context.Context) (*UpdateSegmentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateSegmentResponse{
		UpdateSegmentOutput: r.Request.Data.(*UpdateSegmentOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateSegmentResponse is the response type for the
// UpdateSegment API operation.
type UpdateSegmentResponse struct {
	*UpdateSegmentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateSegment request.
func (r *UpdateSegmentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
