// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds_test

import (
	"context"
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/aws/awserr"
	"github.com/aws/aws-sdk-go-v2/aws/external"
	"github.com/aws/aws-sdk-go-v2/service/rds"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// To add a source identifier to an event notification subscription
//
// This example add a source identifier to an event notification subscription.
func ExampleClient_AddSourceIdentifierToSubscriptionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.AddSourceIdentifierToSubscriptionInput{
		SourceIdentifier: aws.String("mymysqlinstance"),
		SubscriptionName: aws.String("mymysqleventsubscription"),
	}

	req := svc.AddSourceIdentifierToSubscriptionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeSubscriptionNotFoundFault:
				fmt.Println(rds.ErrCodeSubscriptionNotFoundFault, aerr.Error())
			case rds.ErrCodeSourceNotFoundFault:
				fmt.Println(rds.ErrCodeSourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add tags to a resource
//
// This example adds a tag to an option group.
func ExampleClient_AddTagsToResourceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.AddTagsToResourceInput{
		ResourceName: aws.String("arn:aws:rds:us-east-1:992648334831:og:mymysqloptiongroup"),
		Tags: []rds.Tag{
			{
				Key:   aws.String("Staging"),
				Value: aws.String("LocationDB"),
			},
		},
	}

	req := svc.AddTagsToResourceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBInstanceNotFoundFault:
				fmt.Println(rds.ErrCodeDBInstanceNotFoundFault, aerr.Error())
			case rds.ErrCodeDBSnapshotNotFoundFault:
				fmt.Println(rds.ErrCodeDBSnapshotNotFoundFault, aerr.Error())
			case rds.ErrCodeDBClusterNotFoundFault:
				fmt.Println(rds.ErrCodeDBClusterNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To apply a pending maintenance action
//
// This example immediately applies a pending system update to a DB instance.
func ExampleClient_ApplyPendingMaintenanceActionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.ApplyPendingMaintenanceActionInput{
		ApplyAction:        aws.String("system-update"),
		OptInType:          aws.String("immediate"),
		ResourceIdentifier: aws.String("arn:aws:rds:us-east-1:992648334831:db:mymysqlinstance"),
	}

	req := svc.ApplyPendingMaintenanceActionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeResourceNotFoundFault:
				fmt.Println(rds.ErrCodeResourceNotFoundFault, aerr.Error())
			case rds.ErrCodeInvalidDBClusterStateFault:
				fmt.Println(rds.ErrCodeInvalidDBClusterStateFault, aerr.Error())
			case rds.ErrCodeInvalidDBInstanceStateFault:
				fmt.Println(rds.ErrCodeInvalidDBInstanceStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To authorize DB security group integress
//
// This example authorizes access to the specified security group by the specified CIDR
// block.
func ExampleClient_AuthorizeDBSecurityGroupIngressRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.AuthorizeDBSecurityGroupIngressInput{
		CIDRIP:              aws.String("203.0.113.5/32"),
		DBSecurityGroupName: aws.String("mydbsecuritygroup"),
	}

	req := svc.AuthorizeDBSecurityGroupIngressRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBSecurityGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBSecurityGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeInvalidDBSecurityGroupStateFault:
				fmt.Println(rds.ErrCodeInvalidDBSecurityGroupStateFault, aerr.Error())
			case rds.ErrCodeAuthorizationAlreadyExistsFault:
				fmt.Println(rds.ErrCodeAuthorizationAlreadyExistsFault, aerr.Error())
			case rds.ErrCodeAuthorizationQuotaExceededFault:
				fmt.Println(rds.ErrCodeAuthorizationQuotaExceededFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To copy a DB cluster parameter group
//
// This example copies a DB cluster parameter group.
func ExampleClient_CopyDBClusterParameterGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.CopyDBClusterParameterGroupInput{
		SourceDBClusterParameterGroupIdentifier:  aws.String("mydbclusterparametergroup"),
		TargetDBClusterParameterGroupDescription: aws.String("My DB cluster parameter group copy"),
		TargetDBClusterParameterGroupIdentifier:  aws.String("mydbclusterparametergroup-copy"),
	}

	req := svc.CopyDBClusterParameterGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBParameterGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBParameterGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeDBParameterGroupQuotaExceededFault:
				fmt.Println(rds.ErrCodeDBParameterGroupQuotaExceededFault, aerr.Error())
			case rds.ErrCodeDBParameterGroupAlreadyExistsFault:
				fmt.Println(rds.ErrCodeDBParameterGroupAlreadyExistsFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To copy a DB cluster snapshot
//
// The following example copies an automated snapshot of a DB cluster to a new DB cluster
// snapshot.
func ExampleClient_CopyDBClusterSnapshotRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.CopyDBClusterSnapshotInput{
		SourceDBClusterSnapshotIdentifier: aws.String("rds:sample-cluster-2016-09-14-10-38"),
		TargetDBClusterSnapshotIdentifier: aws.String("cluster-snapshot-copy-1"),
	}

	req := svc.CopyDBClusterSnapshotRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBClusterSnapshotAlreadyExistsFault:
				fmt.Println(rds.ErrCodeDBClusterSnapshotAlreadyExistsFault, aerr.Error())
			case rds.ErrCodeDBClusterSnapshotNotFoundFault:
				fmt.Println(rds.ErrCodeDBClusterSnapshotNotFoundFault, aerr.Error())
			case rds.ErrCodeInvalidDBClusterStateFault:
				fmt.Println(rds.ErrCodeInvalidDBClusterStateFault, aerr.Error())
			case rds.ErrCodeInvalidDBClusterSnapshotStateFault:
				fmt.Println(rds.ErrCodeInvalidDBClusterSnapshotStateFault, aerr.Error())
			case rds.ErrCodeSnapshotQuotaExceededFault:
				fmt.Println(rds.ErrCodeSnapshotQuotaExceededFault, aerr.Error())
			case rds.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(rds.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To copy a DB parameter group
//
// This example copies a DB parameter group.
func ExampleClient_CopyDBParameterGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.CopyDBParameterGroupInput{
		SourceDBParameterGroupIdentifier:  aws.String("mymysqlparametergroup"),
		TargetDBParameterGroupDescription: aws.String("My MySQL parameter group copy"),
		TargetDBParameterGroupIdentifier:  aws.String("mymysqlparametergroup-copy"),
	}

	req := svc.CopyDBParameterGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBParameterGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBParameterGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeDBParameterGroupAlreadyExistsFault:
				fmt.Println(rds.ErrCodeDBParameterGroupAlreadyExistsFault, aerr.Error())
			case rds.ErrCodeDBParameterGroupQuotaExceededFault:
				fmt.Println(rds.ErrCodeDBParameterGroupQuotaExceededFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To copy a DB snapshot
//
// This example copies a DB snapshot.
func ExampleClient_CopyDBSnapshotRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.CopyDBSnapshotInput{
		SourceDBSnapshotIdentifier: aws.String("mydbsnapshot"),
		TargetDBSnapshotIdentifier: aws.String("mydbsnapshot-copy"),
	}

	req := svc.CopyDBSnapshotRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBSnapshotAlreadyExistsFault:
				fmt.Println(rds.ErrCodeDBSnapshotAlreadyExistsFault, aerr.Error())
			case rds.ErrCodeDBSnapshotNotFoundFault:
				fmt.Println(rds.ErrCodeDBSnapshotNotFoundFault, aerr.Error())
			case rds.ErrCodeInvalidDBSnapshotStateFault:
				fmt.Println(rds.ErrCodeInvalidDBSnapshotStateFault, aerr.Error())
			case rds.ErrCodeSnapshotQuotaExceededFault:
				fmt.Println(rds.ErrCodeSnapshotQuotaExceededFault, aerr.Error())
			case rds.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(rds.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To copy an option group
//
// This example copies an option group.
func ExampleClient_CopyOptionGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.CopyOptionGroupInput{
		SourceOptionGroupIdentifier:  aws.String("mymysqloptiongroup"),
		TargetOptionGroupDescription: aws.String("My MySQL option group copy"),
		TargetOptionGroupIdentifier:  aws.String("mymysqloptiongroup-copy"),
	}

	req := svc.CopyOptionGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeOptionGroupAlreadyExistsFault:
				fmt.Println(rds.ErrCodeOptionGroupAlreadyExistsFault, aerr.Error())
			case rds.ErrCodeOptionGroupNotFoundFault:
				fmt.Println(rds.ErrCodeOptionGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeOptionGroupQuotaExceededFault:
				fmt.Println(rds.ErrCodeOptionGroupQuotaExceededFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a DB cluster
//
// This example creates a DB cluster.
func ExampleClient_CreateDBClusterRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.CreateDBClusterInput{
		AvailabilityZones: []string{
			"us-east-1a",
		},
		BackupRetentionPeriod:       aws.Int64(1),
		DBClusterIdentifier:         aws.String("mydbcluster"),
		DBClusterParameterGroupName: aws.String("mydbclusterparametergroup"),
		DatabaseName:                aws.String("myauroradb"),
		Engine:                      aws.String("aurora"),
		EngineVersion:               aws.String("5.6.10a"),
		MasterUserPassword:          aws.String("mypassword"),
		MasterUsername:              aws.String("myuser"),
		Port:                        aws.Int64(3306),
		StorageEncrypted:            aws.Bool(true),
	}

	req := svc.CreateDBClusterRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBClusterAlreadyExistsFault:
				fmt.Println(rds.ErrCodeDBClusterAlreadyExistsFault, aerr.Error())
			case rds.ErrCodeInsufficientStorageClusterCapacityFault:
				fmt.Println(rds.ErrCodeInsufficientStorageClusterCapacityFault, aerr.Error())
			case rds.ErrCodeDBClusterQuotaExceededFault:
				fmt.Println(rds.ErrCodeDBClusterQuotaExceededFault, aerr.Error())
			case rds.ErrCodeStorageQuotaExceededFault:
				fmt.Println(rds.ErrCodeStorageQuotaExceededFault, aerr.Error())
			case rds.ErrCodeDBSubnetGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBSubnetGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeInvalidVPCNetworkStateFault:
				fmt.Println(rds.ErrCodeInvalidVPCNetworkStateFault, aerr.Error())
			case rds.ErrCodeInvalidDBClusterStateFault:
				fmt.Println(rds.ErrCodeInvalidDBClusterStateFault, aerr.Error())
			case rds.ErrCodeInvalidDBSubnetGroupStateFault:
				fmt.Println(rds.ErrCodeInvalidDBSubnetGroupStateFault, aerr.Error())
			case rds.ErrCodeInvalidSubnet:
				fmt.Println(rds.ErrCodeInvalidSubnet, aerr.Error())
			case rds.ErrCodeInvalidDBInstanceStateFault:
				fmt.Println(rds.ErrCodeInvalidDBInstanceStateFault, aerr.Error())
			case rds.ErrCodeDBClusterParameterGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBClusterParameterGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(rds.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case rds.ErrCodeDBClusterNotFoundFault:
				fmt.Println(rds.ErrCodeDBClusterNotFoundFault, aerr.Error())
			case rds.ErrCodeDBInstanceNotFoundFault:
				fmt.Println(rds.ErrCodeDBInstanceNotFoundFault, aerr.Error())
			case rds.ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs:
				fmt.Println(rds.ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs, aerr.Error())
			case rds.ErrCodeGlobalClusterNotFoundFault:
				fmt.Println(rds.ErrCodeGlobalClusterNotFoundFault, aerr.Error())
			case rds.ErrCodeInvalidGlobalClusterStateFault:
				fmt.Println(rds.ErrCodeInvalidGlobalClusterStateFault, aerr.Error())
			case rds.ErrCodeDomainNotFoundFault:
				fmt.Println(rds.ErrCodeDomainNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a DB cluster parameter group
//
// This example creates a DB cluster parameter group.
func ExampleClient_CreateDBClusterParameterGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.CreateDBClusterParameterGroupInput{
		DBClusterParameterGroupName: aws.String("mydbclusterparametergroup"),
		DBParameterGroupFamily:      aws.String("aurora5.6"),
		Description:                 aws.String("My DB cluster parameter group"),
	}

	req := svc.CreateDBClusterParameterGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBParameterGroupQuotaExceededFault:
				fmt.Println(rds.ErrCodeDBParameterGroupQuotaExceededFault, aerr.Error())
			case rds.ErrCodeDBParameterGroupAlreadyExistsFault:
				fmt.Println(rds.ErrCodeDBParameterGroupAlreadyExistsFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a DB cluster snapshot
//
// This example creates a DB cluster snapshot.
func ExampleClient_CreateDBClusterSnapshotRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.CreateDBClusterSnapshotInput{
		DBClusterIdentifier:         aws.String("mydbcluster"),
		DBClusterSnapshotIdentifier: aws.String("mydbclustersnapshot"),
	}

	req := svc.CreateDBClusterSnapshotRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBClusterSnapshotAlreadyExistsFault:
				fmt.Println(rds.ErrCodeDBClusterSnapshotAlreadyExistsFault, aerr.Error())
			case rds.ErrCodeInvalidDBClusterStateFault:
				fmt.Println(rds.ErrCodeInvalidDBClusterStateFault, aerr.Error())
			case rds.ErrCodeDBClusterNotFoundFault:
				fmt.Println(rds.ErrCodeDBClusterNotFoundFault, aerr.Error())
			case rds.ErrCodeSnapshotQuotaExceededFault:
				fmt.Println(rds.ErrCodeSnapshotQuotaExceededFault, aerr.Error())
			case rds.ErrCodeInvalidDBClusterSnapshotStateFault:
				fmt.Println(rds.ErrCodeInvalidDBClusterSnapshotStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a DB instance.
//
// This example creates a DB instance.
func ExampleClient_CreateDBInstanceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.CreateDBInstanceInput{
		AllocatedStorage:     aws.Int64(5),
		DBInstanceClass:      aws.String("db.t2.micro"),
		DBInstanceIdentifier: aws.String("mymysqlinstance"),
		Engine:               aws.String("MySQL"),
		MasterUserPassword:   aws.String("MyPassword"),
		MasterUsername:       aws.String("MyUser"),
	}

	req := svc.CreateDBInstanceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBInstanceAlreadyExistsFault:
				fmt.Println(rds.ErrCodeDBInstanceAlreadyExistsFault, aerr.Error())
			case rds.ErrCodeInsufficientDBInstanceCapacityFault:
				fmt.Println(rds.ErrCodeInsufficientDBInstanceCapacityFault, aerr.Error())
			case rds.ErrCodeDBParameterGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBParameterGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeDBSecurityGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBSecurityGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeInstanceQuotaExceededFault:
				fmt.Println(rds.ErrCodeInstanceQuotaExceededFault, aerr.Error())
			case rds.ErrCodeStorageQuotaExceededFault:
				fmt.Println(rds.ErrCodeStorageQuotaExceededFault, aerr.Error())
			case rds.ErrCodeDBSubnetGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBSubnetGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs:
				fmt.Println(rds.ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs, aerr.Error())
			case rds.ErrCodeInvalidDBClusterStateFault:
				fmt.Println(rds.ErrCodeInvalidDBClusterStateFault, aerr.Error())
			case rds.ErrCodeInvalidSubnet:
				fmt.Println(rds.ErrCodeInvalidSubnet, aerr.Error())
			case rds.ErrCodeInvalidVPCNetworkStateFault:
				fmt.Println(rds.ErrCodeInvalidVPCNetworkStateFault, aerr.Error())
			case rds.ErrCodeProvisionedIopsNotAvailableInAZFault:
				fmt.Println(rds.ErrCodeProvisionedIopsNotAvailableInAZFault, aerr.Error())
			case rds.ErrCodeOptionGroupNotFoundFault:
				fmt.Println(rds.ErrCodeOptionGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeDBClusterNotFoundFault:
				fmt.Println(rds.ErrCodeDBClusterNotFoundFault, aerr.Error())
			case rds.ErrCodeStorageTypeNotSupportedFault:
				fmt.Println(rds.ErrCodeStorageTypeNotSupportedFault, aerr.Error())
			case rds.ErrCodeAuthorizationNotFoundFault:
				fmt.Println(rds.ErrCodeAuthorizationNotFoundFault, aerr.Error())
			case rds.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(rds.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case rds.ErrCodeDomainNotFoundFault:
				fmt.Println(rds.ErrCodeDomainNotFoundFault, aerr.Error())
			case rds.ErrCodeBackupPolicyNotFoundFault:
				fmt.Println(rds.ErrCodeBackupPolicyNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a DB instance read replica.
//
// This example creates a DB instance read replica.
func ExampleClient_CreateDBInstanceReadReplicaRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.CreateDBInstanceReadReplicaInput{
		AvailabilityZone:           aws.String("us-east-1a"),
		CopyTagsToSnapshot:         aws.Bool(true),
		DBInstanceClass:            aws.String("db.t2.micro"),
		DBInstanceIdentifier:       aws.String("mydbreadreplica"),
		PubliclyAccessible:         aws.Bool(true),
		SourceDBInstanceIdentifier: aws.String("mymysqlinstance"),
		StorageType:                aws.String("gp2"),
		Tags: []rds.Tag{
			{
				Key:   aws.String("mydbreadreplicakey"),
				Value: aws.String("mydbreadreplicavalue"),
			},
		},
	}

	req := svc.CreateDBInstanceReadReplicaRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBInstanceAlreadyExistsFault:
				fmt.Println(rds.ErrCodeDBInstanceAlreadyExistsFault, aerr.Error())
			case rds.ErrCodeInsufficientDBInstanceCapacityFault:
				fmt.Println(rds.ErrCodeInsufficientDBInstanceCapacityFault, aerr.Error())
			case rds.ErrCodeDBParameterGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBParameterGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeDBSecurityGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBSecurityGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeInstanceQuotaExceededFault:
				fmt.Println(rds.ErrCodeInstanceQuotaExceededFault, aerr.Error())
			case rds.ErrCodeStorageQuotaExceededFault:
				fmt.Println(rds.ErrCodeStorageQuotaExceededFault, aerr.Error())
			case rds.ErrCodeDBInstanceNotFoundFault:
				fmt.Println(rds.ErrCodeDBInstanceNotFoundFault, aerr.Error())
			case rds.ErrCodeInvalidDBInstanceStateFault:
				fmt.Println(rds.ErrCodeInvalidDBInstanceStateFault, aerr.Error())
			case rds.ErrCodeDBSubnetGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBSubnetGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs:
				fmt.Println(rds.ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs, aerr.Error())
			case rds.ErrCodeInvalidSubnet:
				fmt.Println(rds.ErrCodeInvalidSubnet, aerr.Error())
			case rds.ErrCodeInvalidVPCNetworkStateFault:
				fmt.Println(rds.ErrCodeInvalidVPCNetworkStateFault, aerr.Error())
			case rds.ErrCodeProvisionedIopsNotAvailableInAZFault:
				fmt.Println(rds.ErrCodeProvisionedIopsNotAvailableInAZFault, aerr.Error())
			case rds.ErrCodeOptionGroupNotFoundFault:
				fmt.Println(rds.ErrCodeOptionGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeDBSubnetGroupNotAllowedFault:
				fmt.Println(rds.ErrCodeDBSubnetGroupNotAllowedFault, aerr.Error())
			case rds.ErrCodeInvalidDBSubnetGroupFault:
				fmt.Println(rds.ErrCodeInvalidDBSubnetGroupFault, aerr.Error())
			case rds.ErrCodeStorageTypeNotSupportedFault:
				fmt.Println(rds.ErrCodeStorageTypeNotSupportedFault, aerr.Error())
			case rds.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(rds.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case rds.ErrCodeDomainNotFoundFault:
				fmt.Println(rds.ErrCodeDomainNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a DB parameter group.
//
// This example creates a DB parameter group.
func ExampleClient_CreateDBParameterGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.CreateDBParameterGroupInput{
		DBParameterGroupFamily: aws.String("mysql5.6"),
		DBParameterGroupName:   aws.String("mymysqlparametergroup"),
		Description:            aws.String("My MySQL parameter group"),
	}

	req := svc.CreateDBParameterGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBParameterGroupQuotaExceededFault:
				fmt.Println(rds.ErrCodeDBParameterGroupQuotaExceededFault, aerr.Error())
			case rds.ErrCodeDBParameterGroupAlreadyExistsFault:
				fmt.Println(rds.ErrCodeDBParameterGroupAlreadyExistsFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a DB security group.
//
// This example creates a DB security group.
func ExampleClient_CreateDBSecurityGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.CreateDBSecurityGroupInput{
		DBSecurityGroupDescription: aws.String("My DB security group"),
		DBSecurityGroupName:        aws.String("mydbsecuritygroup"),
	}

	req := svc.CreateDBSecurityGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBSecurityGroupAlreadyExistsFault:
				fmt.Println(rds.ErrCodeDBSecurityGroupAlreadyExistsFault, aerr.Error())
			case rds.ErrCodeDBSecurityGroupQuotaExceededFault:
				fmt.Println(rds.ErrCodeDBSecurityGroupQuotaExceededFault, aerr.Error())
			case rds.ErrCodeDBSecurityGroupNotSupportedFault:
				fmt.Println(rds.ErrCodeDBSecurityGroupNotSupportedFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a DB snapshot.
//
// This example creates a DB snapshot.
func ExampleClient_CreateDBSnapshotRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.CreateDBSnapshotInput{
		DBInstanceIdentifier: aws.String("mymysqlinstance"),
		DBSnapshotIdentifier: aws.String("mydbsnapshot"),
	}

	req := svc.CreateDBSnapshotRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBSnapshotAlreadyExistsFault:
				fmt.Println(rds.ErrCodeDBSnapshotAlreadyExistsFault, aerr.Error())
			case rds.ErrCodeInvalidDBInstanceStateFault:
				fmt.Println(rds.ErrCodeInvalidDBInstanceStateFault, aerr.Error())
			case rds.ErrCodeDBInstanceNotFoundFault:
				fmt.Println(rds.ErrCodeDBInstanceNotFoundFault, aerr.Error())
			case rds.ErrCodeSnapshotQuotaExceededFault:
				fmt.Println(rds.ErrCodeSnapshotQuotaExceededFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a DB subnet group.
//
// This example creates a DB subnet group.
func ExampleClient_CreateDBSubnetGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.CreateDBSubnetGroupInput{
		DBSubnetGroupDescription: aws.String("My DB subnet group"),
		DBSubnetGroupName:        aws.String("mydbsubnetgroup"),
		SubnetIds: []string{
			"subnet-1fab8a69",
			"subnet-d43a468c",
		},
	}

	req := svc.CreateDBSubnetGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBSubnetGroupAlreadyExistsFault:
				fmt.Println(rds.ErrCodeDBSubnetGroupAlreadyExistsFault, aerr.Error())
			case rds.ErrCodeDBSubnetGroupQuotaExceededFault:
				fmt.Println(rds.ErrCodeDBSubnetGroupQuotaExceededFault, aerr.Error())
			case rds.ErrCodeDBSubnetQuotaExceededFault:
				fmt.Println(rds.ErrCodeDBSubnetQuotaExceededFault, aerr.Error())
			case rds.ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs:
				fmt.Println(rds.ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs, aerr.Error())
			case rds.ErrCodeInvalidSubnet:
				fmt.Println(rds.ErrCodeInvalidSubnet, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an event notification subscription
//
// This example creates an event notification subscription.
func ExampleClient_CreateEventSubscriptionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.CreateEventSubscriptionInput{
		Enabled: aws.Bool(true),
		EventCategories: []string{
			"availability",
		},
		SnsTopicArn: aws.String("arn:aws:sns:us-east-1:992648334831:MyDemoSNSTopic"),
		SourceIds: []string{
			"mymysqlinstance",
		},
		SourceType:       aws.String("db-instance"),
		SubscriptionName: aws.String("mymysqleventsubscription"),
	}

	req := svc.CreateEventSubscriptionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeEventSubscriptionQuotaExceededFault:
				fmt.Println(rds.ErrCodeEventSubscriptionQuotaExceededFault, aerr.Error())
			case rds.ErrCodeSubscriptionAlreadyExistFault:
				fmt.Println(rds.ErrCodeSubscriptionAlreadyExistFault, aerr.Error())
			case rds.ErrCodeSNSInvalidTopicFault:
				fmt.Println(rds.ErrCodeSNSInvalidTopicFault, aerr.Error())
			case rds.ErrCodeSNSNoAuthorizationFault:
				fmt.Println(rds.ErrCodeSNSNoAuthorizationFault, aerr.Error())
			case rds.ErrCodeSNSTopicArnNotFoundFault:
				fmt.Println(rds.ErrCodeSNSTopicArnNotFoundFault, aerr.Error())
			case rds.ErrCodeSubscriptionCategoryNotFoundFault:
				fmt.Println(rds.ErrCodeSubscriptionCategoryNotFoundFault, aerr.Error())
			case rds.ErrCodeSourceNotFoundFault:
				fmt.Println(rds.ErrCodeSourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an option group
//
// This example creates an option group.
func ExampleClient_CreateOptionGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.CreateOptionGroupInput{
		EngineName:             aws.String("MySQL"),
		MajorEngineVersion:     aws.String("5.6"),
		OptionGroupDescription: aws.String("My MySQL 5.6 option group"),
		OptionGroupName:        aws.String("mymysqloptiongroup"),
	}

	req := svc.CreateOptionGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeOptionGroupAlreadyExistsFault:
				fmt.Println(rds.ErrCodeOptionGroupAlreadyExistsFault, aerr.Error())
			case rds.ErrCodeOptionGroupQuotaExceededFault:
				fmt.Println(rds.ErrCodeOptionGroupQuotaExceededFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a DB cluster.
//
// This example deletes the specified DB cluster.
func ExampleClient_DeleteDBClusterRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DeleteDBClusterInput{
		DBClusterIdentifier: aws.String("mydbcluster"),
		SkipFinalSnapshot:   aws.Bool(true),
	}

	req := svc.DeleteDBClusterRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBClusterNotFoundFault:
				fmt.Println(rds.ErrCodeDBClusterNotFoundFault, aerr.Error())
			case rds.ErrCodeInvalidDBClusterStateFault:
				fmt.Println(rds.ErrCodeInvalidDBClusterStateFault, aerr.Error())
			case rds.ErrCodeDBClusterSnapshotAlreadyExistsFault:
				fmt.Println(rds.ErrCodeDBClusterSnapshotAlreadyExistsFault, aerr.Error())
			case rds.ErrCodeSnapshotQuotaExceededFault:
				fmt.Println(rds.ErrCodeSnapshotQuotaExceededFault, aerr.Error())
			case rds.ErrCodeInvalidDBClusterSnapshotStateFault:
				fmt.Println(rds.ErrCodeInvalidDBClusterSnapshotStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a DB cluster parameter group.
//
// This example deletes the specified DB cluster parameter group.
func ExampleClient_DeleteDBClusterParameterGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DeleteDBClusterParameterGroupInput{
		DBClusterParameterGroupName: aws.String("mydbclusterparametergroup"),
	}

	req := svc.DeleteDBClusterParameterGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeInvalidDBParameterGroupStateFault:
				fmt.Println(rds.ErrCodeInvalidDBParameterGroupStateFault, aerr.Error())
			case rds.ErrCodeDBParameterGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBParameterGroupNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a DB cluster snapshot.
//
// This example deletes the specified DB cluster snapshot.
func ExampleClient_DeleteDBClusterSnapshotRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DeleteDBClusterSnapshotInput{
		DBClusterSnapshotIdentifier: aws.String("mydbclustersnapshot"),
	}

	req := svc.DeleteDBClusterSnapshotRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeInvalidDBClusterSnapshotStateFault:
				fmt.Println(rds.ErrCodeInvalidDBClusterSnapshotStateFault, aerr.Error())
			case rds.ErrCodeDBClusterSnapshotNotFoundFault:
				fmt.Println(rds.ErrCodeDBClusterSnapshotNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a DB instance.
//
// This example deletes the specified DB instance.
func ExampleClient_DeleteDBInstanceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DeleteDBInstanceInput{
		DBInstanceIdentifier: aws.String("mymysqlinstance"),
		SkipFinalSnapshot:    aws.Bool(true),
	}

	req := svc.DeleteDBInstanceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBInstanceNotFoundFault:
				fmt.Println(rds.ErrCodeDBInstanceNotFoundFault, aerr.Error())
			case rds.ErrCodeInvalidDBInstanceStateFault:
				fmt.Println(rds.ErrCodeInvalidDBInstanceStateFault, aerr.Error())
			case rds.ErrCodeDBSnapshotAlreadyExistsFault:
				fmt.Println(rds.ErrCodeDBSnapshotAlreadyExistsFault, aerr.Error())
			case rds.ErrCodeSnapshotQuotaExceededFault:
				fmt.Println(rds.ErrCodeSnapshotQuotaExceededFault, aerr.Error())
			case rds.ErrCodeInvalidDBClusterStateFault:
				fmt.Println(rds.ErrCodeInvalidDBClusterStateFault, aerr.Error())
			case rds.ErrCodeDBInstanceAutomatedBackupQuotaExceededFault:
				fmt.Println(rds.ErrCodeDBInstanceAutomatedBackupQuotaExceededFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a DB parameter group
//
// The following example deletes a DB parameter group.
func ExampleClient_DeleteDBParameterGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DeleteDBParameterGroupInput{
		DBParameterGroupName: aws.String("mydbparamgroup3"),
	}

	req := svc.DeleteDBParameterGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeInvalidDBParameterGroupStateFault:
				fmt.Println(rds.ErrCodeInvalidDBParameterGroupStateFault, aerr.Error())
			case rds.ErrCodeDBParameterGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBParameterGroupNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a DB security group
//
// The following example deletes a DB security group.
func ExampleClient_DeleteDBSecurityGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DeleteDBSecurityGroupInput{
		DBSecurityGroupName: aws.String("mysecgroup"),
	}

	req := svc.DeleteDBSecurityGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeInvalidDBSecurityGroupStateFault:
				fmt.Println(rds.ErrCodeInvalidDBSecurityGroupStateFault, aerr.Error())
			case rds.ErrCodeDBSecurityGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBSecurityGroupNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a DB cluster snapshot.
//
// This example deletes the specified DB snapshot.
func ExampleClient_DeleteDBSnapshotRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DeleteDBSnapshotInput{
		DBSnapshotIdentifier: aws.String("mydbsnapshot"),
	}

	req := svc.DeleteDBSnapshotRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeInvalidDBSnapshotStateFault:
				fmt.Println(rds.ErrCodeInvalidDBSnapshotStateFault, aerr.Error())
			case rds.ErrCodeDBSnapshotNotFoundFault:
				fmt.Println(rds.ErrCodeDBSnapshotNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a DB subnet group.
//
// This example deletes the specified DB subnetgroup.
func ExampleClient_DeleteDBSubnetGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DeleteDBSubnetGroupInput{
		DBSubnetGroupName: aws.String("mydbsubnetgroup"),
	}

	req := svc.DeleteDBSubnetGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeInvalidDBSubnetGroupStateFault:
				fmt.Println(rds.ErrCodeInvalidDBSubnetGroupStateFault, aerr.Error())
			case rds.ErrCodeInvalidDBSubnetStateFault:
				fmt.Println(rds.ErrCodeInvalidDBSubnetStateFault, aerr.Error())
			case rds.ErrCodeDBSubnetGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBSubnetGroupNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a DB event subscription.
//
// This example deletes the specified DB event subscription.
func ExampleClient_DeleteEventSubscriptionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DeleteEventSubscriptionInput{
		SubscriptionName: aws.String("myeventsubscription"),
	}

	req := svc.DeleteEventSubscriptionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeSubscriptionNotFoundFault:
				fmt.Println(rds.ErrCodeSubscriptionNotFoundFault, aerr.Error())
			case rds.ErrCodeInvalidEventSubscriptionStateFault:
				fmt.Println(rds.ErrCodeInvalidEventSubscriptionStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete an option group.
//
// This example deletes the specified option group.
func ExampleClient_DeleteOptionGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DeleteOptionGroupInput{
		OptionGroupName: aws.String("mydboptiongroup"),
	}

	req := svc.DeleteOptionGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeOptionGroupNotFoundFault:
				fmt.Println(rds.ErrCodeOptionGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeInvalidOptionGroupStateFault:
				fmt.Println(rds.ErrCodeInvalidOptionGroupStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list account attributes
//
// This example lists account attributes.
func ExampleClient_DescribeAccountAttributesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeAccountAttributesInput{}

	req := svc.DescribeAccountAttributesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list certificates
//
// This example lists up to 20 certificates for the specified certificate identifier.
func ExampleClient_DescribeCertificatesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeCertificatesInput{
		CertificateIdentifier: aws.String("rds-ca-2015"),
		MaxRecords:            aws.Int64(20),
	}

	req := svc.DescribeCertificatesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeCertificateNotFoundFault:
				fmt.Println(rds.ErrCodeCertificateNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list DB cluster parameter group settings
//
// This example lists settings for the specified DB cluster parameter group.
func ExampleClient_DescribeDBClusterParameterGroupsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeDBClusterParameterGroupsInput{
		DBClusterParameterGroupName: aws.String("mydbclusterparametergroup"),
	}

	req := svc.DescribeDBClusterParameterGroupsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBParameterGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBParameterGroupNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list DB cluster parameters
//
// This example lists system parameters for the specified DB cluster parameter group.
func ExampleClient_DescribeDBClusterParametersRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeDBClusterParametersInput{
		DBClusterParameterGroupName: aws.String("mydbclusterparametergroup"),
		Source:                      aws.String("system"),
	}

	req := svc.DescribeDBClusterParametersRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBParameterGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBParameterGroupNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list DB cluster snapshot attributes
//
// This example lists attributes for the specified DB cluster snapshot.
func ExampleClient_DescribeDBClusterSnapshotAttributesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeDBClusterSnapshotAttributesInput{
		DBClusterSnapshotIdentifier: aws.String("mydbclustersnapshot"),
	}

	req := svc.DescribeDBClusterSnapshotAttributesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBClusterSnapshotNotFoundFault:
				fmt.Println(rds.ErrCodeDBClusterSnapshotNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list DB cluster snapshots
//
// This example lists settings for the specified, manually-created cluster snapshot.
func ExampleClient_DescribeDBClusterSnapshotsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeDBClusterSnapshotsInput{
		DBClusterSnapshotIdentifier: aws.String("mydbclustersnapshot"),
		SnapshotType:                aws.String("manual"),
	}

	req := svc.DescribeDBClusterSnapshotsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBClusterSnapshotNotFoundFault:
				fmt.Println(rds.ErrCodeDBClusterSnapshotNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list DB clusters
//
// This example lists settings for the specified DB cluster.
func ExampleClient_DescribeDBClustersRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeDBClustersInput{
		DBClusterIdentifier: aws.String("mynewdbcluster"),
	}

	req := svc.DescribeDBClustersRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBClusterNotFoundFault:
				fmt.Println(rds.ErrCodeDBClusterNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list DB engine version settings
//
// This example lists settings for the specified DB engine version.
func ExampleClient_DescribeDBEngineVersionsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeDBEngineVersionsInput{
		DBParameterGroupFamily:     aws.String("mysql5.6"),
		DefaultOnly:                aws.Bool(true),
		Engine:                     aws.String("mysql"),
		EngineVersion:              aws.String("5.6"),
		ListSupportedCharacterSets: aws.Bool(true),
	}

	req := svc.DescribeDBEngineVersionsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list DB instance settings
//
// This example lists settings for the specified DB instance.
func ExampleClient_DescribeDBInstancesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeDBInstancesInput{
		DBInstanceIdentifier: aws.String("mymysqlinstance"),
	}

	req := svc.DescribeDBInstancesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBInstanceNotFoundFault:
				fmt.Println(rds.ErrCodeDBInstanceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list DB log file names
//
// This example lists matching log file names for the specified DB instance, file name
// pattern, last write date in POSIX time with milleseconds, and minimum file size.
func ExampleClient_DescribeDBLogFilesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeDBLogFilesInput{
		DBInstanceIdentifier: aws.String("mymysqlinstance"),
		FileLastWritten:      aws.Int64(1470873600000),
		FileSize:             aws.Int64(0),
		FilenameContains:     aws.String("error"),
	}

	req := svc.DescribeDBLogFilesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBInstanceNotFoundFault:
				fmt.Println(rds.ErrCodeDBInstanceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list information about DB parameter groups
//
// This example lists information about the specified DB parameter group.
func ExampleClient_DescribeDBParameterGroupsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeDBParameterGroupsInput{
		DBParameterGroupName: aws.String("mymysqlparametergroup"),
	}

	req := svc.DescribeDBParameterGroupsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBParameterGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBParameterGroupNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list information about DB parameters
//
// This example lists information for up to the first 20 system parameters for the specified
// DB parameter group.
func ExampleClient_DescribeDBParametersRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeDBParametersInput{
		DBParameterGroupName: aws.String("mymysqlparametergroup"),
		MaxRecords:           aws.Int64(20),
		Source:               aws.String("system"),
	}

	req := svc.DescribeDBParametersRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBParameterGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBParameterGroupNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list DB security group settings
//
// This example lists settings for the specified security group.
func ExampleClient_DescribeDBSecurityGroupsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeDBSecurityGroupsInput{
		DBSecurityGroupName: aws.String("mydbsecuritygroup"),
	}

	req := svc.DescribeDBSecurityGroupsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBSecurityGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBSecurityGroupNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list DB snapshot attributes
//
// This example lists attributes for the specified DB snapshot.
func ExampleClient_DescribeDBSnapshotAttributesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeDBSnapshotAttributesInput{
		DBSnapshotIdentifier: aws.String("mydbsnapshot"),
	}

	req := svc.DescribeDBSnapshotAttributesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBSnapshotNotFoundFault:
				fmt.Println(rds.ErrCodeDBSnapshotNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list DB snapshot attributes
//
// This example lists all manually-created, shared snapshots for the specified DB instance.
func ExampleClient_DescribeDBSnapshotsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeDBSnapshotsInput{
		DBInstanceIdentifier: aws.String("mymysqlinstance"),
		IncludePublic:        aws.Bool(false),
		IncludeShared:        aws.Bool(true),
		SnapshotType:         aws.String("manual"),
	}

	req := svc.DescribeDBSnapshotsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBSnapshotNotFoundFault:
				fmt.Println(rds.ErrCodeDBSnapshotNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list information about DB subnet groups
//
// This example lists information about the specified DB subnet group.
func ExampleClient_DescribeDBSubnetGroupsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeDBSubnetGroupsInput{
		DBSubnetGroupName: aws.String("mydbsubnetgroup"),
	}

	req := svc.DescribeDBSubnetGroupsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBSubnetGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBSubnetGroupNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list default parameters for a DB cluster engine
//
// This example lists default parameters for the specified DB cluster engine.
func ExampleClient_DescribeEngineDefaultClusterParametersRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeEngineDefaultClusterParametersInput{
		DBParameterGroupFamily: aws.String("aurora5.6"),
	}

	req := svc.DescribeEngineDefaultClusterParametersRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list default parameters for a DB engine
//
// This example lists default parameters for the specified DB engine.
func ExampleClient_DescribeEngineDefaultParametersRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeEngineDefaultParametersInput{
		DBParameterGroupFamily: aws.String("mysql5.6"),
	}

	req := svc.DescribeEngineDefaultParametersRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list event categories.
//
// This example lists all DB instance event categories.
func ExampleClient_DescribeEventCategoriesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeEventCategoriesInput{
		SourceType: aws.String("db-instance"),
	}

	req := svc.DescribeEventCategoriesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list information about DB event notification subscriptions
//
// This example lists information for the specified DB event notification subscription.
func ExampleClient_DescribeEventSubscriptionsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeEventSubscriptionsInput{
		SubscriptionName: aws.String("mymysqleventsubscription"),
	}

	req := svc.DescribeEventSubscriptionsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeSubscriptionNotFoundFault:
				fmt.Println(rds.ErrCodeSubscriptionNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list information about events
//
// This example lists information for all backup-related events for the specified DB
// instance for the past 7 days (7 days * 24 hours * 60 minutes = 10,080 minutes).
func ExampleClient_DescribeEventsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeEventsInput{
		Duration: aws.Int64(10080),
		EventCategories: []string{
			"backup",
		},
		SourceIdentifier: aws.String("mymysqlinstance"),
		SourceType:       rds.SourceTypeDbInstance,
	}

	req := svc.DescribeEventsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list information about DB option group options
//
// This example lists information for all option group options for the specified DB
// engine.
func ExampleClient_DescribeOptionGroupOptionsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeOptionGroupOptionsInput{
		EngineName:         aws.String("mysql"),
		MajorEngineVersion: aws.String("5.6"),
	}

	req := svc.DescribeOptionGroupOptionsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list information about DB option groups
//
// This example lists information for all option groups for the specified DB engine.
func ExampleClient_DescribeOptionGroupsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeOptionGroupsInput{
		EngineName:         aws.String("mysql"),
		MajorEngineVersion: aws.String("5.6"),
	}

	req := svc.DescribeOptionGroupsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeOptionGroupNotFoundFault:
				fmt.Println(rds.ErrCodeOptionGroupNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list information about orderable DB instance options
//
// This example lists information for all orderable DB instance options for the specified
// DB engine, engine version, DB instance class, license model, and VPC settings.
func ExampleClient_DescribeOrderableDBInstanceOptionsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeOrderableDBInstanceOptionsInput{
		DBInstanceClass: aws.String("db.t2.micro"),
		Engine:          aws.String("mysql"),
		EngineVersion:   aws.String("5.6.27"),
		LicenseModel:    aws.String("general-public-license"),
		Vpc:             aws.Bool(true),
	}

	req := svc.DescribeOrderableDBInstanceOptionsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list information about pending maintenance actions
//
// This example lists information for all pending maintenance actions for the specified
// DB instance.
func ExampleClient_DescribePendingMaintenanceActionsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribePendingMaintenanceActionsInput{
		ResourceIdentifier: aws.String("arn:aws:rds:us-east-1:992648334831:db:mymysqlinstance"),
	}

	req := svc.DescribePendingMaintenanceActionsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeResourceNotFoundFault:
				fmt.Println(rds.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list information about reserved DB instances
//
// This example lists information for all reserved DB instances for the specified DB
// instance class, duration, product, offering type, and availability zone settings.
func ExampleClient_DescribeReservedDBInstancesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeReservedDBInstancesInput{
		DBInstanceClass:    aws.String("db.t2.micro"),
		Duration:           aws.String("1y"),
		MultiAZ:            aws.Bool(false),
		OfferingType:       aws.String("No Upfront"),
		ProductDescription: aws.String("mysql"),
	}

	req := svc.DescribeReservedDBInstancesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeReservedDBInstanceNotFoundFault:
				fmt.Println(rds.ErrCodeReservedDBInstanceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list information about reserved DB instance offerings
//
// This example lists information for all reserved DB instance offerings for the specified
// DB instance class, duration, product, offering type, and availability zone settings.
func ExampleClient_DescribeReservedDBInstancesOfferingsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeReservedDBInstancesOfferingsInput{
		DBInstanceClass:    aws.String("db.t2.micro"),
		Duration:           aws.String("1y"),
		MultiAZ:            aws.Bool(false),
		OfferingType:       aws.String("No Upfront"),
		ProductDescription: aws.String("mysql"),
	}

	req := svc.DescribeReservedDBInstancesOfferingsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeReservedDBInstancesOfferingNotFoundFault:
				fmt.Println(rds.ErrCodeReservedDBInstancesOfferingNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe source regions
//
// To list the AWS regions where a Read Replica can be created.
func ExampleClient_DescribeSourceRegionsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DescribeSourceRegionsInput{}

	req := svc.DescribeSourceRegionsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list information about DB log files
//
// This example lists information for the specified log file for the specified DB instance.
func ExampleClient_DownloadDBLogFilePortionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.DownloadDBLogFilePortionInput{
		DBInstanceIdentifier: aws.String("mymysqlinstance"),
		LogFileName:          aws.String("mysqlUpgrade"),
	}

	req := svc.DownloadDBLogFilePortionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBInstanceNotFoundFault:
				fmt.Println(rds.ErrCodeDBInstanceNotFoundFault, aerr.Error())
			case rds.ErrCodeDBLogFileNotFoundFault:
				fmt.Println(rds.ErrCodeDBLogFileNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To perform a failover for a DB cluster
//
// This example performs a failover for the specified DB cluster to the specified DB
// instance.
func ExampleClient_FailoverDBClusterRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.FailoverDBClusterInput{
		DBClusterIdentifier:        aws.String("myaurorainstance-cluster"),
		TargetDBInstanceIdentifier: aws.String("myaurorareplica"),
	}

	req := svc.FailoverDBClusterRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBClusterNotFoundFault:
				fmt.Println(rds.ErrCodeDBClusterNotFoundFault, aerr.Error())
			case rds.ErrCodeInvalidDBClusterStateFault:
				fmt.Println(rds.ErrCodeInvalidDBClusterStateFault, aerr.Error())
			case rds.ErrCodeInvalidDBInstanceStateFault:
				fmt.Println(rds.ErrCodeInvalidDBInstanceStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list information about tags associated with a resource
//
// This example lists information about all tags associated with the specified DB option
// group.
func ExampleClient_ListTagsForResourceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.ListTagsForResourceInput{
		ResourceName: aws.String("arn:aws:rds:us-east-1:992648334831:og:mymysqloptiongroup"),
	}

	req := svc.ListTagsForResourceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBInstanceNotFoundFault:
				fmt.Println(rds.ErrCodeDBInstanceNotFoundFault, aerr.Error())
			case rds.ErrCodeDBSnapshotNotFoundFault:
				fmt.Println(rds.ErrCodeDBSnapshotNotFoundFault, aerr.Error())
			case rds.ErrCodeDBClusterNotFoundFault:
				fmt.Println(rds.ErrCodeDBClusterNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To change DB cluster settings
//
// This example changes the specified settings for the specified DB cluster.
func ExampleClient_ModifyDBClusterRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.ModifyDBClusterInput{
		ApplyImmediately:           aws.Bool(true),
		DBClusterIdentifier:        aws.String("mydbcluster"),
		MasterUserPassword:         aws.String("mynewpassword"),
		NewDBClusterIdentifier:     aws.String("mynewdbcluster"),
		PreferredBackupWindow:      aws.String("04:00-04:30"),
		PreferredMaintenanceWindow: aws.String("Tue:05:00-Tue:05:30"),
	}

	req := svc.ModifyDBClusterRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBClusterNotFoundFault:
				fmt.Println(rds.ErrCodeDBClusterNotFoundFault, aerr.Error())
			case rds.ErrCodeInvalidDBClusterStateFault:
				fmt.Println(rds.ErrCodeInvalidDBClusterStateFault, aerr.Error())
			case rds.ErrCodeStorageQuotaExceededFault:
				fmt.Println(rds.ErrCodeStorageQuotaExceededFault, aerr.Error())
			case rds.ErrCodeDBSubnetGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBSubnetGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeInvalidVPCNetworkStateFault:
				fmt.Println(rds.ErrCodeInvalidVPCNetworkStateFault, aerr.Error())
			case rds.ErrCodeInvalidDBSubnetGroupStateFault:
				fmt.Println(rds.ErrCodeInvalidDBSubnetGroupStateFault, aerr.Error())
			case rds.ErrCodeInvalidSubnet:
				fmt.Println(rds.ErrCodeInvalidSubnet, aerr.Error())
			case rds.ErrCodeDBClusterParameterGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBClusterParameterGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeInvalidDBSecurityGroupStateFault:
				fmt.Println(rds.ErrCodeInvalidDBSecurityGroupStateFault, aerr.Error())
			case rds.ErrCodeInvalidDBInstanceStateFault:
				fmt.Println(rds.ErrCodeInvalidDBInstanceStateFault, aerr.Error())
			case rds.ErrCodeDBClusterAlreadyExistsFault:
				fmt.Println(rds.ErrCodeDBClusterAlreadyExistsFault, aerr.Error())
			case rds.ErrCodeDomainNotFoundFault:
				fmt.Println(rds.ErrCodeDomainNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To change DB cluster parameter group settings
//
// This example immediately changes the specified setting for the specified DB cluster
// parameter group.
func ExampleClient_ModifyDBClusterParameterGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.ModifyDBClusterParameterGroupInput{
		DBClusterParameterGroupName: aws.String("mydbclusterparametergroup"),
		Parameters: []rds.Parameter{
			{
				ApplyMethod:    rds.ApplyMethodImmediate,
				ParameterName:  aws.String("time_zone"),
				ParameterValue: aws.String("America/Phoenix"),
			},
		},
	}

	req := svc.ModifyDBClusterParameterGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBParameterGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBParameterGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeInvalidDBParameterGroupStateFault:
				fmt.Println(rds.ErrCodeInvalidDBParameterGroupStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add or remove access to a manual DB cluster snapshot
//
// The following example gives two AWS accounts access to a manual DB cluster snapshot
// and ensures that the DB cluster snapshot is private by removing the value "all".
func ExampleClient_ModifyDBClusterSnapshotAttributeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.ModifyDBClusterSnapshotAttributeInput{
		AttributeName:               aws.String("restore"),
		DBClusterSnapshotIdentifier: aws.String("manual-cluster-snapshot1"),
		ValuesToAdd: []string{
			"123451234512",
			"123456789012",
		},
		ValuesToRemove: []string{
			"all",
		},
	}

	req := svc.ModifyDBClusterSnapshotAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBClusterSnapshotNotFoundFault:
				fmt.Println(rds.ErrCodeDBClusterSnapshotNotFoundFault, aerr.Error())
			case rds.ErrCodeInvalidDBClusterSnapshotStateFault:
				fmt.Println(rds.ErrCodeInvalidDBClusterSnapshotStateFault, aerr.Error())
			case rds.ErrCodeSharedSnapshotQuotaExceededFault:
				fmt.Println(rds.ErrCodeSharedSnapshotQuotaExceededFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To change DB instance settings
//
// This example immediately changes the specified settings for the specified DB instance.
func ExampleClient_ModifyDBInstanceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.ModifyDBInstanceInput{
		AllocatedStorage:           aws.Int64(10),
		ApplyImmediately:           aws.Bool(true),
		BackupRetentionPeriod:      aws.Int64(1),
		DBInstanceClass:            aws.String("db.t2.small"),
		DBInstanceIdentifier:       aws.String("mymysqlinstance"),
		MasterUserPassword:         aws.String("mynewpassword"),
		PreferredBackupWindow:      aws.String("04:00-04:30"),
		PreferredMaintenanceWindow: aws.String("Tue:05:00-Tue:05:30"),
	}

	req := svc.ModifyDBInstanceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeInvalidDBInstanceStateFault:
				fmt.Println(rds.ErrCodeInvalidDBInstanceStateFault, aerr.Error())
			case rds.ErrCodeInvalidDBSecurityGroupStateFault:
				fmt.Println(rds.ErrCodeInvalidDBSecurityGroupStateFault, aerr.Error())
			case rds.ErrCodeDBInstanceAlreadyExistsFault:
				fmt.Println(rds.ErrCodeDBInstanceAlreadyExistsFault, aerr.Error())
			case rds.ErrCodeDBInstanceNotFoundFault:
				fmt.Println(rds.ErrCodeDBInstanceNotFoundFault, aerr.Error())
			case rds.ErrCodeDBSecurityGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBSecurityGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeDBParameterGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBParameterGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeInsufficientDBInstanceCapacityFault:
				fmt.Println(rds.ErrCodeInsufficientDBInstanceCapacityFault, aerr.Error())
			case rds.ErrCodeStorageQuotaExceededFault:
				fmt.Println(rds.ErrCodeStorageQuotaExceededFault, aerr.Error())
			case rds.ErrCodeInvalidVPCNetworkStateFault:
				fmt.Println(rds.ErrCodeInvalidVPCNetworkStateFault, aerr.Error())
			case rds.ErrCodeProvisionedIopsNotAvailableInAZFault:
				fmt.Println(rds.ErrCodeProvisionedIopsNotAvailableInAZFault, aerr.Error())
			case rds.ErrCodeOptionGroupNotFoundFault:
				fmt.Println(rds.ErrCodeOptionGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeDBUpgradeDependencyFailureFault:
				fmt.Println(rds.ErrCodeDBUpgradeDependencyFailureFault, aerr.Error())
			case rds.ErrCodeStorageTypeNotSupportedFault:
				fmt.Println(rds.ErrCodeStorageTypeNotSupportedFault, aerr.Error())
			case rds.ErrCodeAuthorizationNotFoundFault:
				fmt.Println(rds.ErrCodeAuthorizationNotFoundFault, aerr.Error())
			case rds.ErrCodeCertificateNotFoundFault:
				fmt.Println(rds.ErrCodeCertificateNotFoundFault, aerr.Error())
			case rds.ErrCodeDomainNotFoundFault:
				fmt.Println(rds.ErrCodeDomainNotFoundFault, aerr.Error())
			case rds.ErrCodeBackupPolicyNotFoundFault:
				fmt.Println(rds.ErrCodeBackupPolicyNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To change DB parameter group settings
//
// This example immediately changes the specified setting for the specified DB parameter
// group.
func ExampleClient_ModifyDBParameterGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.ModifyDBParameterGroupInput{
		DBParameterGroupName: aws.String("mymysqlparametergroup"),
		Parameters: []rds.Parameter{
			{
				ApplyMethod:    rds.ApplyMethodImmediate,
				ParameterName:  aws.String("time_zone"),
				ParameterValue: aws.String("America/Phoenix"),
			},
		},
	}

	req := svc.ModifyDBParameterGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBParameterGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBParameterGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeInvalidDBParameterGroupStateFault:
				fmt.Println(rds.ErrCodeInvalidDBParameterGroupStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To change DB snapshot attributes
//
// This example adds the specified attribute for the specified DB snapshot.
func ExampleClient_ModifyDBSnapshotAttributeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.ModifyDBSnapshotAttributeInput{
		AttributeName:        aws.String("restore"),
		DBSnapshotIdentifier: aws.String("mydbsnapshot"),
		ValuesToAdd: []string{
			"all",
		},
	}

	req := svc.ModifyDBSnapshotAttributeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBSnapshotNotFoundFault:
				fmt.Println(rds.ErrCodeDBSnapshotNotFoundFault, aerr.Error())
			case rds.ErrCodeInvalidDBSnapshotStateFault:
				fmt.Println(rds.ErrCodeInvalidDBSnapshotStateFault, aerr.Error())
			case rds.ErrCodeSharedSnapshotQuotaExceededFault:
				fmt.Println(rds.ErrCodeSharedSnapshotQuotaExceededFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To change DB subnet group settings
//
// This example changes the specified setting for the specified DB subnet group.
func ExampleClient_ModifyDBSubnetGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.ModifyDBSubnetGroupInput{
		DBSubnetGroupName: aws.String("mydbsubnetgroup"),
		SubnetIds: []string{
			"subnet-70e1975a",
			"subnet-747a5c49",
		},
	}

	req := svc.ModifyDBSubnetGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBSubnetGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBSubnetGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeDBSubnetQuotaExceededFault:
				fmt.Println(rds.ErrCodeDBSubnetQuotaExceededFault, aerr.Error())
			case rds.ErrCodeSubnetAlreadyInUse:
				fmt.Println(rds.ErrCodeSubnetAlreadyInUse, aerr.Error())
			case rds.ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs:
				fmt.Println(rds.ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs, aerr.Error())
			case rds.ErrCodeInvalidSubnet:
				fmt.Println(rds.ErrCodeInvalidSubnet, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To change event notification subscription settings
//
// This example changes the specified setting for the specified event notification subscription.
func ExampleClient_ModifyEventSubscriptionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.ModifyEventSubscriptionInput{
		Enabled: aws.Bool(true),
		EventCategories: []string{
			"deletion",
			"low storage",
		},
		SourceType:       aws.String("db-instance"),
		SubscriptionName: aws.String("mymysqleventsubscription"),
	}

	req := svc.ModifyEventSubscriptionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeEventSubscriptionQuotaExceededFault:
				fmt.Println(rds.ErrCodeEventSubscriptionQuotaExceededFault, aerr.Error())
			case rds.ErrCodeSubscriptionNotFoundFault:
				fmt.Println(rds.ErrCodeSubscriptionNotFoundFault, aerr.Error())
			case rds.ErrCodeSNSInvalidTopicFault:
				fmt.Println(rds.ErrCodeSNSInvalidTopicFault, aerr.Error())
			case rds.ErrCodeSNSNoAuthorizationFault:
				fmt.Println(rds.ErrCodeSNSNoAuthorizationFault, aerr.Error())
			case rds.ErrCodeSNSTopicArnNotFoundFault:
				fmt.Println(rds.ErrCodeSNSTopicArnNotFoundFault, aerr.Error())
			case rds.ErrCodeSubscriptionCategoryNotFoundFault:
				fmt.Println(rds.ErrCodeSubscriptionCategoryNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify an option group
//
// The following example adds an option to an option group.
func ExampleClient_ModifyOptionGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.ModifyOptionGroupInput{
		ApplyImmediately: aws.Bool(true),
		OptionGroupName:  aws.String("myawsuser-og02"),
		OptionsToInclude: []rds.OptionConfiguration{
			{
				DBSecurityGroupMemberships: []string{
					"default",
				},
				OptionName: aws.String("MEMCACHED"),
			},
		},
	}

	req := svc.ModifyOptionGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeInvalidOptionGroupStateFault:
				fmt.Println(rds.ErrCodeInvalidOptionGroupStateFault, aerr.Error())
			case rds.ErrCodeOptionGroupNotFoundFault:
				fmt.Println(rds.ErrCodeOptionGroupNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To promote a read replica
//
// This example promotes the specified read replica and sets its backup retention period
// and preferred backup window.
func ExampleClient_PromoteReadReplicaRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.PromoteReadReplicaInput{
		BackupRetentionPeriod: aws.Int64(1),
		DBInstanceIdentifier:  aws.String("mydbreadreplica"),
		PreferredBackupWindow: aws.String("03:30-04:00"),
	}

	req := svc.PromoteReadReplicaRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeInvalidDBInstanceStateFault:
				fmt.Println(rds.ErrCodeInvalidDBInstanceStateFault, aerr.Error())
			case rds.ErrCodeDBInstanceNotFoundFault:
				fmt.Println(rds.ErrCodeDBInstanceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To purchase a reserved DB instance offering
//
// This example purchases a reserved DB instance offering that matches the specified
// settings.
func ExampleClient_PurchaseReservedDBInstancesOfferingRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.PurchaseReservedDBInstancesOfferingInput{
		ReservedDBInstanceId:          aws.String("myreservationid"),
		ReservedDBInstancesOfferingId: aws.String("fb29428a-646d-4390-850e-5fe89926e727"),
	}

	req := svc.PurchaseReservedDBInstancesOfferingRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeReservedDBInstancesOfferingNotFoundFault:
				fmt.Println(rds.ErrCodeReservedDBInstancesOfferingNotFoundFault, aerr.Error())
			case rds.ErrCodeReservedDBInstanceAlreadyExistsFault:
				fmt.Println(rds.ErrCodeReservedDBInstanceAlreadyExistsFault, aerr.Error())
			case rds.ErrCodeReservedDBInstanceQuotaExceededFault:
				fmt.Println(rds.ErrCodeReservedDBInstanceQuotaExceededFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To reboot a DB instance
//
// This example reboots the specified DB instance without forcing a failover.
func ExampleClient_RebootDBInstanceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.RebootDBInstanceInput{
		DBInstanceIdentifier: aws.String("mymysqlinstance"),
		ForceFailover:        aws.Bool(false),
	}

	req := svc.RebootDBInstanceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeInvalidDBInstanceStateFault:
				fmt.Println(rds.ErrCodeInvalidDBInstanceStateFault, aerr.Error())
			case rds.ErrCodeDBInstanceNotFoundFault:
				fmt.Println(rds.ErrCodeDBInstanceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To remove a source identifier from a DB event subscription
//
// This example removes the specified source identifier from the specified DB event
// subscription.
func ExampleClient_RemoveSourceIdentifierFromSubscriptionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.RemoveSourceIdentifierFromSubscriptionInput{
		SourceIdentifier: aws.String("mymysqlinstance"),
		SubscriptionName: aws.String("myeventsubscription"),
	}

	req := svc.RemoveSourceIdentifierFromSubscriptionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeSubscriptionNotFoundFault:
				fmt.Println(rds.ErrCodeSubscriptionNotFoundFault, aerr.Error())
			case rds.ErrCodeSourceNotFoundFault:
				fmt.Println(rds.ErrCodeSourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To remove tags from a resource
//
// This example removes the specified tag associated with the specified DB option group.
func ExampleClient_RemoveTagsFromResourceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.RemoveTagsFromResourceInput{
		ResourceName: aws.String("arn:aws:rds:us-east-1:992648334831:og:mydboptiongroup"),
		TagKeys: []string{
			"MyKey",
		},
	}

	req := svc.RemoveTagsFromResourceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBInstanceNotFoundFault:
				fmt.Println(rds.ErrCodeDBInstanceNotFoundFault, aerr.Error())
			case rds.ErrCodeDBSnapshotNotFoundFault:
				fmt.Println(rds.ErrCodeDBSnapshotNotFoundFault, aerr.Error())
			case rds.ErrCodeDBClusterNotFoundFault:
				fmt.Println(rds.ErrCodeDBClusterNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To reset the values of a DB cluster parameter group
//
// This example resets all parameters for the specified DB cluster parameter group to
// their default values.
func ExampleClient_ResetDBClusterParameterGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.ResetDBClusterParameterGroupInput{
		DBClusterParameterGroupName: aws.String("mydbclusterparametergroup"),
		ResetAllParameters:          aws.Bool(true),
	}

	req := svc.ResetDBClusterParameterGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeInvalidDBParameterGroupStateFault:
				fmt.Println(rds.ErrCodeInvalidDBParameterGroupStateFault, aerr.Error())
			case rds.ErrCodeDBParameterGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBParameterGroupNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To reset the values of a DB parameter group
//
// This example resets all parameters for the specified DB parameter group to their
// default values.
func ExampleClient_ResetDBParameterGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.ResetDBParameterGroupInput{
		DBParameterGroupName: aws.String("mydbparametergroup"),
		ResetAllParameters:   aws.Bool(true),
	}

	req := svc.ResetDBParameterGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeInvalidDBParameterGroupStateFault:
				fmt.Println(rds.ErrCodeInvalidDBParameterGroupStateFault, aerr.Error())
			case rds.ErrCodeDBParameterGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBParameterGroupNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To restore an Amazon Aurora DB cluster from a DB cluster snapshot
//
// The following example restores an Amazon Aurora DB cluster from a DB cluster snapshot.
func ExampleClient_RestoreDBClusterFromSnapshotRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.RestoreDBClusterFromSnapshotInput{
		DBClusterIdentifier: aws.String("restored-cluster1"),
		Engine:              aws.String("aurora"),
		SnapshotIdentifier:  aws.String("sample-cluster-snapshot1"),
	}

	req := svc.RestoreDBClusterFromSnapshotRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBClusterAlreadyExistsFault:
				fmt.Println(rds.ErrCodeDBClusterAlreadyExistsFault, aerr.Error())
			case rds.ErrCodeDBClusterQuotaExceededFault:
				fmt.Println(rds.ErrCodeDBClusterQuotaExceededFault, aerr.Error())
			case rds.ErrCodeStorageQuotaExceededFault:
				fmt.Println(rds.ErrCodeStorageQuotaExceededFault, aerr.Error())
			case rds.ErrCodeDBSubnetGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBSubnetGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeDBSnapshotNotFoundFault:
				fmt.Println(rds.ErrCodeDBSnapshotNotFoundFault, aerr.Error())
			case rds.ErrCodeDBClusterSnapshotNotFoundFault:
				fmt.Println(rds.ErrCodeDBClusterSnapshotNotFoundFault, aerr.Error())
			case rds.ErrCodeInsufficientDBClusterCapacityFault:
				fmt.Println(rds.ErrCodeInsufficientDBClusterCapacityFault, aerr.Error())
			case rds.ErrCodeInsufficientStorageClusterCapacityFault:
				fmt.Println(rds.ErrCodeInsufficientStorageClusterCapacityFault, aerr.Error())
			case rds.ErrCodeInvalidDBSnapshotStateFault:
				fmt.Println(rds.ErrCodeInvalidDBSnapshotStateFault, aerr.Error())
			case rds.ErrCodeInvalidDBClusterSnapshotStateFault:
				fmt.Println(rds.ErrCodeInvalidDBClusterSnapshotStateFault, aerr.Error())
			case rds.ErrCodeInvalidVPCNetworkStateFault:
				fmt.Println(rds.ErrCodeInvalidVPCNetworkStateFault, aerr.Error())
			case rds.ErrCodeInvalidRestoreFault:
				fmt.Println(rds.ErrCodeInvalidRestoreFault, aerr.Error())
			case rds.ErrCodeInvalidSubnet:
				fmt.Println(rds.ErrCodeInvalidSubnet, aerr.Error())
			case rds.ErrCodeOptionGroupNotFoundFault:
				fmt.Println(rds.ErrCodeOptionGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(rds.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case rds.ErrCodeDomainNotFoundFault:
				fmt.Println(rds.ErrCodeDomainNotFoundFault, aerr.Error())
			case rds.ErrCodeDBClusterParameterGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBClusterParameterGroupNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To restore a DB cluster to a point in time.
//
// The following example restores a DB cluster to a new DB cluster at a point in time
// from the source DB cluster.
func ExampleClient_RestoreDBClusterToPointInTimeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.RestoreDBClusterToPointInTimeInput{
		DBClusterIdentifier:       aws.String("sample-restored-cluster1"),
		RestoreToTime:             parseTime("2006-01-02T15:04:05Z", "2016-09-13T18:45:00Z"),
		SourceDBClusterIdentifier: aws.String("sample-cluster1"),
	}

	req := svc.RestoreDBClusterToPointInTimeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBClusterAlreadyExistsFault:
				fmt.Println(rds.ErrCodeDBClusterAlreadyExistsFault, aerr.Error())
			case rds.ErrCodeDBClusterNotFoundFault:
				fmt.Println(rds.ErrCodeDBClusterNotFoundFault, aerr.Error())
			case rds.ErrCodeDBClusterQuotaExceededFault:
				fmt.Println(rds.ErrCodeDBClusterQuotaExceededFault, aerr.Error())
			case rds.ErrCodeDBClusterSnapshotNotFoundFault:
				fmt.Println(rds.ErrCodeDBClusterSnapshotNotFoundFault, aerr.Error())
			case rds.ErrCodeDBSubnetGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBSubnetGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeInsufficientDBClusterCapacityFault:
				fmt.Println(rds.ErrCodeInsufficientDBClusterCapacityFault, aerr.Error())
			case rds.ErrCodeInsufficientStorageClusterCapacityFault:
				fmt.Println(rds.ErrCodeInsufficientStorageClusterCapacityFault, aerr.Error())
			case rds.ErrCodeInvalidDBClusterSnapshotStateFault:
				fmt.Println(rds.ErrCodeInvalidDBClusterSnapshotStateFault, aerr.Error())
			case rds.ErrCodeInvalidDBClusterStateFault:
				fmt.Println(rds.ErrCodeInvalidDBClusterStateFault, aerr.Error())
			case rds.ErrCodeInvalidDBSnapshotStateFault:
				fmt.Println(rds.ErrCodeInvalidDBSnapshotStateFault, aerr.Error())
			case rds.ErrCodeInvalidRestoreFault:
				fmt.Println(rds.ErrCodeInvalidRestoreFault, aerr.Error())
			case rds.ErrCodeInvalidSubnet:
				fmt.Println(rds.ErrCodeInvalidSubnet, aerr.Error())
			case rds.ErrCodeInvalidVPCNetworkStateFault:
				fmt.Println(rds.ErrCodeInvalidVPCNetworkStateFault, aerr.Error())
			case rds.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(rds.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case rds.ErrCodeOptionGroupNotFoundFault:
				fmt.Println(rds.ErrCodeOptionGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeStorageQuotaExceededFault:
				fmt.Println(rds.ErrCodeStorageQuotaExceededFault, aerr.Error())
			case rds.ErrCodeDomainNotFoundFault:
				fmt.Println(rds.ErrCodeDomainNotFoundFault, aerr.Error())
			case rds.ErrCodeDBClusterParameterGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBClusterParameterGroupNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To restore a DB instance from a DB snapshot.
//
// The following example restores a DB instance from a DB snapshot.
func ExampleClient_RestoreDBInstanceFromDBSnapshotRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.RestoreDBInstanceFromDBSnapshotInput{
		DBInstanceIdentifier: aws.String("mysqldb-restored"),
		DBSnapshotIdentifier: aws.String("rds:mysqldb-2014-04-22-08-15"),
	}

	req := svc.RestoreDBInstanceFromDBSnapshotRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBInstanceAlreadyExistsFault:
				fmt.Println(rds.ErrCodeDBInstanceAlreadyExistsFault, aerr.Error())
			case rds.ErrCodeDBSnapshotNotFoundFault:
				fmt.Println(rds.ErrCodeDBSnapshotNotFoundFault, aerr.Error())
			case rds.ErrCodeInstanceQuotaExceededFault:
				fmt.Println(rds.ErrCodeInstanceQuotaExceededFault, aerr.Error())
			case rds.ErrCodeInsufficientDBInstanceCapacityFault:
				fmt.Println(rds.ErrCodeInsufficientDBInstanceCapacityFault, aerr.Error())
			case rds.ErrCodeInvalidDBSnapshotStateFault:
				fmt.Println(rds.ErrCodeInvalidDBSnapshotStateFault, aerr.Error())
			case rds.ErrCodeStorageQuotaExceededFault:
				fmt.Println(rds.ErrCodeStorageQuotaExceededFault, aerr.Error())
			case rds.ErrCodeInvalidVPCNetworkStateFault:
				fmt.Println(rds.ErrCodeInvalidVPCNetworkStateFault, aerr.Error())
			case rds.ErrCodeInvalidRestoreFault:
				fmt.Println(rds.ErrCodeInvalidRestoreFault, aerr.Error())
			case rds.ErrCodeDBSubnetGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBSubnetGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs:
				fmt.Println(rds.ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs, aerr.Error())
			case rds.ErrCodeInvalidSubnet:
				fmt.Println(rds.ErrCodeInvalidSubnet, aerr.Error())
			case rds.ErrCodeProvisionedIopsNotAvailableInAZFault:
				fmt.Println(rds.ErrCodeProvisionedIopsNotAvailableInAZFault, aerr.Error())
			case rds.ErrCodeOptionGroupNotFoundFault:
				fmt.Println(rds.ErrCodeOptionGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeStorageTypeNotSupportedFault:
				fmt.Println(rds.ErrCodeStorageTypeNotSupportedFault, aerr.Error())
			case rds.ErrCodeAuthorizationNotFoundFault:
				fmt.Println(rds.ErrCodeAuthorizationNotFoundFault, aerr.Error())
			case rds.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(rds.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case rds.ErrCodeDBSecurityGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBSecurityGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeDomainNotFoundFault:
				fmt.Println(rds.ErrCodeDomainNotFoundFault, aerr.Error())
			case rds.ErrCodeDBParameterGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBParameterGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeBackupPolicyNotFoundFault:
				fmt.Println(rds.ErrCodeBackupPolicyNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To restore a DB instance to a point in time.
//
// The following example restores a DB instance to a new DB instance at a point in time
// from the source DB instance.
func ExampleClient_RestoreDBInstanceToPointInTimeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.RestoreDBInstanceToPointInTimeInput{
		RestoreTime:                parseTime("2006-01-02T15:04:05Z", "2016-09-13T18:45:00Z"),
		SourceDBInstanceIdentifier: aws.String("mysql-sample"),
		TargetDBInstanceIdentifier: aws.String("mysql-sample-restored"),
	}

	req := svc.RestoreDBInstanceToPointInTimeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBInstanceAlreadyExistsFault:
				fmt.Println(rds.ErrCodeDBInstanceAlreadyExistsFault, aerr.Error())
			case rds.ErrCodeDBInstanceNotFoundFault:
				fmt.Println(rds.ErrCodeDBInstanceNotFoundFault, aerr.Error())
			case rds.ErrCodeInstanceQuotaExceededFault:
				fmt.Println(rds.ErrCodeInstanceQuotaExceededFault, aerr.Error())
			case rds.ErrCodeInsufficientDBInstanceCapacityFault:
				fmt.Println(rds.ErrCodeInsufficientDBInstanceCapacityFault, aerr.Error())
			case rds.ErrCodeInvalidDBInstanceStateFault:
				fmt.Println(rds.ErrCodeInvalidDBInstanceStateFault, aerr.Error())
			case rds.ErrCodePointInTimeRestoreNotEnabledFault:
				fmt.Println(rds.ErrCodePointInTimeRestoreNotEnabledFault, aerr.Error())
			case rds.ErrCodeStorageQuotaExceededFault:
				fmt.Println(rds.ErrCodeStorageQuotaExceededFault, aerr.Error())
			case rds.ErrCodeInvalidVPCNetworkStateFault:
				fmt.Println(rds.ErrCodeInvalidVPCNetworkStateFault, aerr.Error())
			case rds.ErrCodeInvalidRestoreFault:
				fmt.Println(rds.ErrCodeInvalidRestoreFault, aerr.Error())
			case rds.ErrCodeDBSubnetGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBSubnetGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs:
				fmt.Println(rds.ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs, aerr.Error())
			case rds.ErrCodeInvalidSubnet:
				fmt.Println(rds.ErrCodeInvalidSubnet, aerr.Error())
			case rds.ErrCodeProvisionedIopsNotAvailableInAZFault:
				fmt.Println(rds.ErrCodeProvisionedIopsNotAvailableInAZFault, aerr.Error())
			case rds.ErrCodeOptionGroupNotFoundFault:
				fmt.Println(rds.ErrCodeOptionGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeStorageTypeNotSupportedFault:
				fmt.Println(rds.ErrCodeStorageTypeNotSupportedFault, aerr.Error())
			case rds.ErrCodeAuthorizationNotFoundFault:
				fmt.Println(rds.ErrCodeAuthorizationNotFoundFault, aerr.Error())
			case rds.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(rds.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case rds.ErrCodeDBSecurityGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBSecurityGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeDomainNotFoundFault:
				fmt.Println(rds.ErrCodeDomainNotFoundFault, aerr.Error())
			case rds.ErrCodeBackupPolicyNotFoundFault:
				fmt.Println(rds.ErrCodeBackupPolicyNotFoundFault, aerr.Error())
			case rds.ErrCodeDBParameterGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBParameterGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeDBInstanceAutomatedBackupNotFoundFault:
				fmt.Println(rds.ErrCodeDBInstanceAutomatedBackupNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To revoke ingress for a DB security group
//
// This example revokes ingress for the specified CIDR block associated with the specified
// DB security group.
func ExampleClient_RevokeDBSecurityGroupIngressRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := rds.New(cfg)
	input := &rds.RevokeDBSecurityGroupIngressInput{
		CIDRIP:              aws.String("203.0.113.5/32"),
		DBSecurityGroupName: aws.String("mydbsecuritygroup"),
	}

	req := svc.RevokeDBSecurityGroupIngressRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case rds.ErrCodeDBSecurityGroupNotFoundFault:
				fmt.Println(rds.ErrCodeDBSecurityGroupNotFoundFault, aerr.Error())
			case rds.ErrCodeAuthorizationNotFoundFault:
				fmt.Println(rds.ErrCodeAuthorizationNotFoundFault, aerr.Error())
			case rds.ErrCodeInvalidDBSecurityGroupStateFault:
				fmt.Println(rds.ErrCodeInvalidDBSecurityGroupStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
