// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteInstallationMediaInput struct {
	_ struct{} `type:"structure"`

	// The installation medium ID.
	//
	// InstallationMediaId is a required field
	InstallationMediaId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInstallationMediaInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInstallationMediaInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteInstallationMediaInput"}

	if s.InstallationMediaId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstallationMediaId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the installation media for a DB engine that requires an on-premises
// customer provided license, such as Microsoft SQL Server.
type DeleteInstallationMediaOutput struct {
	_ struct{} `type:"structure"`

	// The custom Availability Zone (AZ) that contains the installation media.
	CustomAvailabilityZoneId *string `type:"string"`

	// The DB engine.
	Engine *string `type:"string"`

	// The path to the installation medium for the DB engine.
	EngineInstallationMediaPath *string `type:"string"`

	// The engine version of the DB engine.
	EngineVersion *string `type:"string"`

	// If an installation media failure occurred, the cause of the failure.
	FailureCause *InstallationMediaFailureCause `type:"structure"`

	// The installation medium ID.
	InstallationMediaId *string `type:"string"`

	// The path to the installation medium for the operating system associated with
	// the DB engine.
	OSInstallationMediaPath *string `type:"string"`

	// The status of the installation medium.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DeleteInstallationMediaOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteInstallationMedia = "DeleteInstallationMedia"

// DeleteInstallationMediaRequest returns a request value for making API operation for
// Amazon Relational Database Service.
//
// Deletes the installation medium for a DB engine that requires an on-premises
// customer provided license, such as Microsoft SQL Server.
//
//    // Example sending a request using DeleteInstallationMediaRequest.
//    req := client.DeleteInstallationMediaRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteInstallationMedia
func (c *Client) DeleteInstallationMediaRequest(input *DeleteInstallationMediaInput) DeleteInstallationMediaRequest {
	op := &aws.Operation{
		Name:       opDeleteInstallationMedia,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInstallationMediaInput{}
	}

	req := c.newRequest(op, input, &DeleteInstallationMediaOutput{})
	return DeleteInstallationMediaRequest{Request: req, Input: input, Copy: c.DeleteInstallationMediaRequest}
}

// DeleteInstallationMediaRequest is the request type for the
// DeleteInstallationMedia API operation.
type DeleteInstallationMediaRequest struct {
	*aws.Request
	Input *DeleteInstallationMediaInput
	Copy  func(*DeleteInstallationMediaInput) DeleteInstallationMediaRequest
}

// Send marshals and sends the DeleteInstallationMedia API request.
func (r DeleteInstallationMediaRequest) Send(ctx context.Context) (*DeleteInstallationMediaResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteInstallationMediaResponse{
		DeleteInstallationMediaOutput: r.Request.Data.(*DeleteInstallationMediaOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteInstallationMediaResponse is the response type for the
// DeleteInstallationMedia API operation.
type DeleteInstallationMediaResponse struct {
	*DeleteInstallationMediaOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteInstallationMedia request.
func (r *DeleteInstallationMediaResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
