// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ImportInstallationMediaInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the custom Availability Zone (AZ) to import the installation
	// media to.
	//
	// CustomAvailabilityZoneId is a required field
	CustomAvailabilityZoneId *string `type:"string" required:"true"`

	// The name of the database engine to be used for this instance.
	//
	// The list only includes supported DB engines that require an on-premises customer
	// provided license.
	//
	// Valid Values:
	//
	//    * sqlserver-ee
	//
	//    * sqlserver-se
	//
	//    * sqlserver-ex
	//
	//    * sqlserver-web
	//
	// Engine is a required field
	Engine *string `type:"string" required:"true"`

	// The path to the installation medium for the specified DB engine.
	//
	// Example: SQLServerISO/en_sql_server_2016_enterprise_x64_dvd_8701793.iso
	//
	// EngineInstallationMediaPath is a required field
	EngineInstallationMediaPath *string `type:"string" required:"true"`

	// The version number of the database engine to use.
	//
	// For a list of valid engine versions, call DescribeDBEngineVersions.
	//
	// The following are the database engines and links to information about the
	// major and minor versions. The list only includes DB engines that require
	// an on-premises customer provided license.
	//
	// Microsoft SQL Server
	//
	// See Version and Feature Support on Amazon RDS (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.FeatureSupport)
	// in the Amazon RDS User Guide.
	//
	// EngineVersion is a required field
	EngineVersion *string `type:"string" required:"true"`

	// The path to the installation medium for the operating system associated with
	// the specified DB engine.
	//
	// Example: WindowsISO/en_windows_server_2016_x64_dvd_9327751.iso
	//
	// OSInstallationMediaPath is a required field
	OSInstallationMediaPath *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ImportInstallationMediaInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportInstallationMediaInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ImportInstallationMediaInput"}

	if s.CustomAvailabilityZoneId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CustomAvailabilityZoneId"))
	}

	if s.Engine == nil {
		invalidParams.Add(aws.NewErrParamRequired("Engine"))
	}

	if s.EngineInstallationMediaPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("EngineInstallationMediaPath"))
	}

	if s.EngineVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("EngineVersion"))
	}

	if s.OSInstallationMediaPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("OSInstallationMediaPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the installation media for a DB engine that requires an on-premises
// customer provided license, such as Microsoft SQL Server.
type ImportInstallationMediaOutput struct {
	_ struct{} `type:"structure"`

	// The custom Availability Zone (AZ) that contains the installation media.
	CustomAvailabilityZoneId *string `type:"string"`

	// The DB engine.
	Engine *string `type:"string"`

	// The path to the installation medium for the DB engine.
	EngineInstallationMediaPath *string `type:"string"`

	// The engine version of the DB engine.
	EngineVersion *string `type:"string"`

	// If an installation media failure occurred, the cause of the failure.
	FailureCause *InstallationMediaFailureCause `type:"structure"`

	// The installation medium ID.
	InstallationMediaId *string `type:"string"`

	// The path to the installation medium for the operating system associated with
	// the DB engine.
	OSInstallationMediaPath *string `type:"string"`

	// The status of the installation medium.
	Status *string `type:"string"`
}

// String returns the string representation
func (s ImportInstallationMediaOutput) String() string {
	return awsutil.Prettify(s)
}

const opImportInstallationMedia = "ImportInstallationMedia"

// ImportInstallationMediaRequest returns a request value for making API operation for
// Amazon Relational Database Service.
//
// Imports the installation media for a DB engine that requires an on-premises
// customer provided license, such as SQL Server.
//
//    // Example sending a request using ImportInstallationMediaRequest.
//    req := client.ImportInstallationMediaRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ImportInstallationMedia
func (c *Client) ImportInstallationMediaRequest(input *ImportInstallationMediaInput) ImportInstallationMediaRequest {
	op := &aws.Operation{
		Name:       opImportInstallationMedia,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportInstallationMediaInput{}
	}

	req := c.newRequest(op, input, &ImportInstallationMediaOutput{})
	return ImportInstallationMediaRequest{Request: req, Input: input, Copy: c.ImportInstallationMediaRequest}
}

// ImportInstallationMediaRequest is the request type for the
// ImportInstallationMedia API operation.
type ImportInstallationMediaRequest struct {
	*aws.Request
	Input *ImportInstallationMediaInput
	Copy  func(*ImportInstallationMediaInput) ImportInstallationMediaRequest
}

// Send marshals and sends the ImportInstallationMedia API request.
func (r ImportInstallationMediaRequest) Send(ctx context.Context) (*ImportInstallationMediaResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ImportInstallationMediaResponse{
		ImportInstallationMediaOutput: r.Request.Data.(*ImportInstallationMediaOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ImportInstallationMediaResponse is the response type for the
// ImportInstallationMedia API operation.
type ImportInstallationMediaResponse struct {
	*ImportInstallationMediaOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ImportInstallationMedia request.
func (r *ImportInstallationMediaResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
