// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ModifyDBProxyTargetGroupInput struct {
	_ struct{} `type:"structure"`

	// The settings that determine the size and behavior of the connection pool
	// for the target group.
	ConnectionPoolConfig *ConnectionPoolConfiguration `type:"structure"`

	// The name of the new proxy to which to assign the target group.
	//
	// DBProxyName is a required field
	DBProxyName *string `type:"string" required:"true"`

	// The new name for the modified DBProxyTarget. An identifier must begin with
	// a letter and must contain only ASCII letters, digits, and hyphens; it can't
	// end with a hyphen or contain two consecutive hyphens.
	NewName *string `type:"string"`

	// The name of the new target group to assign to the proxy.
	//
	// TargetGroupName is a required field
	TargetGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyDBProxyTargetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDBProxyTargetGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyDBProxyTargetGroupInput"}

	if s.DBProxyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DBProxyName"))
	}

	if s.TargetGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyDBProxyTargetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The settings of the modified DBProxyTarget.
	DBProxyTargetGroup *DBProxyTargetGroup `type:"structure"`
}

// String returns the string representation
func (s ModifyDBProxyTargetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyDBProxyTargetGroup = "ModifyDBProxyTargetGroup"

// ModifyDBProxyTargetGroupRequest returns a request value for making API operation for
// Amazon Relational Database Service.
//
//
// This is prerelease documentation for the RDS Database Proxy feature in preview
// release. It is subject to change.
//
// Modifies the properties of a DBProxyTargetGroup.
//
//    // Example sending a request using ModifyDBProxyTargetGroupRequest.
//    req := client.ModifyDBProxyTargetGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBProxyTargetGroup
func (c *Client) ModifyDBProxyTargetGroupRequest(input *ModifyDBProxyTargetGroupInput) ModifyDBProxyTargetGroupRequest {
	op := &aws.Operation{
		Name:       opModifyDBProxyTargetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBProxyTargetGroupInput{}
	}

	req := c.newRequest(op, input, &ModifyDBProxyTargetGroupOutput{})
	return ModifyDBProxyTargetGroupRequest{Request: req, Input: input, Copy: c.ModifyDBProxyTargetGroupRequest}
}

// ModifyDBProxyTargetGroupRequest is the request type for the
// ModifyDBProxyTargetGroup API operation.
type ModifyDBProxyTargetGroupRequest struct {
	*aws.Request
	Input *ModifyDBProxyTargetGroupInput
	Copy  func(*ModifyDBProxyTargetGroupInput) ModifyDBProxyTargetGroupRequest
}

// Send marshals and sends the ModifyDBProxyTargetGroup API request.
func (r ModifyDBProxyTargetGroupRequest) Send(ctx context.Context) (*ModifyDBProxyTargetGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyDBProxyTargetGroupResponse{
		ModifyDBProxyTargetGroupOutput: r.Request.Data.(*ModifyDBProxyTargetGroupOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyDBProxyTargetGroupResponse is the response type for the
// ModifyDBProxyTargetGroup API operation.
type ModifyDBProxyTargetGroupResponse struct {
	*ModifyDBProxyTargetGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyDBProxyTargetGroup request.
func (r *ModifyDBProxyTargetGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
