// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53resolver

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetResolverEndpointInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resolver endpoint that you want to get information about.
	//
	// ResolverEndpointId is a required field
	ResolverEndpointId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetResolverEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResolverEndpointInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetResolverEndpointInput"}

	if s.ResolverEndpointId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResolverEndpointId"))
	}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResolverEndpointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetResolverEndpointOutput struct {
	_ struct{} `type:"structure"`

	// Information about the resolver endpoint that you specified in a GetResolverEndpoint
	// request.
	ResolverEndpoint *ResolverEndpoint `type:"structure"`
}

// String returns the string representation
func (s GetResolverEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetResolverEndpoint = "GetResolverEndpoint"

// GetResolverEndpointRequest returns a request value for making API operation for
// Amazon Route 53 Resolver.
//
// Gets information about a specified resolver endpoint, such as whether it's
// an inbound or an outbound resolver endpoint, and the current status of the
// endpoint.
//
//    // Example sending a request using GetResolverEndpointRequest.
//    req := client.GetResolverEndpointRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverEndpoint
func (c *Client) GetResolverEndpointRequest(input *GetResolverEndpointInput) GetResolverEndpointRequest {
	op := &aws.Operation{
		Name:       opGetResolverEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResolverEndpointInput{}
	}

	req := c.newRequest(op, input, &GetResolverEndpointOutput{})
	return GetResolverEndpointRequest{Request: req, Input: input, Copy: c.GetResolverEndpointRequest}
}

// GetResolverEndpointRequest is the request type for the
// GetResolverEndpoint API operation.
type GetResolverEndpointRequest struct {
	*aws.Request
	Input *GetResolverEndpointInput
	Copy  func(*GetResolverEndpointInput) GetResolverEndpointRequest
}

// Send marshals and sends the GetResolverEndpoint API request.
func (r GetResolverEndpointRequest) Send(ctx context.Context) (*GetResolverEndpointResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetResolverEndpointResponse{
		GetResolverEndpointOutput: r.Request.Data.(*GetResolverEndpointOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetResolverEndpointResponse is the response type for the
// GetResolverEndpoint API operation.
type GetResolverEndpointResponse struct {
	*GetResolverEndpointOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetResolverEndpoint request.
func (r *GetResolverEndpointResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
