// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetObjectTaggingInput struct {
	_ struct{} `type:"structure"`

	// The bucket name containing the object for which to get the tagging information.
	//
	// When using this API with an access point, you must direct requests to the
	// access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this operation using an access point through the AWS SDKs, you
	// provide the access point ARN in place of the bucket name. For more information
	// about access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html)
	// in the Amazon Simple Storage Service Developer Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Object key for which to get the tagging information.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// The versionId of the object for which to get the tagging information.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s GetObjectTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectTaggingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetObjectTaggingInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetObjectTaggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetObjectTaggingInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "versionId", protocol.StringValue(v), metadata)
	}
	return nil
}

type GetObjectTaggingOutput struct {
	_ struct{} `type:"structure"`

	// Contains the tag set.
	//
	// TagSet is a required field
	TagSet []Tag `locationNameList:"Tag" type:"list" required:"true"`

	// The versionId of the object for which you got the tagging information.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s GetObjectTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetObjectTaggingOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.TagSet != nil {
		v := s.TagSet

		metadata := protocol.Metadata{ListLocationName: "Tag"}
		ls0 := e.List(protocol.BodyTarget, "TagSet", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-version-id", protocol.StringValue(v), metadata)
	}
	return nil
}

const opGetObjectTagging = "GetObjectTagging"

// GetObjectTaggingRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns the tag-set of an object. You send the GET request against the tagging
// subresource associated with the object.
//
// To use this operation, you must have permission to perform the s3:GetObjectTagging
// action. By default, the GET operation returns information about current version
// of an object. For a versioned bucket, you can have multiple versions of an
// object in your bucket. To retrieve tags of any other version, use the versionId
// query parameter. You also need permission for the s3:GetObjectVersionTagging
// action.
//
// By default, the bucket owner has this permission and can grant this permission
// to others.
//
// For information about the Amazon S3 object tagging feature, see Object Tagging
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html).
//
// The following operation is related to GetObjectTagging:
//
//    * PutObjectTagging
//
//    // Example sending a request using GetObjectTaggingRequest.
//    req := client.GetObjectTaggingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTagging
func (c *Client) GetObjectTaggingRequest(input *GetObjectTaggingInput) GetObjectTaggingRequest {
	op := &aws.Operation{
		Name:       opGetObjectTagging,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}?tagging",
	}

	if input == nil {
		input = &GetObjectTaggingInput{}
	}

	req := c.newRequest(op, input, &GetObjectTaggingOutput{})
	return GetObjectTaggingRequest{Request: req, Input: input, Copy: c.GetObjectTaggingRequest}
}

// GetObjectTaggingRequest is the request type for the
// GetObjectTagging API operation.
type GetObjectTaggingRequest struct {
	*aws.Request
	Input *GetObjectTaggingInput
	Copy  func(*GetObjectTaggingInput) GetObjectTaggingRequest
}

// Send marshals and sends the GetObjectTagging API request.
func (r GetObjectTaggingRequest) Send(ctx context.Context) (*GetObjectTaggingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetObjectTaggingResponse{
		GetObjectTaggingOutput: r.Request.Data.(*GetObjectTaggingOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetObjectTaggingResponse is the response type for the
// GetObjectTagging API operation.
type GetObjectTaggingResponse struct {
	*GetObjectTaggingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetObjectTagging request.
func (r *GetObjectTaggingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
