// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type PutObjectAclInput struct {
	_ struct{} `type:"structure" payload:"AccessControlPolicy"`

	// The canned ACL to apply to the object. For more information, see Canned ACL
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL).
	ACL ObjectCannedACL `location:"header" locationName:"x-amz-acl" type:"string" enum:"true"`

	// Contains the elements that set the ACL permissions for an object per grantee.
	AccessControlPolicy *AccessControlPolicy `locationName:"AccessControlPolicy" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// The bucket name that contains the object to which you want to attach the
	// ACL.
	//
	// When using this API with an access point, you must direct requests to the
	// access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this operation using an access point through the AWS SDKs, you
	// provide the access point ARN in place of the bucket name. For more information
	// about access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html)
	// in the Amazon Simple Storage Service Developer Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Allows grantee the read, write, read ACP, and write ACP permissions on the
	// bucket.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to list the objects in the bucket.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the bucket ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to create, overwrite, and delete any object in the bucket.
	GrantWrite *string `location:"header" locationName:"x-amz-grant-write" type:"string"`

	// Allows grantee to write the ACL for the applicable bucket.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	// Key for which the PUT operation was initiated.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// For information about downloading objects from Requester Pays buckets, see
	// Downloading Objects in Requestor Pays Buckets (https://docs.aws.amazon.com/http:/docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 Developer Guide.
	RequestPayer RequestPayer `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"true"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s PutObjectAclInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutObjectAclInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutObjectAclInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}
	if s.AccessControlPolicy != nil {
		if err := s.AccessControlPolicy.Validate(); err != nil {
			invalidParams.AddNested("AccessControlPolicy", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutObjectAclInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutObjectAclInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.ACL) > 0 {
		v := s.ACL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-acl", v, metadata)
	}
	if s.GrantFullControl != nil {
		v := *s.GrantFullControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-full-control", protocol.StringValue(v), metadata)
	}
	if s.GrantRead != nil {
		v := *s.GrantRead

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-read", protocol.StringValue(v), metadata)
	}
	if s.GrantReadACP != nil {
		v := *s.GrantReadACP

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-read-acp", protocol.StringValue(v), metadata)
	}
	if s.GrantWrite != nil {
		v := *s.GrantWrite

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-write", protocol.StringValue(v), metadata)
	}
	if s.GrantWriteACP != nil {
		v := *s.GrantWriteACP

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-grant-write-acp", protocol.StringValue(v), metadata)
	}
	if len(s.RequestPayer) > 0 {
		v := s.RequestPayer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-payer", v, metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.AccessControlPolicy != nil {
		v := s.AccessControlPolicy

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "AccessControlPolicy", v, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "versionId", protocol.StringValue(v), metadata)
	}
	return nil
}

type PutObjectAclOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged RequestCharged `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"true"`
}

// String returns the string representation
func (s PutObjectAclOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutObjectAclOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.RequestCharged) > 0 {
		v := s.RequestCharged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-charged", v, metadata)
	}
	return nil
}

const opPutObjectAcl = "PutObjectAcl"

// PutObjectAclRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Uses the acl subresource to set the access control list (ACL) permissions
// for an object that already exists in a bucket. You must have WRITE_ACP permission
// to set the ACL of an object.
//
// Depending on your application needs, you can choose to set the ACL on an
// object using either the request body or the headers. For example, if you
// have an existing application that updates a bucket ACL using the request
// body, you can continue to use that approach.
//
// Access Permissions
//
// You can set access permissions using one of the following methods:
//
//    * Specify a canned ACL with the x-amz-acl request header. Amazon S3 supports
//    a set of predefined ACLs, known as canned ACLs. Each canned ACL has a
//    predefined set of grantees and permissions. Specify the canned ACL name
//    as the value of x-amz-acl. If you use this header, you cannot use other
//    access control-specific headers in your request. For more information,
//    see Canned ACL (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL).
//
//    * Specify access permissions explicitly with the x-amz-grant-read, x-amz-grant-read-acp,
//    x-amz-grant-write-acp, and x-amz-grant-full-control headers. When using
//    these headers, you specify explicit access permissions and grantees (AWS
//    accounts or Amazon S3 groups) who will receive the permission. If you
//    use these ACL-specific headers, you cannot use x-amz-acl header to set
//    a canned ACL. These parameters map to the set of permissions that Amazon
//    S3 supports in an ACL. For more information, see Access Control List (ACL)
//    Overview (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html).
//    You specify each grantee as a type=value pair, where the type is one of
//    the following: emailAddress – if the value specified is the email address
//    of an AWS account id – if the value specified is the canonical user
//    ID of an AWS account uri – if you are granting permissions to a predefined
//    group For example, the following x-amz-grant-read header grants list objects
//    permission to the two AWS accounts identified by their email addresses.
//    x-amz-grant-read: emailAddress="xyz@amazon.com", emailAddress="abc@amazon.com"
//
// You can use either a canned ACL or specify access permissions explicitly.
// You cannot do both.
//
// Grantee Values
//
// You can specify the person (grantee) to whom you're assigning access rights
// (using request elements) in the following ways:
//
//    * By Email address: <Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
//    xsi:type="AmazonCustomerByEmail"><EmailAddress><>Grantees@email.com<></EmailAddress>lt;/Grantee>
//    The grantee is resolved to the CanonicalUser and, in a response to a GET
//    Object acl request, appears as the CanonicalUser.
//
//    * By the person's ID: <Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
//    xsi:type="CanonicalUser"><ID><>ID<></ID><DisplayName><>GranteesEmail<></DisplayName>
//    </Grantee> DisplayName is optional and ignored in the request.
//
//    * By URI: <Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
//    xsi:type="Group"><URI><>http://acs.amazonaws.com/groups/global/AuthenticatedUsers<></URI></Grantee>
//
// Versioning
//
// The ACL of an object is set at the object version level. By default, PUT
// sets the ACL of the current version of an object. To set the ACL of a different
// version, use the versionId subresource.
//
// Related Resources
//
//    * CopyObject
//
//    * GetObject
//
//    // Example sending a request using PutObjectAclRequest.
//    req := client.PutObjectAclRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectAcl
func (c *Client) PutObjectAclRequest(input *PutObjectAclInput) PutObjectAclRequest {
	op := &aws.Operation{
		Name:       opPutObjectAcl,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}?acl",
	}

	if input == nil {
		input = &PutObjectAclInput{}
	}

	req := c.newRequest(op, input, &PutObjectAclOutput{})
	return PutObjectAclRequest{Request: req, Input: input, Copy: c.PutObjectAclRequest}
}

// PutObjectAclRequest is the request type for the
// PutObjectAcl API operation.
type PutObjectAclRequest struct {
	*aws.Request
	Input *PutObjectAclInput
	Copy  func(*PutObjectAclInput) PutObjectAclRequest
}

// Send marshals and sends the PutObjectAcl API request.
func (r PutObjectAclRequest) Send(ctx context.Context) (*PutObjectAclResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutObjectAclResponse{
		PutObjectAclOutput: r.Request.Data.(*PutObjectAclOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutObjectAclResponse is the response type for the
// PutObjectAcl API operation.
type PutObjectAclResponse struct {
	*PutObjectAclOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutObjectAcl request.
func (r *PutObjectAclResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
