// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package s3iface provides an interface to enable mocking the Amazon Simple Storage Service service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package s3iface

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/service/s3"
)

// ClientAPI provides an interface to enable mocking the
// s3.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon S3.
//    func myFunc(svc s3iface.ClientAPI) bool {
//        // Make svc.AbortMultipartUpload request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := s3.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        s3iface.ClientPI
//    }
//    func (m *mockClientClient) AbortMultipartUpload(input *s3.AbortMultipartUploadInput) (*s3.AbortMultipartUploadOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AbortMultipartUploadRequest(*s3.AbortMultipartUploadInput) s3.AbortMultipartUploadRequest

	CompleteMultipartUploadRequest(*s3.CompleteMultipartUploadInput) s3.CompleteMultipartUploadRequest

	CopyObjectRequest(*s3.CopyObjectInput) s3.CopyObjectRequest

	CreateBucketRequest(*s3.CreateBucketInput) s3.CreateBucketRequest

	CreateMultipartUploadRequest(*s3.CreateMultipartUploadInput) s3.CreateMultipartUploadRequest

	DeleteBucketRequest(*s3.DeleteBucketInput) s3.DeleteBucketRequest

	DeleteBucketAnalyticsConfigurationRequest(*s3.DeleteBucketAnalyticsConfigurationInput) s3.DeleteBucketAnalyticsConfigurationRequest

	DeleteBucketCorsRequest(*s3.DeleteBucketCorsInput) s3.DeleteBucketCorsRequest

	DeleteBucketEncryptionRequest(*s3.DeleteBucketEncryptionInput) s3.DeleteBucketEncryptionRequest

	DeleteBucketInventoryConfigurationRequest(*s3.DeleteBucketInventoryConfigurationInput) s3.DeleteBucketInventoryConfigurationRequest

	DeleteBucketLifecycleRequest(*s3.DeleteBucketLifecycleInput) s3.DeleteBucketLifecycleRequest

	DeleteBucketMetricsConfigurationRequest(*s3.DeleteBucketMetricsConfigurationInput) s3.DeleteBucketMetricsConfigurationRequest

	DeleteBucketPolicyRequest(*s3.DeleteBucketPolicyInput) s3.DeleteBucketPolicyRequest

	DeleteBucketReplicationRequest(*s3.DeleteBucketReplicationInput) s3.DeleteBucketReplicationRequest

	DeleteBucketTaggingRequest(*s3.DeleteBucketTaggingInput) s3.DeleteBucketTaggingRequest

	DeleteBucketWebsiteRequest(*s3.DeleteBucketWebsiteInput) s3.DeleteBucketWebsiteRequest

	DeleteObjectRequest(*s3.DeleteObjectInput) s3.DeleteObjectRequest

	DeleteObjectTaggingRequest(*s3.DeleteObjectTaggingInput) s3.DeleteObjectTaggingRequest

	DeleteObjectsRequest(*s3.DeleteObjectsInput) s3.DeleteObjectsRequest

	DeletePublicAccessBlockRequest(*s3.DeletePublicAccessBlockInput) s3.DeletePublicAccessBlockRequest

	GetBucketAccelerateConfigurationRequest(*s3.GetBucketAccelerateConfigurationInput) s3.GetBucketAccelerateConfigurationRequest

	GetBucketAclRequest(*s3.GetBucketAclInput) s3.GetBucketAclRequest

	GetBucketAnalyticsConfigurationRequest(*s3.GetBucketAnalyticsConfigurationInput) s3.GetBucketAnalyticsConfigurationRequest

	GetBucketCorsRequest(*s3.GetBucketCorsInput) s3.GetBucketCorsRequest

	GetBucketEncryptionRequest(*s3.GetBucketEncryptionInput) s3.GetBucketEncryptionRequest

	GetBucketInventoryConfigurationRequest(*s3.GetBucketInventoryConfigurationInput) s3.GetBucketInventoryConfigurationRequest

	GetBucketLifecycleRequest(*s3.GetBucketLifecycleInput) s3.GetBucketLifecycleRequest

	GetBucketLifecycleConfigurationRequest(*s3.GetBucketLifecycleConfigurationInput) s3.GetBucketLifecycleConfigurationRequest

	GetBucketLocationRequest(*s3.GetBucketLocationInput) s3.GetBucketLocationRequest

	GetBucketLoggingRequest(*s3.GetBucketLoggingInput) s3.GetBucketLoggingRequest

	GetBucketMetricsConfigurationRequest(*s3.GetBucketMetricsConfigurationInput) s3.GetBucketMetricsConfigurationRequest

	GetBucketNotificationRequest(*s3.GetBucketNotificationInput) s3.GetBucketNotificationRequest

	GetBucketNotificationConfigurationRequest(*s3.GetBucketNotificationConfigurationInput) s3.GetBucketNotificationConfigurationRequest

	GetBucketPolicyRequest(*s3.GetBucketPolicyInput) s3.GetBucketPolicyRequest

	GetBucketPolicyStatusRequest(*s3.GetBucketPolicyStatusInput) s3.GetBucketPolicyStatusRequest

	GetBucketReplicationRequest(*s3.GetBucketReplicationInput) s3.GetBucketReplicationRequest

	GetBucketRequestPaymentRequest(*s3.GetBucketRequestPaymentInput) s3.GetBucketRequestPaymentRequest

	GetBucketTaggingRequest(*s3.GetBucketTaggingInput) s3.GetBucketTaggingRequest

	GetBucketVersioningRequest(*s3.GetBucketVersioningInput) s3.GetBucketVersioningRequest

	GetBucketWebsiteRequest(*s3.GetBucketWebsiteInput) s3.GetBucketWebsiteRequest

	GetObjectRequest(*s3.GetObjectInput) s3.GetObjectRequest

	GetObjectAclRequest(*s3.GetObjectAclInput) s3.GetObjectAclRequest

	GetObjectLegalHoldRequest(*s3.GetObjectLegalHoldInput) s3.GetObjectLegalHoldRequest

	GetObjectLockConfigurationRequest(*s3.GetObjectLockConfigurationInput) s3.GetObjectLockConfigurationRequest

	GetObjectRetentionRequest(*s3.GetObjectRetentionInput) s3.GetObjectRetentionRequest

	GetObjectTaggingRequest(*s3.GetObjectTaggingInput) s3.GetObjectTaggingRequest

	GetObjectTorrentRequest(*s3.GetObjectTorrentInput) s3.GetObjectTorrentRequest

	GetPublicAccessBlockRequest(*s3.GetPublicAccessBlockInput) s3.GetPublicAccessBlockRequest

	HeadBucketRequest(*s3.HeadBucketInput) s3.HeadBucketRequest

	HeadObjectRequest(*s3.HeadObjectInput) s3.HeadObjectRequest

	ListBucketAnalyticsConfigurationsRequest(*s3.ListBucketAnalyticsConfigurationsInput) s3.ListBucketAnalyticsConfigurationsRequest

	ListBucketInventoryConfigurationsRequest(*s3.ListBucketInventoryConfigurationsInput) s3.ListBucketInventoryConfigurationsRequest

	ListBucketMetricsConfigurationsRequest(*s3.ListBucketMetricsConfigurationsInput) s3.ListBucketMetricsConfigurationsRequest

	ListBucketsRequest(*s3.ListBucketsInput) s3.ListBucketsRequest

	ListMultipartUploadsRequest(*s3.ListMultipartUploadsInput) s3.ListMultipartUploadsRequest

	ListObjectVersionsRequest(*s3.ListObjectVersionsInput) s3.ListObjectVersionsRequest

	ListObjectsRequest(*s3.ListObjectsInput) s3.ListObjectsRequest

	ListObjectsV2Request(*s3.ListObjectsV2Input) s3.ListObjectsV2Request

	ListPartsRequest(*s3.ListPartsInput) s3.ListPartsRequest

	PutBucketAccelerateConfigurationRequest(*s3.PutBucketAccelerateConfigurationInput) s3.PutBucketAccelerateConfigurationRequest

	PutBucketAclRequest(*s3.PutBucketAclInput) s3.PutBucketAclRequest

	PutBucketAnalyticsConfigurationRequest(*s3.PutBucketAnalyticsConfigurationInput) s3.PutBucketAnalyticsConfigurationRequest

	PutBucketCorsRequest(*s3.PutBucketCorsInput) s3.PutBucketCorsRequest

	PutBucketEncryptionRequest(*s3.PutBucketEncryptionInput) s3.PutBucketEncryptionRequest

	PutBucketInventoryConfigurationRequest(*s3.PutBucketInventoryConfigurationInput) s3.PutBucketInventoryConfigurationRequest

	PutBucketLifecycleRequest(*s3.PutBucketLifecycleInput) s3.PutBucketLifecycleRequest

	PutBucketLifecycleConfigurationRequest(*s3.PutBucketLifecycleConfigurationInput) s3.PutBucketLifecycleConfigurationRequest

	PutBucketLoggingRequest(*s3.PutBucketLoggingInput) s3.PutBucketLoggingRequest

	PutBucketMetricsConfigurationRequest(*s3.PutBucketMetricsConfigurationInput) s3.PutBucketMetricsConfigurationRequest

	PutBucketNotificationRequest(*s3.PutBucketNotificationInput) s3.PutBucketNotificationRequest

	PutBucketNotificationConfigurationRequest(*s3.PutBucketNotificationConfigurationInput) s3.PutBucketNotificationConfigurationRequest

	PutBucketPolicyRequest(*s3.PutBucketPolicyInput) s3.PutBucketPolicyRequest

	PutBucketReplicationRequest(*s3.PutBucketReplicationInput) s3.PutBucketReplicationRequest

	PutBucketRequestPaymentRequest(*s3.PutBucketRequestPaymentInput) s3.PutBucketRequestPaymentRequest

	PutBucketTaggingRequest(*s3.PutBucketTaggingInput) s3.PutBucketTaggingRequest

	PutBucketVersioningRequest(*s3.PutBucketVersioningInput) s3.PutBucketVersioningRequest

	PutBucketWebsiteRequest(*s3.PutBucketWebsiteInput) s3.PutBucketWebsiteRequest

	PutObjectRequest(*s3.PutObjectInput) s3.PutObjectRequest

	PutObjectAclRequest(*s3.PutObjectAclInput) s3.PutObjectAclRequest

	PutObjectLegalHoldRequest(*s3.PutObjectLegalHoldInput) s3.PutObjectLegalHoldRequest

	PutObjectLockConfigurationRequest(*s3.PutObjectLockConfigurationInput) s3.PutObjectLockConfigurationRequest

	PutObjectRetentionRequest(*s3.PutObjectRetentionInput) s3.PutObjectRetentionRequest

	PutObjectTaggingRequest(*s3.PutObjectTaggingInput) s3.PutObjectTaggingRequest

	PutPublicAccessBlockRequest(*s3.PutPublicAccessBlockInput) s3.PutPublicAccessBlockRequest

	RestoreObjectRequest(*s3.RestoreObjectInput) s3.RestoreObjectRequest

	UploadPartRequest(*s3.UploadPartInput) s3.UploadPartRequest

	UploadPartCopyRequest(*s3.UploadPartCopyInput) s3.UploadPartCopyRequest

	WaitUntilBucketExists(context.Context, *s3.HeadBucketInput, ...aws.WaiterOption) error

	WaitUntilBucketNotExists(context.Context, *s3.HeadBucketInput, ...aws.WaiterOption) error

	WaitUntilObjectExists(context.Context, *s3.HeadObjectInput, ...aws.WaiterOption) error

	WaitUntilObjectNotExists(context.Context, *s3.HeadObjectInput, ...aws.WaiterOption) error
}

var _ ClientAPI = (*s3.Client)(nil)
