// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateNotebookInstanceLifecycleConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the lifecycle configuration.
	//
	// NotebookInstanceLifecycleConfigName is a required field
	NotebookInstanceLifecycleConfigName *string `type:"string" required:"true"`

	// A shell script that runs only once, when you create a notebook instance.
	// The shell script must be a base64-encoded string.
	OnCreate []NotebookInstanceLifecycleHook `type:"list"`

	// A shell script that runs every time you start a notebook instance, including
	// when you create the notebook instance. The shell script must be a base64-encoded
	// string.
	OnStart []NotebookInstanceLifecycleHook `type:"list"`
}

// String returns the string representation
func (s CreateNotebookInstanceLifecycleConfigInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNotebookInstanceLifecycleConfigInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateNotebookInstanceLifecycleConfigInput"}

	if s.NotebookInstanceLifecycleConfigName == nil {
		invalidParams.Add(aws.NewErrParamRequired("NotebookInstanceLifecycleConfigName"))
	}
	if s.OnCreate != nil {
		for i, v := range s.OnCreate {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OnCreate", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.OnStart != nil {
		for i, v := range s.OnStart {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OnStart", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateNotebookInstanceLifecycleConfigOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the lifecycle configuration.
	NotebookInstanceLifecycleConfigArn *string `type:"string"`
}

// String returns the string representation
func (s CreateNotebookInstanceLifecycleConfigOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateNotebookInstanceLifecycleConfig = "CreateNotebookInstanceLifecycleConfig"

// CreateNotebookInstanceLifecycleConfigRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Creates a lifecycle configuration that you can associate with a notebook
// instance. A lifecycle configuration is a collection of shell scripts that
// run when you create or start a notebook instance.
//
// Each lifecycle configuration script has a limit of 16384 characters.
//
// The value of the $PATH environment variable that is available to both scripts
// is /sbin:bin:/usr/sbin:/usr/bin.
//
// View CloudWatch Logs for notebook instance lifecycle configurations in log
// group /aws/sagemaker/NotebookInstances in log stream [notebook-instance-name]/[LifecycleConfigHook].
//
// Lifecycle configuration scripts cannot run for longer than 5 minutes. If
// a script runs for longer than 5 minutes, it fails and the notebook instance
// is not created or started.
//
// For information about notebook instance lifestyle configurations, see Step
// 2.1: (Optional) Customize a Notebook Instance (https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
//
//    // Example sending a request using CreateNotebookInstanceLifecycleConfigRequest.
//    req := client.CreateNotebookInstanceLifecycleConfigRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstanceLifecycleConfig
func (c *Client) CreateNotebookInstanceLifecycleConfigRequest(input *CreateNotebookInstanceLifecycleConfigInput) CreateNotebookInstanceLifecycleConfigRequest {
	op := &aws.Operation{
		Name:       opCreateNotebookInstanceLifecycleConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNotebookInstanceLifecycleConfigInput{}
	}

	req := c.newRequest(op, input, &CreateNotebookInstanceLifecycleConfigOutput{})
	return CreateNotebookInstanceLifecycleConfigRequest{Request: req, Input: input, Copy: c.CreateNotebookInstanceLifecycleConfigRequest}
}

// CreateNotebookInstanceLifecycleConfigRequest is the request type for the
// CreateNotebookInstanceLifecycleConfig API operation.
type CreateNotebookInstanceLifecycleConfigRequest struct {
	*aws.Request
	Input *CreateNotebookInstanceLifecycleConfigInput
	Copy  func(*CreateNotebookInstanceLifecycleConfigInput) CreateNotebookInstanceLifecycleConfigRequest
}

// Send marshals and sends the CreateNotebookInstanceLifecycleConfig API request.
func (r CreateNotebookInstanceLifecycleConfigRequest) Send(ctx context.Context) (*CreateNotebookInstanceLifecycleConfigResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateNotebookInstanceLifecycleConfigResponse{
		CreateNotebookInstanceLifecycleConfigOutput: r.Request.Data.(*CreateNotebookInstanceLifecycleConfigOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateNotebookInstanceLifecycleConfigResponse is the response type for the
// CreateNotebookInstanceLifecycleConfig API operation.
type CreateNotebookInstanceLifecycleConfigResponse struct {
	*CreateNotebookInstanceLifecycleConfigOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateNotebookInstanceLifecycleConfig request.
func (r *CreateNotebookInstanceLifecycleConfigResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
