// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeAppInput struct {
	_ struct{} `type:"structure"`

	// The name of the app.
	//
	// AppName is a required field
	AppName *string `type:"string" required:"true"`

	// The type of app.
	//
	// AppType is a required field
	AppType AppType `type:"string" required:"true" enum:"true"`

	// The domain ID.
	//
	// DomainId is a required field
	DomainId *string `type:"string" required:"true"`

	// The user profile name.
	//
	// UserProfileName is a required field
	UserProfileName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAppInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAppInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAppInput"}

	if s.AppName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AppName"))
	}
	if len(s.AppType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("AppType"))
	}

	if s.DomainId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainId"))
	}

	if s.UserProfileName == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserProfileName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeAppOutput struct {
	_ struct{} `type:"structure"`

	// The app's Amazon Resource Name (ARN).
	AppArn *string `type:"string"`

	// The name of the app.
	AppName *string `type:"string"`

	// The type of app.
	AppType AppType `type:"string" enum:"true"`

	// The creation time.
	CreationTime *time.Time `type:"timestamp"`

	// The domain ID.
	DomainId *string `type:"string"`

	// The failure reason.
	FailureReason *string `type:"string"`

	// The timestamp of the last health check.
	LastHealthCheckTimestamp *time.Time `type:"timestamp"`

	// The timestamp of the last user's activity.
	LastUserActivityTimestamp *time.Time `type:"timestamp"`

	// The instance type and quantity.
	ResourceSpec *ResourceSpec `type:"structure"`

	// The status.
	Status AppStatus `type:"string" enum:"true"`

	// The user profile name.
	UserProfileName *string `type:"string"`
}

// String returns the string representation
func (s DescribeAppOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeApp = "DescribeApp"

// DescribeAppRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Describes the app.
//
//    // Example sending a request using DescribeAppRequest.
//    req := client.DescribeAppRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeApp
func (c *Client) DescribeAppRequest(input *DescribeAppInput) DescribeAppRequest {
	op := &aws.Operation{
		Name:       opDescribeApp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAppInput{}
	}

	req := c.newRequest(op, input, &DescribeAppOutput{})
	return DescribeAppRequest{Request: req, Input: input, Copy: c.DescribeAppRequest}
}

// DescribeAppRequest is the request type for the
// DescribeApp API operation.
type DescribeAppRequest struct {
	*aws.Request
	Input *DescribeAppInput
	Copy  func(*DescribeAppInput) DescribeAppRequest
}

// Send marshals and sends the DescribeApp API request.
func (r DescribeAppRequest) Send(ctx context.Context) (*DescribeAppResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAppResponse{
		DescribeAppOutput: r.Request.Data.(*DescribeAppOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAppResponse is the response type for the
// DescribeApp API operation.
type DescribeAppResponse struct {
	*DescribeAppOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeApp request.
func (r *DescribeAppResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
