// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeHumanTaskUiInput struct {
	_ struct{} `type:"structure"`

	// The name of the human task user interface you want information about.
	//
	// HumanTaskUiName is a required field
	HumanTaskUiName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeHumanTaskUiInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeHumanTaskUiInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeHumanTaskUiInput"}

	if s.HumanTaskUiName == nil {
		invalidParams.Add(aws.NewErrParamRequired("HumanTaskUiName"))
	}
	if s.HumanTaskUiName != nil && len(*s.HumanTaskUiName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("HumanTaskUiName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeHumanTaskUiOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp when the human task user interface was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) of the human task user interface.
	//
	// HumanTaskUiArn is a required field
	HumanTaskUiArn *string `type:"string" required:"true"`

	// The name of the human task user interface.
	//
	// HumanTaskUiName is a required field
	HumanTaskUiName *string `min:"1" type:"string" required:"true"`

	// Container for user interface template information.
	//
	// UiTemplate is a required field
	UiTemplate *UiTemplateInfo `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeHumanTaskUiOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeHumanTaskUi = "DescribeHumanTaskUi"

// DescribeHumanTaskUiRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Returns information about the requested human task user interface.
//
//    // Example sending a request using DescribeHumanTaskUiRequest.
//    req := client.DescribeHumanTaskUiRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHumanTaskUi
func (c *Client) DescribeHumanTaskUiRequest(input *DescribeHumanTaskUiInput) DescribeHumanTaskUiRequest {
	op := &aws.Operation{
		Name:       opDescribeHumanTaskUi,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeHumanTaskUiInput{}
	}

	req := c.newRequest(op, input, &DescribeHumanTaskUiOutput{})
	return DescribeHumanTaskUiRequest{Request: req, Input: input, Copy: c.DescribeHumanTaskUiRequest}
}

// DescribeHumanTaskUiRequest is the request type for the
// DescribeHumanTaskUi API operation.
type DescribeHumanTaskUiRequest struct {
	*aws.Request
	Input *DescribeHumanTaskUiInput
	Copy  func(*DescribeHumanTaskUiInput) DescribeHumanTaskUiRequest
}

// Send marshals and sends the DescribeHumanTaskUi API request.
func (r DescribeHumanTaskUiRequest) Send(ctx context.Context) (*DescribeHumanTaskUiResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeHumanTaskUiResponse{
		DescribeHumanTaskUiOutput: r.Request.Data.(*DescribeHumanTaskUiOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeHumanTaskUiResponse is the response type for the
// DescribeHumanTaskUi API operation.
type DescribeHumanTaskUiResponse struct {
	*DescribeHumanTaskUiOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeHumanTaskUi request.
func (r *DescribeHumanTaskUiResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
