// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeNotebookInstanceLifecycleConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the lifecycle configuration to describe.
	//
	// NotebookInstanceLifecycleConfigName is a required field
	NotebookInstanceLifecycleConfigName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeNotebookInstanceLifecycleConfigInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeNotebookInstanceLifecycleConfigInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeNotebookInstanceLifecycleConfigInput"}

	if s.NotebookInstanceLifecycleConfigName == nil {
		invalidParams.Add(aws.NewErrParamRequired("NotebookInstanceLifecycleConfigName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeNotebookInstanceLifecycleConfigOutput struct {
	_ struct{} `type:"structure"`

	// A timestamp that tells when the lifecycle configuration was created.
	CreationTime *time.Time `type:"timestamp"`

	// A timestamp that tells when the lifecycle configuration was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the lifecycle configuration.
	NotebookInstanceLifecycleConfigArn *string `type:"string"`

	// The name of the lifecycle configuration.
	NotebookInstanceLifecycleConfigName *string `type:"string"`

	// The shell script that runs only once, when you create a notebook instance.
	OnCreate []NotebookInstanceLifecycleHook `type:"list"`

	// The shell script that runs every time you start a notebook instance, including
	// when you create the notebook instance.
	OnStart []NotebookInstanceLifecycleHook `type:"list"`
}

// String returns the string representation
func (s DescribeNotebookInstanceLifecycleConfigOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeNotebookInstanceLifecycleConfig = "DescribeNotebookInstanceLifecycleConfig"

// DescribeNotebookInstanceLifecycleConfigRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Returns a description of a notebook instance lifecycle configuration.
//
// For information about notebook instance lifestyle configurations, see Step
// 2.1: (Optional) Customize a Notebook Instance (https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
//
//    // Example sending a request using DescribeNotebookInstanceLifecycleConfigRequest.
//    req := client.DescribeNotebookInstanceLifecycleConfigRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstanceLifecycleConfig
func (c *Client) DescribeNotebookInstanceLifecycleConfigRequest(input *DescribeNotebookInstanceLifecycleConfigInput) DescribeNotebookInstanceLifecycleConfigRequest {
	op := &aws.Operation{
		Name:       opDescribeNotebookInstanceLifecycleConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNotebookInstanceLifecycleConfigInput{}
	}

	req := c.newRequest(op, input, &DescribeNotebookInstanceLifecycleConfigOutput{})
	return DescribeNotebookInstanceLifecycleConfigRequest{Request: req, Input: input, Copy: c.DescribeNotebookInstanceLifecycleConfigRequest}
}

// DescribeNotebookInstanceLifecycleConfigRequest is the request type for the
// DescribeNotebookInstanceLifecycleConfig API operation.
type DescribeNotebookInstanceLifecycleConfigRequest struct {
	*aws.Request
	Input *DescribeNotebookInstanceLifecycleConfigInput
	Copy  func(*DescribeNotebookInstanceLifecycleConfigInput) DescribeNotebookInstanceLifecycleConfigRequest
}

// Send marshals and sends the DescribeNotebookInstanceLifecycleConfig API request.
func (r DescribeNotebookInstanceLifecycleConfigRequest) Send(ctx context.Context) (*DescribeNotebookInstanceLifecycleConfigResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeNotebookInstanceLifecycleConfigResponse{
		DescribeNotebookInstanceLifecycleConfigOutput: r.Request.Data.(*DescribeNotebookInstanceLifecycleConfigOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeNotebookInstanceLifecycleConfigResponse is the response type for the
// DescribeNotebookInstanceLifecycleConfig API operation.
type DescribeNotebookInstanceLifecycleConfigResponse struct {
	*DescribeNotebookInstanceLifecycleConfigOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeNotebookInstanceLifecycleConfig request.
func (r *DescribeNotebookInstanceLifecycleConfigResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
