// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListAppsInput struct {
	_ struct{} `type:"structure"`

	// A parameter to search for the domain ID.
	DomainIdEquals *string `type:"string"`

	// Returns a list up to a specified limit.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was truncated, you will receive this token. Use
	// it in your next request to receive the next set of results.
	NextToken *string `type:"string"`

	// The parameter by which to sort the results. The default is CreationTime.
	SortBy AppSortKey `type:"string" enum:"true"`

	// The sort order for the results. The default is Ascending.
	SortOrder SortOrder `type:"string" enum:"true"`

	// A parameter to search by user profile name.
	UserProfileNameEquals *string `type:"string"`
}

// String returns the string representation
func (s ListAppsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAppsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListAppsOutput struct {
	_ struct{} `type:"structure"`

	// The list of apps.
	Apps []AppDetails `type:"list"`

	// If the previous response was truncated, you will receive this token. Use
	// it in your next request to receive the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAppsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListApps = "ListApps"

// ListAppsRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Lists apps.
//
//    // Example sending a request using ListAppsRequest.
//    req := client.ListAppsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListApps
func (c *Client) ListAppsRequest(input *ListAppsInput) ListAppsRequest {
	op := &aws.Operation{
		Name:       opListApps,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppsInput{}
	}

	req := c.newRequest(op, input, &ListAppsOutput{})
	return ListAppsRequest{Request: req, Input: input, Copy: c.ListAppsRequest}
}

// ListAppsRequest is the request type for the
// ListApps API operation.
type ListAppsRequest struct {
	*aws.Request
	Input *ListAppsInput
	Copy  func(*ListAppsInput) ListAppsRequest
}

// Send marshals and sends the ListApps API request.
func (r ListAppsRequest) Send(ctx context.Context) (*ListAppsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAppsResponse{
		ListAppsOutput: r.Request.Data.(*ListAppsOutput),
		response:       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListAppsRequestPaginator returns a paginator for ListApps.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListAppsRequest(input)
//   p := sagemaker.NewListAppsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListAppsPaginator(req ListAppsRequest) ListAppsPaginator {
	return ListAppsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListAppsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListAppsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListAppsPaginator struct {
	aws.Pager
}

func (p *ListAppsPaginator) CurrentPage() *ListAppsOutput {
	return p.Pager.CurrentPage().(*ListAppsOutput)
}

// ListAppsResponse is the response type for the
// ListApps API operation.
type ListAppsResponse struct {
	*ListAppsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListApps request.
func (r *ListAppsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
