// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateEndpointInput struct {
	_ struct{} `type:"structure"`

	// The name of the new endpoint configuration.
	//
	// EndpointConfigName is a required field
	EndpointConfigName *string `type:"string" required:"true"`

	// The name of the endpoint whose configuration you want to update.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEndpointInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateEndpointInput"}

	if s.EndpointConfigName == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndpointConfigName"))
	}

	if s.EndpointName == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndpointName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateEndpoint = "UpdateEndpoint"

// UpdateEndpointRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Deploys the new EndpointConfig specified in the request, switches to using
// newly created endpoint, and then deletes resources provisioned for the endpoint
// using the previous EndpointConfig (there is no availability loss).
//
// When Amazon SageMaker receives the request, it sets the endpoint status to
// Updating. After updating the endpoint, it sets the status to InService. To
// check the status of an endpoint, use the DescribeEndpoint (https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeEndpoint.html)
// API.
//
// You must not delete an EndpointConfig in use by an endpoint that is live
// or while the UpdateEndpoint or CreateEndpoint operations are being performed
// on the endpoint. To update an endpoint, you must create a new EndpointConfig.
//
//    // Example sending a request using UpdateEndpointRequest.
//    req := client.UpdateEndpointRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateEndpoint
func (c *Client) UpdateEndpointRequest(input *UpdateEndpointInput) UpdateEndpointRequest {
	op := &aws.Operation{
		Name:       opUpdateEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEndpointInput{}
	}

	req := c.newRequest(op, input, &UpdateEndpointOutput{})
	return UpdateEndpointRequest{Request: req, Input: input, Copy: c.UpdateEndpointRequest}
}

// UpdateEndpointRequest is the request type for the
// UpdateEndpoint API operation.
type UpdateEndpointRequest struct {
	*aws.Request
	Input *UpdateEndpointInput
	Copy  func(*UpdateEndpointInput) UpdateEndpointRequest
}

// Send marshals and sends the UpdateEndpoint API request.
func (r UpdateEndpointRequest) Send(ctx context.Context) (*UpdateEndpointResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateEndpointResponse{
		UpdateEndpointOutput: r.Request.Data.(*UpdateEndpointOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateEndpointResponse is the response type for the
// UpdateEndpoint API operation.
type UpdateEndpointResponse struct {
	*UpdateEndpointOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateEndpoint request.
func (r *UpdateEndpointResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
