// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package securityhub

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateFindingsInput struct {
	_ struct{} `type:"structure"`

	// A collection of attributes that specify which findings you want to update.
	//
	// Filters is a required field
	Filters *AwsSecurityFindingFilters `type:"structure" required:"true"`

	// The updated note for the finding.
	Note *NoteUpdate `type:"structure"`

	// The updated record state for the finding.
	RecordState RecordState `type:"string" enum:"true"`
}

// String returns the string representation
func (s UpdateFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFindingsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateFindingsInput"}

	if s.Filters == nil {
		invalidParams.Add(aws.NewErrParamRequired("Filters"))
	}
	if s.Note != nil {
		if err := s.Note.Validate(); err != nil {
			invalidParams.AddNested("Note", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateFindingsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Filters != nil {
		v := s.Filters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filters", v, metadata)
	}
	if s.Note != nil {
		v := s.Note

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Note", v, metadata)
	}
	if len(s.RecordState) > 0 {
		v := s.RecordState

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecordState", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

type UpdateFindingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateFindingsOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUpdateFindings = "UpdateFindings"

// UpdateFindingsRequest returns a request value for making API operation for
// AWS SecurityHub.
//
// Updates the Note and RecordState of the Security Hub-aggregated findings
// that the filter attributes specify. Any member account that can view the
// finding also sees the update to the finding.
//
//    // Example sending a request using UpdateFindingsRequest.
//    req := client.UpdateFindingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindings
func (c *Client) UpdateFindingsRequest(input *UpdateFindingsInput) UpdateFindingsRequest {
	op := &aws.Operation{
		Name:       opUpdateFindings,
		HTTPMethod: "PATCH",
		HTTPPath:   "/findings",
	}

	if input == nil {
		input = &UpdateFindingsInput{}
	}

	req := c.newRequest(op, input, &UpdateFindingsOutput{})
	return UpdateFindingsRequest{Request: req, Input: input, Copy: c.UpdateFindingsRequest}
}

// UpdateFindingsRequest is the request type for the
// UpdateFindings API operation.
type UpdateFindingsRequest struct {
	*aws.Request
	Input *UpdateFindingsInput
	Copy  func(*UpdateFindingsInput) UpdateFindingsRequest
}

// Send marshals and sends the UpdateFindings API request.
func (r UpdateFindingsRequest) Send(ctx context.Context) (*UpdateFindingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateFindingsResponse{
		UpdateFindingsOutput: r.Request.Data.(*UpdateFindingsOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateFindingsResponse is the response type for the
// UpdateFindings API operation.
type UpdateFindingsResponse struct {
	*UpdateFindingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateFindings request.
func (r *UpdateFindingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
